/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.archive.jcr;

import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.CompositeBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.tasker.Phase;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.StepBlock;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.BlockType;
import com.xebialabs.deployit.task.archive.jcr.TaskArchiver$;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import org.joda.time.DateTime;
import scala.Function1;
import scala.MatchError;
import scala.collection.convert.ImplicitConversions$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015caB\u0001\u0003!\u0003\r\ta\u0004\u0002\r)\u0006\u001c8.\u0011:dQ&4XM\u001d\u0006\u0003\u0007\u0011\t1A[2s\u0015\t)a!A\u0004be\u000eD\u0017N^3\u000b\u0005\u001dA\u0011\u0001\u0002;bg.T!!\u0003\u0006\u0002\u0011\u0011,\u0007\u000f\\8zSRT!a\u0003\u0007\u0002\u0013a,'-[1mC\n\u001c(\"A\u0007\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004%S:LG\u000f\n\u000b\u00023A\u0011\u0011CG\u0005\u00037I\u0011A!\u00168ji\")q\u0001\u0001D\u0001;U\ta\u0004\u0005\u0002 M5\t\u0001E\u0003\u0002\"E\u0005IQ\r_3dkRLwN\u001c\u0006\u0003G\u0011\n1!\u00199j\u0015\t)\u0003\"\u0001\u0004f]\u001eLg.Z\u0005\u0003O\u0001\u0012Q\u0002V1tW^KG\u000f\u001b\"m_\u000e\\\u0007\"B\u0015\u0001\r\u0003Q\u0013\u0001B:bm\u0016$\"!G\u0016\t\u000b1B\u0003\u0019A\u0017\u0002\u0011I|w\u000e\u001e(pI\u0016\u0004\"A\f\u001a\u000e\u0003=R!a\u0001\u0019\u000b\u0003E\nQA[1wCbL!aM\u0018\u0003\t9{G-\u001a\u0005\u0006k\u0001!\tBN\u0001\u000fGJ,\u0017\r^3UCN\\gj\u001c3f)\tis\u0007C\u0003-i\u0001\u0007Q\u0006C\u0003:\u0001\u0011E!(\u0001\u0007gS2dG+Y:l\u001d>$W\rF\u0002\u001awuBQ\u0001\u0010\u001dA\u00025\n\u0001\u0002^1tW:{G-\u001a\u0005\b}a\u0002\n\u00111\u0001@\u0003)1\u0017\u000e\u001c7CY>\u001c7n\u001d\t\u0003#\u0001K!!\u0011\n\u0003\u000f\t{w\u000e\\3b]\")1\t\u0001C\u0005\t\u0006ia-\u001b7m%>|GO\u00117pG.$2!G#G\u0011\u0015a$\t1\u0001.\u0011\u00159%\t1\u0001I\u0003\u0015\u0011Gn\\2l!\ty\u0012*\u0003\u0002KA\tQ!\t\\8dWN#\u0018\r^3\t\u000b1\u0003A\u0011B'\u0002\u001b\u0019LG\u000e\u001c\"m_\u000e\\gj\u001c3f)\rIbj\u0014\u0005\u0006y-\u0003\r!\f\u0005\u0006\u000f.\u0003\r\u0001\u0013\u0005\u0006#\u0002!IAU\u0001\u0013M&dG\u000e\u00155bg\u0016\u001cuN\u001c;bS:,'\u000fF\u0002\u001a'VCQ\u0001\u0016)A\u00025\n\u0011B\u00197pG.tu\u000eZ3\t\u000bY\u0003\u0006\u0019A,\u0002\u0013\r|g\u000e^1j]\u0016\u0014\bC\u0001-\\\u001b\u0005I&B\u0001.%\u0003\u0019!\u0018m]6fe&\u0011A,\u0017\u0002\u000f!\"\f7/Z\"p]R\f\u0017N\\3s\u0011\u0015q\u0006\u0001\"\u0003`\u0003%1\u0017\u000e\u001c7QQ\u0006\u001cX\rF\u0002\u001aA\u0006DQ\u0001V/A\u00025BQAY/A\u0002\r\fQ\u0001\u001d5bg\u0016\u0004\"\u0001\u00173\n\u0005\u0015L&!\u0002)iCN,\u0007\"B4\u0001\t\u0013A\u0017A\u00054jY2\u001cu.\u001c9pg&$XM\u00117pG.$2!G5k\u0011\u0015!f\r1\u0001.\u0011\u00159e\r1\u0001l!\tyB.\u0003\u0002nA\t\u00192i\\7q_NLG/\u001a\"m_\u000e\\7\u000b^1uK\")q\u000e\u0001C\u0005a\u0006ia-\u001b7m'R,\u0007O\u00117pG.$2!G9s\u0011\u0015!f\u000e1\u0001.\u0011\u00159e\u000e1\u0001t!\tAF/\u0003\u0002v3\nI1\u000b^3q\u00052|7m\u001b\u0005\u0006o\u0002!I\u0001_\u0001\rM&dGn\u0015;fa:{G-\u001a\u000b\u00043eT\b\"\u0002\u001fw\u0001\u0004i\u0003\"B>w\u0001\u0004a\u0018!B:uKB\u001c\b#B?\u0002\u0006\u0005%Q\"\u0001@\u000b\u0007}\f\t!\u0001\u0003vi&d'BAA\u0002\u0003\u0011Q\u0017M^1\n\u0007\u0005\u001daP\u0001\u0003MSN$\bcA\u0010\u0002\f%\u0019\u0011Q\u0002\u0011\u0003\u0013M#X\r]*uCR,\u0007\"CA\t\u0001E\u0005I\u0011CA\n\u0003Y1\u0017\u000e\u001c7UCN\\gj\u001c3fI\u0011,g-Y;mi\u0012\u0012TCAA\u000bU\ry\u0014qC\u0016\u0003\u00033\u0001B!a\u0007\u0002&5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0005\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002(\u0005u!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001e9\u00111\u0006\u0002\t\u0002\u00055\u0012\u0001\u0004+bg.\f%o\u00195jm\u0016\u0014\b\u0003BA\u0018\u0003ci\u0011A\u0001\u0004\u0007\u0003\tA\t!a\r\u0014\u0007\u0005E\u0002\u0003\u0003\u0005\u00028\u0005EB\u0011AA\u001d\u0003\u0019a\u0014N\\5u}Q\u0011\u0011Q\u0006\u0005\t\u0003{\t\t\u0004\"\u0001\u0002@\u0005)\u0011\r\u001d9msR!\u0011\u0011IA\"!\r\ty\u0003\u0001\u0005\u0007\u000f\u0005m\u0002\u0019\u0001\u0010")
public interface TaskArchiver {
    public static TaskArchiver apply(TaskWithBlock taskWithBlock) {
        return TaskArchiver$.MODULE$.apply(taskWithBlock);
    }

    public TaskWithBlock task();

    public void save(Node var1);

    public static /* synthetic */ Node createTaskNode$(TaskArchiver $this, Node rootNode) {
        return $this.createTaskNode(rootNode);
    }

    /*
     * WARNING - void declaration
     */
    default public Node createTaskNode(Node rootNode) {
        void var3_3;
        Node taskType = JcrUtils.getOrCreateChild((Node)rootNode, (String)TaskMetadata.getMetadata((TaskWithBlock)this.task(), (String)"taskType"));
        Node node = taskType.addNode(this.task().getId());
        node.addMixin("deployit:task");
        return var3_3;
    }

    public static /* synthetic */ void fillTaskNode$(TaskArchiver $this, Node taskNode, boolean fillBlocks) {
        $this.fillTaskNode(taskNode, fillBlocks);
    }

    default public void fillTaskNode(Node taskNode, boolean fillBlocks) {
        block0: {
            ArchivedTask archivedTask;
            BlockState block = this.task().getBlock();
            taskNode.setProperty("$id", this.task().getId());
            taskNode.setProperty("state", this.task().getState().name());
            taskNode.setProperty("startDate", (Calendar)this.task().getStartDate().toGregorianCalendar());
            taskNode.setProperty("completionDate", (Calendar)this.task().getCompletionDate().toGregorianCalendar());
            taskNode.setProperty("ownerUser", this.task().getOwner());
            taskNode.setProperty("failureCount", (long)this.task().getFailureCount());
            Object object = this.task() instanceof ArchivedTask ? ((archivedTask = (ArchivedTask)this.task()).getMigrationStatus() != null ? taskNode.setProperty("migrationStatus", archivedTask.getMigrationStatus().name()) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
            taskNode.setProperty("deploymentType", TaskMetadata.getMetadata((TaskWithBlock)this.task(), (String)"taskType"));
            DateTime scheduledDate = this.task().getScheduledDate();
            Object object2 = scheduledDate != null ? taskNode.setProperty("scheduledDate", (Calendar)scheduledDate.toGregorianCalendar()) : BoxedUnit.UNIT;
            if (!fillBlocks) break block0;
            this.fillRootBlock(taskNode, block);
        }
    }

    public static /* synthetic */ boolean fillTaskNode$default$2$(TaskArchiver $this) {
        return $this.fillTaskNode$default$2();
    }

    default public boolean fillTaskNode$default$2() {
        return true;
    }

    private void fillRootBlock(Node taskNode, BlockState block) {
        block0: {
            if (block == null) break block0;
            this.fillBlockNode(taskNode, block);
        }
    }

    private void fillBlockNode(Node taskNode, BlockState block) {
        Node blockNode = taskNode.addNode(block.getId());
        blockNode.setProperty("blockDescription", block.getDescription());
        blockNode.setProperty("blockState", block.getState().name());
        BlockState blockState = block;
        if (blockState instanceof PhaseContainer) {
            PhaseContainer phaseContainer = (PhaseContainer)blockState;
            this.fillPhaseContainer(blockNode, phaseContainer);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (blockState instanceof Phase) {
            Phase phase = (Phase)blockState;
            this.fillPhase(blockNode, phase);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (blockState instanceof StepBlock) {
            StepBlock stepBlock = (StepBlock)blockState;
            this.fillStepBlock(blockNode, stepBlock);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (blockState instanceof CompositeBlockState) {
            CompositeBlockState compositeBlockState = (CompositeBlockState)blockState;
            this.fillCompositeBlock(blockNode, compositeBlockState);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)blockState);
        }
    }

    private void fillPhaseContainer(Node blockNode, PhaseContainer container) {
        blockNode.setProperty("blockType", BlockType.PHASE_BLOCK_CONTAINER.name());
        ImplicitConversions$.MODULE$.iterable$u0020AsScalaIterable(container.getPhases()).foreach((Function1 & Serializable & scala.Serializable)p -> {
            this.fillBlockNode(blockNode, (BlockState)p);
            return BoxedUnit.UNIT;
        });
    }

    private void fillPhase(Node blockNode, Phase phase) {
        blockNode.setProperty("blockType", BlockType.PHASE_BLOCK.name());
        this.fillBlockNode(blockNode, (BlockState)phase.block());
    }

    private void fillCompositeBlock(Node blockNode, CompositeBlockState block) {
        blockNode.setProperty("blockType", BlockType.COMPOSITE_BLOCK.name());
        blockNode.setProperty("isParallel", block.isParallel());
        ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(block.getBlocks()).foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.fillBlockNode(blockNode, b);
            return BoxedUnit.UNIT;
        });
    }

    private void fillStepBlock(Node blockNode, StepBlock block) {
        blockNode.setProperty("blockType", BlockType.STEP_BLOCK.name());
        blockNode.setProperty("currentStepNrBlock", 0L);
        this.fillStepNode(blockNode, block.getSteps());
    }

    private void fillStepNode(Node taskNode, List<StepState> steps) {
        IntRef nr = IntRef.create((int)1);
        ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(steps).foreach((Function1 & Serializable & scala.Serializable)step -> {
            Node stepNode = taskNode.addNode("step" + nr$1.elem);
            ++nr$1.elem;
            stepNode.setProperty("description", step.getDescription());
            stepNode.setProperty("state", step.getState().name());
            stepNode.setProperty("startDate", step.getStartDate() == null ? null : step.getStartDate().toGregorianCalendar());
            stepNode.setProperty("completionDate", step.getCompletionDate() == null ? null : step.getCompletionDate().toGregorianCalendar());
            stepNode.setProperty("failureCount", (long)step.getFailureCount());
            return stepNode.setProperty("log", step.getLog());
        });
    }

    public static void $init$(TaskArchiver $this) {
    }
}

