/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.security.jce;

import com.hierynomus.security.MessageDigest;
import com.hierynomus.security.SecurityException;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;

public class JceMessageDigest
implements MessageDigest {
    private java.security.MessageDigest md;

    JceMessageDigest(String algorithm, Provider jceProvider, String providerName) throws SecurityException {
        try {
            this.md = jceProvider != null ? java.security.MessageDigest.getInstance(algorithm, jceProvider) : (providerName != null ? java.security.MessageDigest.getInstance(algorithm, providerName) : java.security.MessageDigest.getInstance(algorithm));
        }
        catch (NoSuchAlgorithmException e) {
            if ("MD4".equals(algorithm)) {
                this.tryMd4();
            }
            throw new SecurityException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException(e);
        }
    }

    private void tryMd4() throws SecurityException {
        try {
            Class<?> md4Class = Class.forName("sun.security.provider.MD4");
            this.md = (java.security.MessageDigest)md4Class.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
            throw new SecurityException(e1);
        }
    }

    @Override
    public void update(byte[] bytes) {
        this.md.update(bytes);
    }

    @Override
    public byte[] digest() {
        return this.md.digest();
    }

    @Override
    public void reset() {
        this.md.reset();
    }
}

