/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.serialization;

import com.caucho.hessian4.io.HessianInput;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.io.InputStream;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.io.InputStreamConsumer;
import org.rzo.netty.ahessian.io.PullInputStreamConsumer;

public class HessianDecoder
extends PullInputStreamConsumer {
    public HessianDecoder() {
        super(new InputStreamConsumer(){
            InputStream _in;

            @Override
            public void consume(ChannelHandlerContext ctx, InputStream in) {
                this._in = in;
                try {
                    HessianInput hin = new HessianInput(this._in);
                    while (true) {
                        Object obj;
                        if ((obj = hin.readObject(null)) == null) {
                            continue;
                        }
                        ctx.fireChannelRead(obj);
                    }
                }
                catch (Exception ex) {
                    if (ex.getMessage().startsWith("H expected got 0x0 (")) {
                        Constants.ahessianLogger.info("Ping received");
                    } else {
                        Constants.ahessianLogger.debug("", (Throwable)ex);
                    }
                    return;
                }
            }

            @Override
            public boolean isBufferEmpty() {
                if (this._in == null) {
                    return true;
                }
                try {
                    return this._in.available() == 0;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return true;
                }
            }

            @Override
            public void setContext(ChannelHandlerContext ctx) {
            }
        });
    }
}

