/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.protocol.StatusMessageFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;

abstract class MultiDestination {
    MultiDestination() {
    }

    abstract int send(DatagramChannel var1, ByteBuffer var2, SendChannelEndpoint var3, int var4);

    abstract void onStatusMessage(StatusMessageFlyweight var1, InetSocketAddress var2);

    abstract boolean isManualControlMode();

    abstract void addDestination(InetSocketAddress var1);

    abstract void removeDestination(InetSocketAddress var1);

    static int send(DatagramChannel datagramChannel, ByteBuffer buffer, SendChannelEndpoint channelEndpoint, int bytesToSend, int position, InetSocketAddress destination) {
        int bytesSent = 0;
        try {
            channelEndpoint.presend(buffer, destination);
            buffer.position(position);
            bytesSent = datagramChannel.send(buffer, destination);
        }
        catch (PortUnreachableException | ClosedChannelException iOException) {
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to send packet of " + bytesToSend + " bytes to " + destination, ex);
        }
        return bytesSent;
    }
}

