/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.util.StreamUtil;

public class FileUtil {
    private static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (!directory.isDirectory()) {
            return;
        }
        IOException exception = null;
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                try {
                    FileUtil.cleanDirectory(file);
                    if (!file.delete()) {
                        throw new IOException("Cannot delete " + file.getAbsolutePath());
                    }
                }
                catch (IOException ioe) {
                    exception = ioe;
                }
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        Reader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(file), LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding());
            String string = StreamUtil.getReaderContents(reader);
            return string;
        }
        catch (FileNotFoundException e) {
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String contents, File file) throws IOException {
        file.getParentFile().mkdirs();
        FileOutputStream output = new FileOutputStream(file);
        try {
            StreamUtil.copy(new ByteArrayInputStream(contents.getBytes(LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding())), output);
        }
        finally {
            output.close();
        }
    }
}

