/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.winrm;

import com.xebialabs.overthere.cifs.WinrmHttpsCertificateTrustStrategy;
import com.xebialabs.overthere.cifs.WinrmHttpsHostnameVerificationStrategy;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.overthere.winrm.KerberosJaasConfiguration;
import com.xebialabs.overthere.winrm.Namespaces;
import com.xebialabs.overthere.winrm.ProvidedAuthCallback;
import com.xebialabs.overthere.winrm.ResponseExtractor;
import com.xebialabs.overthere.winrm.WinRmRuntimeIOException;
import com.xebialabs.overthere.winrm.WsmanKerberosSchemeFactory;
import com.xebialabs.overthere.winrm.WsmanSPNegoSchemeFactory;
import com.xebialabs.overthere.winrm.soap.Action;
import com.xebialabs.overthere.winrm.soap.BodyBuilder;
import com.xebialabs.overthere.winrm.soap.HeaderBuilder;
import com.xebialabs.overthere.winrm.soap.OptionSet;
import com.xebialabs.overthere.winrm.soap.ResourceURI;
import com.xebialabs.overthere.winrm.soap.SoapAction;
import com.xebialabs.overthere.winrm.soap.SoapMessageBuilder;
import com.xebialabs.overthere.winrm.soap.Soapy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.util.List;
import java.util.UUID;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WinRmClient {
    private final SocketFactory socketFactory;
    private final String username;
    private final boolean enableKerberos;
    private final String password;
    private final URL targetURL;
    private final String unmappedAddress;
    private final int unmappedPort;
    private String winRmTimeout;
    private int winRmEnvelopSize;
    private String winRmLocale;
    private WinrmHttpsCertificateTrustStrategy httpsCertTrustStrategy;
    private WinrmHttpsHostnameVerificationStrategy httpsHostnameVerifyStrategy;
    private boolean kerberosUseHttpSpn;
    private boolean kerberosAddPortToSpn;
    private boolean kerberosDebug;
    private boolean kerberosTicketCache;
    private int soTimeout;
    private int connectionTimeout;
    private boolean useCanonicalHostname;
    private String shellId;
    private String commandId;
    private int exitValue = -1;
    private int chunk = 0;
    private static Logger logger = LoggerFactory.getLogger(WinRmClient.class);

    public WinRmClient(String username, String password, URL targetURL, String unmappedAddress, int unmappedPort, SocketFactory socketFactory) {
        int posOfAtSign = username.indexOf(64);
        if (posOfAtSign >= 0) {
            String u = username.substring(0, posOfAtSign);
            String d = username.substring(posOfAtSign + 1);
            if (d.toUpperCase().equals(d)) {
                this.username = username;
            } else {
                this.username = u + "@" + d.toUpperCase();
                logger.warn("Fixing username [{}] to have an upper case domain name [{}]", (Object)username, (Object)this.username);
            }
            this.enableKerberos = true;
        } else {
            this.username = username;
            this.enableKerberos = false;
        }
        this.password = password;
        this.targetURL = targetURL;
        this.unmappedAddress = unmappedAddress;
        this.unmappedPort = unmappedPort;
        this.socketFactory = socketFactory;
    }

    public String createShell() {
        logger.debug("Sending WinRM Create Shell request");
        Element bodyContent = DocumentHelper.createElement((QName)QName.get((String)"Shell", (Namespace)Namespaces.NS_WIN_SHELL));
        bodyContent.addElement(QName.get((String)"InputStreams", (Namespace)Namespaces.NS_WIN_SHELL)).addText("stdin");
        bodyContent.addElement(QName.get((String)"OutputStreams", (Namespace)Namespaces.NS_WIN_SHELL)).addText("stdout stderr");
        Document requestDocument = this.getRequestDocument(Action.WS_ACTION, ResourceURI.RESOURCE_URI_CMD, OptionSet.OPEN_SHELL, bodyContent);
        Document responseDocument = this.sendRequest(requestDocument, SoapAction.SHELL);
        this.shellId = WinRmClient.getFirstElement(responseDocument, ResponseExtractor.SHELL_ID);
        logger.debug("Received WinRM Create Shell response: shell with ID {} start created", (Object)this.shellId);
        return this.shellId;
    }

    public String executeCommand(String command) {
        logger.debug("Sending WinRM Execute Command request to shell {}", (Object)this.shellId);
        Element bodyContent = DocumentHelper.createElement((QName)QName.get((String)"CommandLine", (Namespace)Namespaces.NS_WIN_SHELL));
        String encoded = "\"" + command + "\"";
        bodyContent.addElement(QName.get((String)"Command", (Namespace)Namespaces.NS_WIN_SHELL)).addText(encoded);
        Document requestDocument = this.getRequestDocument(Action.WS_COMMAND, ResourceURI.RESOURCE_URI_CMD, OptionSet.RUN_COMMAND, bodyContent);
        Document responseDocument = this.sendRequest(requestDocument, SoapAction.COMMAND_LINE);
        this.commandId = WinRmClient.getFirstElement(responseDocument, ResponseExtractor.COMMAND_ID);
        logger.debug("Received WinRM Execute Command response to shell {}: command with ID {} was started", (Object)this.shellId, (Object)this.commandId);
        return this.commandId;
    }

    public boolean receiveOutput(OutputStream stdout, OutputStream stderr) throws IOException {
        logger.debug("Sending WinRM Receive Output request for command {} in shell {}", (Object)this.commandId, (Object)this.shellId);
        Element bodyContent = DocumentHelper.createElement((QName)QName.get((String)"Receive", (Namespace)Namespaces.NS_WIN_SHELL));
        bodyContent.addElement(QName.get((String)"DesiredStream", (Namespace)Namespaces.NS_WIN_SHELL)).addAttribute("CommandId", this.commandId).addText("stdout stderr");
        Document requestDocument = this.getRequestDocument(Action.WS_RECEIVE, ResourceURI.RESOURCE_URI_CMD, null, bodyContent);
        Document responseDocument = this.sendRequest(requestDocument, SoapAction.RECEIVE);
        logger.debug("Received WinRM Receive Output response for command {} in shell {}", (Object)this.commandId, (Object)this.shellId);
        WinRmClient.handleStream(responseDocument, ResponseExtractor.STDOUT, stdout);
        WinRmClient.handleStream(responseDocument, ResponseExtractor.STDERR, stderr);
        if (this.chunk == 0) {
            this.parseExitCode(responseDocument);
        }
        ++this.chunk;
        List list = ResponseExtractor.STREAM_DONE.getXPath().selectNodes((Object)responseDocument);
        if (!list.isEmpty()) {
            logger.trace("Found CommandState element with State=Done, parsing exit code and returning false.");
            this.parseExitCode(responseDocument);
            return false;
        }
        logger.trace("Did not find CommandState element with State=Done, returning true.");
        return true;
    }

    public void sendInput(byte[] buf) throws IOException {
        logger.debug("Sending WinRM Send Input request for command {} in shell {}", (Object)this.commandId, (Object)this.shellId);
        Element bodyContent = DocumentHelper.createElement((QName)QName.get((String)"Send", (Namespace)Namespaces.NS_WIN_SHELL));
        Base64 base64 = new Base64();
        bodyContent.addElement(QName.get((String)"Stream", (Namespace)Namespaces.NS_WIN_SHELL)).addAttribute("Name", "stdin").addAttribute("CommandId", this.commandId).addText(base64.encodeAsString(buf));
        Document requestDocument = this.getRequestDocument(Action.WS_SEND, ResourceURI.RESOURCE_URI_CMD, null, bodyContent);
        this.sendRequest(requestDocument, SoapAction.SEND);
        logger.debug("Sent WinRM Send Input request for command {} in shell {}", (Object)this.commandId, (Object)this.shellId);
    }

    public void signal() {
        if (this.commandId == null) {
            logger.warn("Not sending WinRM Signal request in shell {} because there is no running command", (Object)this.shellId);
            return;
        }
        logger.debug("Sending WinRM Signal request for command {} in shell {}", (Object)this.commandId, (Object)this.shellId);
        Element bodyContent = DocumentHelper.createElement((QName)QName.get((String)"Signal", (Namespace)Namespaces.NS_WIN_SHELL)).addAttribute("CommandId", this.commandId);
        bodyContent.addElement(QName.get((String)"Code", (Namespace)Namespaces.NS_WIN_SHELL)).addText("http://schemas.microsoft.com/wbem/wsman/1/windows/shell/signal/terminate");
        Document requestDocument = this.getRequestDocument(Action.WS_SIGNAL, ResourceURI.RESOURCE_URI_CMD, null, bodyContent);
        this.sendRequest(requestDocument, SoapAction.SIGNAL);
        logger.debug("Sent WinRM Signal request for command {} in shell {}", (Object)this.commandId, (Object)this.shellId);
    }

    public void deleteShell() {
        if (this.shellId == null) {
            logger.warn("Not sending WinRM Delete Shell request because there is no shell");
            return;
        }
        logger.debug("Sending WinRM Delete Shell request for shell {}", (Object)this.shellId);
        Document requestDocument = this.getRequestDocument(Action.WS_DELETE, ResourceURI.RESOURCE_URI_CMD, null, null);
        this.sendRequest(requestDocument, null);
        logger.debug("Sent WinRM Delete Shell request for shell {}", (Object)this.shellId);
    }

    public int exitValue() {
        return this.exitValue;
    }

    private void parseExitCode(Document responseDocument) {
        try {
            logger.trace("Parsing exit code");
            String exitCode = WinRmClient.getFirstElement(responseDocument, ResponseExtractor.EXIT_CODE);
            logger.trace("Found exit code {}", (Object)exitCode);
            try {
                this.exitValue = Integer.parseInt(exitCode);
            }
            catch (NumberFormatException exc) {
                logger.error("Cannot parse exit code {}, setting it to -1", (Throwable)exc);
                this.exitValue = -1;
            }
        }
        catch (Exception exc) {
            logger.trace("Exit code not found,");
        }
    }

    private static void handleStream(Document responseDocument, ResponseExtractor stream, OutputStream out) throws IOException {
        List streams = stream.getXPath().selectNodes((Object)responseDocument);
        if (!streams.isEmpty()) {
            Base64 base64 = new Base64();
            for (Element e : streams) {
                byte[] decode = base64.decode(e.getText());
                out.write(decode);
            }
        }
    }

    private static String getFirstElement(Document doc, ResponseExtractor extractor) {
        List nodes = extractor.getXPath().selectNodes((Object)doc);
        if (nodes.isEmpty()) {
            throw new RuntimeException("Cannot find " + extractor.getXPath() + " in " + WinRmClient.toString(doc));
        }
        Element next = (Element)nodes.iterator().next();
        return next.getText();
    }

    private Document getRequestDocument(Action action, ResourceURI resourceURI, OptionSet optionSet, Element bodyContent) {
        SoapMessageBuilder message = Soapy.newMessage();
        SoapMessageBuilder.EnvelopeBuilder envelope = message.envelope();
        try {
            this.addHeaders(envelope, action, resourceURI, optionSet);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        BodyBuilder body = envelope.body();
        if (bodyContent != null) {
            body.setContent(bodyContent);
        }
        return message.getDocument();
    }

    private void addHeaders(SoapMessageBuilder.EnvelopeBuilder envelope, Action action, ResourceURI resourceURI, OptionSet optionSet) throws URISyntaxException {
        HeaderBuilder header = envelope.header();
        header.to(this.targetURL.toURI()).replyTo(new URI("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous"));
        header.maxEnvelopeSize(this.winRmEnvelopSize);
        header.withId(WinRmClient.getUUID());
        header.withLocale(this.winRmLocale);
        header.withTimeout(this.winRmTimeout);
        header.withAction(action.getUri());
        if (this.shellId != null) {
            header.withShellId(this.shellId);
        }
        header.withResourceURI(resourceURI.getUri());
        if (optionSet != null) {
            header.withOptionSet(optionSet.getKeyValuePairs());
        }
    }

    private static String getUUID() {
        return "uuid:" + UUID.randomUUID().toString().toUpperCase();
    }

    private Document sendRequest(Document requestDocument, SoapAction soapAction) {
        if (this.enableKerberos) {
            return this.runPrivileged(new PrivilegedSendMessage(requestDocument, soapAction));
        }
        return this.doSendRequest(requestDocument, soapAction);
    }

    private Document runPrivileged(PrivilegedSendMessage privilegedSendMessage) {
        Document result;
        ProvidedAuthCallback handler = new ProvidedAuthCallback(this.username, this.password);
        try {
            LoginContext lc = new LoginContext("", null, handler, new KerberosJaasConfiguration(this.kerberosDebug, this.kerberosTicketCache));
            lc.login();
            result = Subject.doAs(lc.getSubject(), privilegedSendMessage);
        }
        catch (LoginException e) {
            throw new WinRmRuntimeIOException("Login failure sending message on " + this.targetURL + " error: " + e.getMessage(), privilegedSendMessage.getRequestDocument(), null, e);
        }
        catch (PrivilegedActionException e) {
            throw new WinRmRuntimeIOException("Failure sending message on " + this.targetURL + " error: " + e.getMessage(), privilegedSendMessage.getRequestDocument(), null, e.getException());
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private Document doSendRequest(Document requestDocument, SoapAction soapAction) {
        HttpClientBuilder client = HttpClientBuilder.create();
        HttpClientConnectionManager connectionManager = this.getHttpClientConnectionManager();
        try {
            this.configureHttpClient(client);
            try {
                try (CloseableHttpClient httpClient = client.build();){
                    Document responseDocument;
                    CloseableHttpResponse response;
                    block23: {
                        BasicHttpContext context = new BasicHttpContext();
                        HttpPost request = new HttpPost(this.targetURL.toURI());
                        if (soapAction != null) {
                            request.setHeader("SOAPAction", soapAction.getValue());
                        }
                        String requestBody = WinRmClient.toString(requestDocument);
                        logger.trace("Request:\nPOST {}\n{}", (Object)this.targetURL, (Object)requestBody);
                        HttpEntity entity = this.createEntity(requestBody);
                        request.setEntity(entity);
                        response = httpClient.execute((HttpUriRequest)request, (HttpContext)context);
                        WinRmClient.logResponseHeaders((HttpResponse)response);
                        responseDocument = null;
                        try {
                            String responseBody = this.handleResponse((HttpResponse)response, (HttpContext)context);
                            responseDocument = DocumentHelper.parseText((String)responseBody);
                            WinRmClient.logDocument("Response body:", responseDocument);
                        }
                        catch (WinRmRuntimeIOException e) {
                            if (response.getStatusLine().getStatusCode() != 200) break block23;
                            throw e;
                        }
                    }
                    if (response.getStatusLine().getStatusCode() != 200) {
                        throw new WinRmRuntimeIOException(String.format("Unexpected HTTP response on %s:  %s (%s)", this.targetURL, response.getStatusLine().getReasonPhrase(), response.getStatusLine().getStatusCode()));
                    }
                    Document document = responseDocument;
                    return document;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                connectionManager.shutdown();
            }
        }
        catch (WinRmRuntimeIOException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new WinRmRuntimeIOException("Error when sending request to " + this.targetURL, requestDocument, null, exc);
        }
    }

    private HttpClientConnectionManager getHttpClientConnectionManager() {
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory(){

            public Socket createSocket(HttpContext context) throws IOException {
                return WinRmClient.this.socketFactory.createSocket();
            }
        }).register("https", (Object)new SSLConnectionSocketFactory(SSLContexts.createDefault(), SSLConnectionSocketFactory.getDefaultHostnameVerifier()){

            public Socket createSocket(HttpContext context) throws IOException {
                return WinRmClient.this.socketFactory.createSocket();
            }
        }).build();
        return new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
    }

    private void configureHttpClient(HttpClientBuilder httpclient) throws GeneralSecurityException {
        this.configureTrust(httpclient);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        httpclient.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        this.configureAuthentication((CredentialsProvider)credentialsProvider, "Basic", (Principal)new BasicUserPrincipal(this.username));
        if (this.enableKerberos) {
            String spnServiceClass = this.kerberosUseHttpSpn ? "HTTP" : "WSMAN";
            RegistryBuilder authSchemeRegistryBuilder = RegistryBuilder.create();
            authSchemeRegistryBuilder.register("Kerberos", (Object)new WsmanKerberosSchemeFactory(!this.kerberosAddPortToSpn, spnServiceClass, this.unmappedAddress, this.unmappedPort, this.useCanonicalHostname));
            authSchemeRegistryBuilder.register("Negotiate", (Object)new WsmanSPNegoSchemeFactory(!this.kerberosAddPortToSpn, spnServiceClass, this.unmappedAddress, this.unmappedPort, this.useCanonicalHostname));
            httpclient.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistryBuilder.build());
            this.configureAuthentication((CredentialsProvider)credentialsProvider, "Kerberos", new KerberosPrincipal(this.username));
            this.configureAuthentication((CredentialsProvider)credentialsProvider, "Negotiate", new KerberosPrincipal(this.username));
        }
        httpclient.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.soTimeout).build());
        httpclient.setDefaultRequestConfig(RequestConfig.custom().setAuthenticationEnabled(true).setConnectTimeout(this.connectionTimeout).build());
    }

    private void configureTrust(HttpClientBuilder httpclientBuilder) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        if (!"https".equalsIgnoreCase(this.targetURL.getProtocol())) {
            return;
        }
        TrustStrategy trustStrategy = this.httpsCertTrustStrategy.getStrategy();
        SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((org.apache.http.ssl.TrustStrategy)trustStrategy).build();
        HostnameVerifier hostnameVerifier = this.httpsHostnameVerifyStrategy.getVerifier();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
        httpclientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
    }

    private void configureAuthentication(CredentialsProvider provider, String scheme, final Principal principal) {
        provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, scheme), new Credentials(){

            public Principal getUserPrincipal() {
                return principal;
            }

            public String getPassword() {
                return WinRmClient.this.password;
            }
        });
    }

    private static void logResponseHeaders(HttpResponse response) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        StringBuilder headers = new StringBuilder();
        for (Header header : response.getAllHeaders()) {
            headers.append(header.getName()).append(": ").append(header.getValue()).append("\n");
        }
        logger.trace("Response headers:\n{}", (Object)headers);
    }

    private static void logDocument(String caption, Document document) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        StringWriter text = new StringWriter();
        try {
            XMLWriter writer = new XMLWriter((Writer)text, OutputFormat.createPrettyPrint());
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            logger.trace("{}\n{}", (Object)caption, (Object)e);
        }
        logger.trace("{}\n{}", (Object)caption, (Object)text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleResponse(HttpResponse response, HttpContext context) throws IOException {
        HttpEntity entity = response.getEntity();
        if (null == entity.getContentType() || !entity.getContentType().getValue().startsWith("application/soap+xml")) {
            throw new WinRmRuntimeIOException("Error when sending request to " + this.targetURL + "; Unexpected content-type: " + entity.getContentType());
        }
        InputStream is = entity.getContent();
        StringWriter writer = new StringWriter();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        try {
            int n;
            char[] buffer = new char[1024];
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        finally {
            OverthereUtils.closeQuietly(reader);
            OverthereUtils.closeQuietly(is);
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        return ((Object)writer).toString();
    }

    private static String toString(Document doc) {
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, OutputFormat.createPrettyPrint());
        try {
            xmlWriter.write(doc);
            xmlWriter.close();
        }
        catch (IOException exc) {
            throw new WinRmRuntimeIOException("Cannnot convert XML to String ", exc);
        }
        return stringWriter.toString();
    }

    protected HttpEntity createEntity(String requestDocAsString) {
        return new StringEntity(requestDocAsString, ContentType.create((String)"application/soap+xml", (String)"UTF-8"));
    }

    public void setWinRmTimeout(String timeout) {
        this.winRmTimeout = timeout;
    }

    public void setWinRmEnvelopSize(int envelopSize) {
        this.winRmEnvelopSize = envelopSize;
    }

    public void setWinRmLocale(String locale) {
        this.winRmLocale = locale;
    }

    public void setHttpsCertTrustStrategy(WinrmHttpsCertificateTrustStrategy httpsCertTrustStrategy) {
        this.httpsCertTrustStrategy = httpsCertTrustStrategy;
    }

    public void setHttpsHostnameVerifyStrategy(WinrmHttpsHostnameVerificationStrategy httpsHostnameVerifyStrategy) {
        this.httpsHostnameVerifyStrategy = httpsHostnameVerifyStrategy;
    }

    public void setKerberosUseHttpSpn(boolean kerberosUseHttpSpn) {
        this.kerberosUseHttpSpn = kerberosUseHttpSpn;
    }

    public void setKerberosAddPortToSpn(boolean kerberosAddPortToSpn) {
        this.kerberosAddPortToSpn = kerberosAddPortToSpn;
    }

    public void setKerberosDebug(boolean kerberosDebug) {
        this.kerberosDebug = kerberosDebug;
    }

    public void setKerberosTicketCache(boolean kerberosTicketCache) {
        this.kerberosTicketCache = kerberosTicketCache;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public boolean isUseCanonicalHostname() {
        return this.useCanonicalHostname;
    }

    public void setUseCanonicalHostname(boolean useCanonicalHostname) {
        this.useCanonicalHostname = useCanonicalHostname;
    }

    private class PrivilegedSendMessage
    implements PrivilegedExceptionAction<Document> {
        private Document requestDocument;
        private SoapAction soapAction;

        private PrivilegedSendMessage(Document requestDocument, SoapAction soapAction) {
            this.requestDocument = requestDocument;
            this.soapAction = soapAction;
        }

        @Override
        public Document run() throws Exception {
            return WinRmClient.this.doSendRequest(this.requestDocument, this.soapAction);
        }

        public Document getRequestDocument() {
            return this.requestDocument;
        }
    }
}

