/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CachedValueNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ReplaceNodeVisitor;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

class ConditionalNode
extends ValueNode {
    private CachedValueNode caseOperand;
    private ValueNodeList testConditions;
    private ValueNodeList thenElseList;

    ConditionalNode(CachedValueNode cachedValueNode, ValueNodeList valueNodeList, ValueNodeList valueNodeList2, ContextManager contextManager) {
        super(contextManager);
        this.caseOperand = cachedValueNode;
        this.testConditions = valueNodeList;
        this.thenElseList = valueNodeList2;
    }

    @Override
    void printSubNodes(int n) {
    }

    private void recastNullNodes(DataTypeDescriptor dataTypeDescriptor, FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        dataTypeDescriptor = dataTypeDescriptor.getNullabilityType(true);
        for (int i = 0; i < this.thenElseList.size(); ++i) {
            ValueNode valueNode = (ValueNode)this.thenElseList.elementAt(i);
            if (!(valueNode instanceof UntypedNullConstantNode)) continue;
            CastNode castNode = new CastNode(valueNode, dataTypeDescriptor, this.getContextManager());
            castNode.bindExpression(fromList, subqueryList, list);
            this.thenElseList.setElementAt(castNode, i);
        }
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        Object object;
        Object object2;
        Object object32;
        Object object42;
        CompilerContext compilerContext = this.getCompilerContext();
        int n = this.orReliability(16384);
        ValueNodeList valueNodeList = this.bindCaseOperand(compilerContext, fromList, subqueryList, list);
        this.testConditions.bindExpression(fromList, subqueryList, list);
        if (valueNodeList != null) {
            for (Object object42 : valueNodeList) {
                valueNodeList.comparable((ValueNode)object42);
                this.testConditions.accept(new ReplaceNodeVisitor((Visitable)object42, this.caseOperand));
            }
            this.caseOperand.setType(valueNodeList.getDominantTypeServices());
        }
        this.thenElseList.bindExpression(fromList, subqueryList, list);
        DataTypeDescriptor dataTypeDescriptor = this.thenElseList.getTypeServices();
        if (dataTypeDescriptor == null) {
            throw StandardException.newException("42X87", new Object[0]);
        }
        this.recastNullNodes(dataTypeDescriptor, fromList, subqueryList, list);
        this.setType(this.thenElseList.getDominantTypeServices());
        this.testConditions.setParameterDescriptor(new DataTypeDescriptor(TypeId.BOOLEAN_ID, true));
        for (Object object32 : this.testConditions) {
            if (((ValueNode)object32).getTypeServices().getTypeId().equals(TypeId.BOOLEAN_ID)) continue;
            throw StandardException.newException("42X88", new Object[0]);
        }
        this.thenElseList.setParameterDescriptor(this.getTypeServices());
        object42 = this.getClassFactory().getClassInspector();
        for (ValueNode valueNode : this.thenElseList) {
            object2 = valueNode.getTypeServices();
            object = ((DataTypeDescriptor)object2).getTypeId().getCorrespondingJavaTypeName();
            String string = this.getTypeId().getCorrespondingJavaTypeName();
            if (((DataTypeDescriptor)object2).comparable(this.getTypeServices(), false, this.getClassFactory()) || ((ClassInspector)object42).assignableTo((String)object, string) || ((ClassInspector)object42).assignableTo(string, (String)object)) continue;
            throw StandardException.newException("42X89", ((DataTypeDescriptor)object2).getTypeId().getSQLTypeName(), this.getTypeId().getSQLTypeName());
        }
        this.setNullability(this.thenElseList.isNullable());
        object32 = this.getTypeId();
        for (int i = 0; i < this.thenElseList.size(); ++i) {
            object2 = (ValueNode)this.thenElseList.elementAt(i);
            if (((ValueNode)object2).getTypeId().typePrecedence() == ((TypeId)object32).typePrecedence()) continue;
            object = new CastNode((ValueNode)object2, this.getTypeServices(), this.getContextManager());
            object = ((ValueNode)object).bindExpression(fromList, subqueryList, list);
            this.thenElseList.setElementAt(object, i);
        }
        compilerContext.setReliability(n);
        return this;
    }

    private ValueNodeList bindCaseOperand(CompilerContext compilerContext, FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        ValueNodeList valueNodeList = null;
        if (this.caseOperand != null) {
            int n = this.orReliability(22528);
            if (this.caseOperand.requiresTypeFromContext()) {
                valueNodeList = new ValueNodeList(this.getContextManager());
                this.testConditions.accept(new ReplaceCaseOperandVisitor(valueNodeList));
            }
            this.caseOperand = (CachedValueNode)this.caseOperand.bindExpression(fromList, subqueryList, list);
            compilerContext.setReliability(n);
        }
        return valueNodeList;
    }

    @Override
    ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.testConditions.preprocess(n, fromList, subqueryList, predicateList);
        this.thenElseList.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    @Override
    boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        if (bl) {
            return false;
        }
        boolean bl2 = this.testConditions.categorize(jBitSet, bl);
        bl2 = this.thenElseList.categorize(jBitSet, bl) && bl2;
        return bl2;
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.testConditions = this.testConditions.remapColumnReferencesToExpressions();
        this.thenElseList = this.thenElseList.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    boolean isConstantExpression() {
        return this.testConditions.isConstantExpression() && this.thenElseList.isConstantExpression();
    }

    @Override
    boolean constantExpression(PredicateList predicateList) {
        return this.testConditions.constantExpression(predicateList) && this.thenElseList.constantExpression(predicateList);
    }

    @Override
    ValueNode eliminateNots(boolean bl) throws StandardException {
        this.thenElseList.eliminateNots(bl);
        this.testConditions.eliminateNots(false);
        return this;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n;
        for (n = 0; n < this.testConditions.size(); ++n) {
            ((ValueNode)this.testConditions.elementAt(n)).generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.cast("org.apache.derby.iapi.types.BooleanDataValue");
            methodBuilder.push(true);
            methodBuilder.callMethod((short)185, null, "equals", "boolean", 1);
            methodBuilder.conditionalIf();
            ((ValueNode)this.thenElseList.elementAt(n)).generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.startElseCode();
        }
        ((ValueNode)this.thenElseList.elementAt(this.thenElseList.size() - 1)).generateExpression(expressionClassBuilder, methodBuilder);
        for (n = 0; n < this.testConditions.size(); ++n) {
            methodBuilder.completeConditional();
        }
        if (this.caseOperand != null) {
            this.caseOperand.generateClearField(methodBuilder);
        }
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.testConditions != null) {
            this.testConditions = (ValueNodeList)this.testConditions.accept(visitor);
        }
        if (this.thenElseList != null) {
            this.thenElseList = (ValueNodeList)this.thenElseList.accept(visitor);
        }
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (this.isSameNodeKind(valueNode)) {
            ConditionalNode conditionalNode = (ConditionalNode)valueNode;
            return this.testConditions.isEquivalent(conditionalNode.testConditions) && this.thenElseList.isEquivalent(conditionalNode.thenElseList);
        }
        return false;
    }

    private class ReplaceCaseOperandVisitor
    implements Visitor {
        private final ValueNodeList replacements;

        private ReplaceCaseOperandVisitor(ValueNodeList valueNodeList) {
            this.replacements = valueNodeList;
        }

        @Override
        public Visitable visit(Visitable visitable) throws StandardException {
            if (visitable == ConditionalNode.this.caseOperand) {
                ParameterNode parameterNode = new ParameterNode(0, null, ConditionalNode.this.getContextManager());
                this.replacements.addElement(parameterNode);
                return parameterNode;
            }
            return visitable;
        }

        @Override
        public boolean visitChildrenFirst(Visitable visitable) {
            return false;
        }

        @Override
        public boolean stopTraversal() {
            return false;
        }

        @Override
        public boolean skipChildren(Visitable visitable) throws StandardException {
            return false;
        }
    }
}

