/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.util;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.stream.TLSProtocol;
import akka.stream.scaladsl.BidiFlow;
import akka.stream.scaladsl.BidiFlow$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.util.ByteString;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class LogByteStringTools$ {
    public static LogByteStringTools$ MODULE$;
    private final int MaxBytesPrinted;

    static {
        new LogByteStringTools$();
    }

    public int MaxBytesPrinted() {
        return this.MaxBytesPrinted;
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> logByteStringBidi(String name, int maxBytes) {
        return BidiFlow$.MODULE$.fromFlows(this.logByteString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " DOWN"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), maxBytes), this.logByteString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " UP  "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), maxBytes));
    }

    public <A, B> BidiFlow<A, A, B, B, NotUsed> logToStringBidi(String name, int maxBytes, ClassTag<A> evidence$1, ClassTag<B> evidence$2) {
        return BidiFlow$.MODULE$.fromFlows(this.logToString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, LogByteStringTools$.limitedName$1(evidence$1)})), maxBytes), this.logToString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, LogByteStringTools$.limitedName$1(evidence$2)})), maxBytes));
    }

    public Flow<ByteString, ByteString, NotUsed> logByteString(String name, int maxBytes) {
        Flow qual$1 = Flow$.MODULE$.apply();
        String x$4 = name;
        Function1 & Serializable & scala.Serializable x$5 = (Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.printByteString((ByteString)x$1, maxBytes);
        LoggingAdapter x$6 = qual$1.log$default$3(x$4, (Function1)x$5);
        return (Flow)qual$1.log(x$4, (Function1)x$5, x$6);
    }

    public int logByteStringBidi$default$2() {
        return this.MaxBytesPrinted();
    }

    public int logByteString$default$2() {
        return this.MaxBytesPrinted();
    }

    public <A> Flow<A, A, NotUsed> logToString(String name, int maxBytes) {
        Flow qual$2 = Flow$.MODULE$.apply();
        String x$7 = name;
        Function1 & Serializable & scala.Serializable x$8 = (Function1 & Serializable & scala.Serializable)x$2 -> (String)new StringOps(Predef$.MODULE$.augmentString(x$2.toString())).take(maxBytes);
        LoggingAdapter x$9 = qual$2.log$default$3(x$7, (Function1)x$8);
        return (Flow)qual$2.log(x$7, (Function1)x$8, x$9);
    }

    public <A, B> int logToStringBidi$default$2() {
        return this.MaxBytesPrinted();
    }

    public <A> int logToString$default$2() {
        return this.MaxBytesPrinted();
    }

    public BidiFlow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, NotUsed> logTLSBidi(String name, int maxBytes) {
        return BidiFlow$.MODULE$.fromFlows(this.logTlsOutbound(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ToNet  "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), maxBytes), this.logTlsInbound(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " FromNet"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), maxBytes));
    }

    public int logTLSBidi$default$2() {
        return this.MaxBytesPrinted();
    }

    public Flow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, NotUsed> logTlsOutbound(String name, int maxBytes) {
        Flow qual$3 = Flow$.MODULE$.apply();
        String x$10 = name;
        Function1 & Serializable & scala.Serializable x$11 = (Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            TLSProtocol.SslTlsOutbound sslTlsOutbound = x0$1;
            if (sslTlsOutbound instanceof TLSProtocol.SendBytes) {
                TLSProtocol.SendBytes sendBytes = (TLSProtocol.SendBytes)sslTlsOutbound;
                ByteString bytes = sendBytes.bytes();
                string = "SendBytes " + MODULE$.printByteString(bytes, maxBytes);
            } else if (sslTlsOutbound instanceof TLSProtocol.NegotiateNewSession) {
                TLSProtocol.NegotiateNewSession negotiateNewSession = (TLSProtocol.NegotiateNewSession)sslTlsOutbound;
                string = negotiateNewSession.toString();
            } else {
                throw new MatchError((Object)sslTlsOutbound);
            }
            return string;
        };
        LoggingAdapter x$12 = qual$3.log$default$3(x$10, (Function1)x$11);
        return (Flow)qual$3.log(x$10, (Function1)x$11, x$12);
    }

    public int logTlsOutbound$default$2() {
        return this.MaxBytesPrinted();
    }

    public Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, NotUsed> logTlsInbound(String name, int maxBytes) {
        Flow qual$4 = Flow$.MODULE$.apply();
        String x$13 = name;
        Function1 & Serializable & scala.Serializable x$14 = (Function1 & Serializable & scala.Serializable)x0$2 -> {
            Object object;
            TLSProtocol.SslTlsInbound sslTlsInbound = x0$2;
            if (sslTlsInbound instanceof TLSProtocol.SessionTruncated) {
                TLSProtocol.SessionTruncated sessionTruncated;
                object = sessionTruncated = (TLSProtocol.SessionTruncated)sslTlsInbound;
            } else if (sslTlsInbound instanceof TLSProtocol.SessionBytes) {
                TLSProtocol.SessionBytes sessionBytes = (TLSProtocol.SessionBytes)sslTlsInbound;
                ByteString bytes = sessionBytes.bytes();
                object = "SessionBytes " + MODULE$.printByteString(bytes, maxBytes);
            } else {
                throw new MatchError((Object)sslTlsInbound);
            }
            return object;
        };
        LoggingAdapter x$15 = qual$4.log$default$3(x$13, (Function1)x$14);
        return (Flow)qual$4.log(x$13, (Function1)x$14, x$15);
    }

    public int logTlsInbound$default$2() {
        return this.MaxBytesPrinted();
    }

    public String printByteString(ByteString bytes, int maxBytes) {
        String indent = " ";
        return LogByteStringTools$.formatBytes$1(bytes, maxBytes, indent).mkString("");
    }

    public int printByteString$default$2() {
        return this.MaxBytesPrinted();
    }

    public BidiFlow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, Object> logTLSBidiBySetting(String tag, Option<Object> maxBytesSetting) {
        return (BidiFlow)maxBytesSetting.map((Function1 & Serializable & scala.Serializable)x$3 -> LogByteStringTools$.MODULE$.logTLSBidi(tag, BoxesRunTime.unboxToInt((Object)x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> BidiFlow$.MODULE$.identity());
    }

    private static final String limitedName$1(ClassTag tag) {
        return new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(Logging$.MODULE$.simpleName(tag.runtimeClass()))).take(20))).mkString();
    }

    private static final String asHex$1(byte b) {
        return Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToByte((byte)b)), "%02X");
    }

    private static final char asASCII$1(byte b) {
        return b >= 32 && b < 127 ? (char)b : (char)'.';
    }

    private static final String formatLine$1(ByteString bs, String indent$1) {
        String hex = ((TraversableOnce)bs.map((Function1 & Serializable & scala.Serializable)b -> LogByteStringTools$.asHex$1(BoxesRunTime.unboxToByte((Object)b)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" ");
        String ascii = ((TraversableOnce)bs.map((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToCharacter((char)LogByteStringTools$.asASCII$1(BoxesRunTime.unboxToByte((Object)b))), IndexedSeq$.MODULE$.canBuildFrom())).mkString();
        String arg$macro$2 = indent$1;
        String arg$macro$3 = hex;
        String arg$macro$4 = ascii;
        return new StringOps("%s  %-48s | %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$2, arg$macro$3, arg$macro$4}));
    }

    private static final String formatBytes$2(ByteString bs2, String indent$1) {
        return bs2.grouped(16).map((Function1 & Serializable & scala.Serializable)bs -> LogByteStringTools$.formatLine$1(bs, indent$1)).mkString("\n");
    }

    private static final Iterator formatBytes$1(ByteString bs, int maxBytes$3, String indent$1) {
        String prefix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "ByteString(", " bytes)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{indent$1, BoxesRunTime.boxToInteger((int)bs.size())}));
        return bs.size() <= maxBytes$3 * 2 ? package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{prefix + "\n", LogByteStringTools$.formatBytes$2(bs, indent$1)})) : package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " first + last ", ":\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, BoxesRunTime.boxToInteger((int)maxBytes$3)})), LogByteStringTools$.formatBytes$2(bs.take(maxBytes$3), indent$1), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", "                    ... [", " bytes omitted] ...\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{indent$1, BoxesRunTime.boxToInteger((int)(bs.size() - maxBytes$3 * 2))})), LogByteStringTools$.formatBytes$2(bs.takeRight(maxBytes$3), indent$1)}));
    }

    private LogByteStringTools$() {
        MODULE$ = this;
        this.MaxBytesPrinted = 80;
    }
}

