def blockedClassPrefixes = [
    // blocked to disallow reflection
    /java.lang.Class/,
    // blocked to prevent meddling with the jetty container, e.g. org.eclipse.jetty.webapp.WebAppContext.shutdown()
    /org\.eclipse\.jetty\..*/
]

def blockedMethods = [
    // blocked to prevent breaking out of the security box.
    /java.security.AccessController/ : /doPrivileged.*/,
    // blocked to prevent meddling with application singletons,
    // e.g. com.xebialabs.deployit.security.SecretKeyHolder.get().secretKey
    // or com.xebialabs.xlplatform.spring.SpringContextHolder.getApplicationContext().getBeanDefinitionNames()
    /com\.xebialabs\..*Holder/ : /get.*/
]

onMethodSelection { expr, methodNode ->
    if (blockedClassPrefixes.find { classNameRegex ->
        methodNode.declaringClass.name ==~ classNameRegex
    } != null) {
        addStaticTypeError("Method call is not allowed.", expr)
    }
    if (blockedMethods.find { classNameRegex, methodNameRegex ->
        methodNode.declaringClass.name ==~ classNameRegex && methodNode.name ==~ methodNameRegex
    } != null) {
        addStaticTypeError("Method call is not allowed.", expr)
    }
}

unresolvedVariable { var ->
    makeDynamic(var)
}