/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker.satellite;

import com.xebialabs.deployit.engine.tasker.satellite.KryoCompressor;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0001\u0002\u0001\u001f\t\u0001BJ\u0017\u001bLef|7i\\7sKN\u001cxN\u001d\u0006\u0003\u0007\u0011\t\u0011b]1uK2d\u0017\u000e^3\u000b\u0005\u00151\u0011A\u0002;bg.,'O\u0003\u0002\b\u0011\u00051QM\\4j]\u0016T!!\u0003\u0006\u0002\u0011\u0011,\u0007\u000f\\8zSRT!a\u0003\u0007\u0002\u0013a,'-[1mC\n\u001c(\"A\u0007\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/ai\u0011AA\u0005\u00033\t\u0011ab\u0013:z_\u000e{W\u000e\u001d:fgN|'\u000fC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011q\u0003\u0001\u0005\t?\u0001A)\u0019!C\u0001A\u0005QAN\u001f\u001bgC\u000e$xN]=\u0016\u0003\u0005\u0002\"AI\u0015\u000e\u0003\rR!\u0001J\u0013\u0002\u00071THG\u0003\u0002'O\u00059!\u000e]8v]RT(\"\u0001\u0015\u0002\u00079,G/\u0003\u0002+G\tQAJ\u0017\u001bGC\u000e$xN]=\t\u000b1\u0002A\u0011A\u0017\u0002\u0011\r|W\u000e\u001d:fgN$\"A\f\u001b\u0011\u0007Ey\u0013'\u0003\u00021%\t)\u0011I\u001d:bsB\u0011\u0011CM\u0005\u0003gI\u0011AAQ=uK\")Qg\u000ba\u0001]\u0005I\u0011N\u001c9vi\n+hM\u001a\u0005\u0006o\u0001!\t\u0001O\u0001\u000bI\u0016\u001cw.\u001c9sKN\u001cHC\u0001\u0018:\u0011\u0015)d\u00071\u0001/\u0001")
public class LZ4KryoComressor
implements KryoCompressor {
    private LZ4Factory lz4factory;
    private volatile boolean bitmap$0;

    private LZ4Factory lz4factory$lzycompute() {
        LZ4KryoComressor lZ4KryoComressor = this;
        synchronized (lZ4KryoComressor) {
            if (!this.bitmap$0) {
                this.lz4factory = LZ4Factory.fastestInstance();
                this.bitmap$0 = true;
            }
        }
        return this.lz4factory;
    }

    public LZ4Factory lz4factory() {
        return !this.bitmap$0 ? this.lz4factory$lzycompute() : this.lz4factory;
    }

    @Override
    public byte[] compress(byte[] inputBuff) {
        int inputSize = inputBuff.length;
        LZ4Compressor lz4 = this.lz4factory().fastCompressor();
        int maxOutputSize = lz4.maxCompressedLength(inputSize);
        byte[] outputBuff = new byte[maxOutputSize + 4];
        int outputSize = lz4.compress(inputBuff, 0, inputSize, outputBuff, 4, maxOutputSize);
        outputBuff[0] = (byte)(inputSize & 0xFF);
        outputBuff[1] = (byte)(inputSize >> 8 & 0xFF);
        outputBuff[2] = (byte)(inputSize >> 16 & 0xFF);
        outputBuff[3] = (byte)(inputSize >> 24 & 0xFF);
        return (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(outputBuff)).take(outputSize + 4);
    }

    @Override
    public byte[] decompress(byte[] inputBuff) {
        int size = inputBuff[0] & 0xFF | (inputBuff[1] & 0xFF) << 8 | (inputBuff[2] & 0xFF) << 16 | (inputBuff[3] & 0xFF) << 24;
        LZ4FastDecompressor lz4 = this.lz4factory().fastDecompressor();
        byte[] outputBuff = new byte[size];
        lz4.decompress(inputBuff, 4, outputBuff, 0, size);
        return outputBuff;
    }
}

