/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.migration;

import com.xebialabs.deployit.migration.ArtifactsMigration;
import com.xebialabs.deployit.repository.sql.artifacts.DbArtifactRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.db.DbDataStore;
import org.slf4j.Marker;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001\u0017\tAA)\u0019;bE\u0006\u001cXM\u0003\u0002\u0004\t\u0005IQ.[4sCRLwN\u001c\u0006\u0003\u000b\u0019\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u000f!\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003%\t1aY8n\u0007\u0001\u0019B\u0001\u0001\u0007\u0013-A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003%\u0005\u0013H/\u001b4bGR\u001cX*[4sCRLwN\u001c\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\tQa\u001d7gi)T\u0011aG\u0001\tOJL'P\u001f7fI&\u0011Q\u0004\u0007\u0002\b\u0019><w-\u001b8h\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013\u0001\u00063c\u0003J$\u0018NZ1diJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\"Q5\t!E\u0003\u0002$I\u0005I\u0011M\u001d;jM\u0006\u001cGo\u001d\u0006\u0003K\u0019\n1a]9m\u0015\t9C!\u0001\u0006sKB|7/\u001b;pefL!!\u000b\u0012\u0003)\u0011\u0013\u0017I\u001d;jM\u0006\u001cGOU3q_NLGo\u001c:z\u0011!Y\u0003A!A!\u0002\u0013a\u0013a\u00033c\t\u0006$\u0018m\u0015;pe\u0016\u0004\"!\f\u001e\u000e\u00039R!a\f\u0019\u0002\u0005\u0011\u0014'BA\u00193\u0003\u0011!\u0017\r^1\u000b\u0005M\"\u0014\u0001B2pe\u0016T!!\u000e\u001c\u0002\u0015)\f7m\u001b:bE\nLGO\u0003\u00028q\u00051\u0011\r]1dQ\u0016T\u0011!O\u0001\u0004_J<\u0017BA\u001e/\u0005-!%\rR1uCN#xN]3\t\u0011u\u0002!\u0011!Q\u0001\ny\n!\u0003\u001e:b]N\f7\r^5p]6\u000bg.Y4feB\u0011q\bR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\fiJ\fgn]1di&|gN\u0003\u0002Dq\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148.\u0003\u0002F\u0001\nQ\u0002\u000b\\1uM>\u0014X\u000e\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\"Aq\t\u0001B\u0001B\u0003%\u0001*A\u0005cCR\u001c\u0007nU5{KB\u0011Q\"S\u0005\u0003\u0015:\u00111!\u00138u\u0011\u0015a\u0005\u0001\"\u0001N\u0003\u0019a\u0014N\\5u}Q)aj\u0014)R%B\u00111\u0003\u0001\u0005\u0006?-\u0003\r\u0001\t\u0005\u0006W-\u0003\r\u0001\f\u0005\u0006{-\u0003\rA\u0010\u0005\u0006\u000f.\u0003\r\u0001\u0013\u0005\u0006)\u0002!\t%V\u0001\b[&<'/\u0019;f)\u00051\u0006CA\u0007X\u0013\tAfB\u0001\u0003V]&$\b")
public class Database
implements ArtifactsMigration,
Logging {
    private final DbArtifactRepository dbArtifactRepository;
    private final DbDataStore dbDataStore;
    private final PlatformTransactionManager transactionManager;
    private final int batchSize;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        Database database = this;
        synchronized (database) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public void migrate() {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Migrating artifacts from database. Batch size: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.batchSize)})));
        Iterator identifiers = this.dbDataStore.getAllIdentifiers();
        IntRef batchCount = IntRef.create((int)0);
        while (identifiers.hasNext()) {
            IntRef count = IntRef.create((int)0);
            ++batchCount.elem;
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing batch ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batchCount$1.elem)})));
            TransactionStatus transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
            try {
                try {
                    while (identifiers.hasNext() && count.elem < this.batchSize) {
                        Object object;
                        DataIdentifier id = (DataIdentifier)identifiers.next();
                        String idStr = id.toString();
                        if (this.dbArtifactRepository.exists(idStr)) {
                            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found artifact already migrated: '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{idStr})));
                            object = BoxedUnit.UNIT;
                        } else {
                            object = BoxesRunTime.boxToInteger((int)this.dbArtifactRepository.insert(idStr, this.dbDataStore.getRecord(id).getStream()));
                        }
                        ++count.elem;
                    }
                }
                catch (Throwable t) {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> "Error while migrating database artifacts.", (Function0 & Serializable & scala.Serializable)() -> t);
                    transactionStatus.setRollbackOnly();
                    throw t;
                }
            }
            finally {
                if (transactionStatus.isRollbackOnly()) {
                    this.transactionManager.rollback(transactionStatus);
                } else {
                    this.transactionManager.commit(transactionStatus);
                }
            }
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished processing batch ", ". Processed ", " artifacts."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batchCount$1.elem), BoxesRunTime.boxToInteger((int)count$1.elem)})));
        }
    }

    public Database(DbArtifactRepository dbArtifactRepository, DbDataStore dbDataStore, PlatformTransactionManager transactionManager, int batchSize) {
        this.dbArtifactRepository = dbArtifactRepository;
        this.dbDataStore = dbDataStore;
        this.transactionManager = transactionManager;
        this.batchSize = batchSize;
        Logging.$init$((Logging)this);
    }
}

