/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Set;
import liquibase.changelog.ChangeSet;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.logging.LogFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.UtfBomAwareReader;

public class StreamUtil {
    public static String getLineSeparator() {
        return LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputLineSeparator();
    }

    public static String getStreamContents(InputStream ins) throws IOException {
        return StreamUtil.getReaderContents(new UtfBomAwareReader(ins));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStreamContents(InputStream ins, String charsetName) throws IOException {
        if (ins == null) {
            throw new IOException("No stream to open");
        }
        try {
            UtfBomAwareReader reader;
            if (charsetName == null) {
                reader = new UtfBomAwareReader(ins);
            } else {
                String charsetCanonicalName = Charset.forName(charsetName).name();
                reader = new UtfBomAwareReader(ins, charsetName);
                String encoding = Charset.forName(reader.getEncoding()).name();
                if (charsetCanonicalName.startsWith("UTF") && !charsetCanonicalName.equals(encoding)) {
                    reader.close();
                    throw new IllegalArgumentException("Expected encoding was '" + charsetCanonicalName + "' but a BOM was detected for '" + encoding + "'");
                }
            }
            String string = StreamUtil.getReaderContents(reader);
            return string;
        }
        finally {
            ins.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReaderContents(Reader reader) throws IOException {
        try {
            int read;
            StringBuffer result = new StringBuffer();
            char[] buffer = new char[2048];
            while ((read = reader.read(buffer)) > -1) {
                result.append(buffer, 0, read);
            }
            String string = result.toString();
            return string;
        }
        finally {
            StreamUtil.closeQuietly(reader);
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] bytes = new byte[1024];
        int r = inputStream.read(bytes);
        while (r > 0) {
            outputStream.write(bytes, 0, r);
            r = inputStream.read(bytes);
        }
    }

    public static long getContentLength(InputStream in) throws IOException {
        long length = 0L;
        byte[] buf = new byte[4096];
        int bytesRead = in.read(buf);
        while (bytesRead > 0) {
            length += (long)bytesRead;
            bytesRead = in.read(buf);
        }
        return length;
    }

    public static long getContentLength(Reader reader) throws IOException {
        long length = 0L;
        char[] buf = new char[2048];
        int charsRead = reader.read(buf);
        while (charsRead > 0) {
            length += (long)charsRead;
            charsRead = reader.read(buf);
        }
        return length;
    }

    public static void closeQuietly(Reader input) {
        StreamUtil.closeQuietly((Closeable)input);
    }

    public static void closeQuietly(InputStream input) {
        StreamUtil.closeQuietly((Closeable)input);
    }

    public static void closeQuietly(Closeable input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static InputStream openStream(String path, Boolean relativeToChangelogFile, ChangeSet changeSet, ResourceAccessor resourceAccessor) throws IOException {
        InputStream stream = StreamUtil.openFromClasspath(path, relativeToChangelogFile, changeSet, resourceAccessor);
        if (stream == null) {
            stream = StreamUtil.openFromFileSystem(path, relativeToChangelogFile, changeSet, resourceAccessor);
        }
        return stream;
    }

    private static InputStream openFromFileSystem(String file, Boolean relativeToChangelogFile, ChangeSet changeSet, ResourceAccessor resourceAccessor) throws IOException {
        if (resourceAccessor == null) {
            return null;
        }
        if (relativeToChangelogFile != null && relativeToChangelogFile.booleanValue()) {
            String base = changeSet.getChangeLog() == null ? changeSet.getFilePath() : changeSet.getChangeLog().getPhysicalFilePath().replaceAll("\\\\", "/");
            if (!base.contains("/")) {
                base = ".";
            }
            file = base.replaceFirst("/[^/]*$", "") + "/" + file;
        }
        return StreamUtil.singleInputStream(file, resourceAccessor);
    }

    public static InputStream singleInputStream(String path, ResourceAccessor resourceAccessor) throws IOException {
        Set<InputStream> streams = resourceAccessor.getResourcesAsStream(path);
        if (streams == null || streams.size() == 0) {
            return null;
        }
        if (streams.size() != 1) {
            if (streams.size() > 1 && path != null && path.startsWith("liquibase/parser/core/xml/") && path.endsWith(".xsd")) {
                LogFactory.getLogger().debug("Found " + streams.size() + " files that match " + path + ", but choosing one at random.");
                InputStream returnStream = null;
                for (InputStream stream : streams) {
                    if (returnStream == null) {
                        returnStream = stream;
                        continue;
                    }
                    stream.close();
                }
            } else {
                for (InputStream stream : streams) {
                    stream.close();
                }
                throw new IOException("Found " + streams.size() + " files that match " + path);
            }
        }
        return streams.iterator().next();
    }

    private static InputStream openFromClasspath(String file, Boolean relativeToChangelogFile, ChangeSet changeSet, ResourceAccessor resourceAccessor) throws IOException {
        if (resourceAccessor == null) {
            return null;
        }
        if (relativeToChangelogFile != null && relativeToChangelogFile.booleanValue()) {
            String base = changeSet.getChangeLog() == null ? changeSet.getFilePath() : changeSet.getChangeLog().getPhysicalFilePath().replaceAll("\\\\", "/");
            if (base == null || !base.contains("/")) {
                base = ".";
            }
            file = base.replaceFirst("/[^/]*$", "") + "/" + file;
        }
        return StreamUtil.singleInputStream(file, resourceAccessor);
    }
}

