/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.io.ByteArrayInputStream;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDecoder;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ResourceDecoder
extends AbstractDecoder<Resource> {
    public ResourceDecoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        Class<ByteArrayResource> clazz = elementType.getRawClass();
        return clazz != null && (InputStreamResource.class == clazz || clazz.isAssignableFrom(ByteArrayResource.class)) && super.canDecode(elementType, mimeType);
    }

    @Override
    public Flux<Resource> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.from(this.decodeToMono(inputStream, elementType, mimeType, hints));
    }

    @Override
    public Mono<Resource> decodeToMono(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        Class<ByteArrayResource> clazz = elementType.getRawClass();
        Assert.state(clazz != null, "No resource class");
        Mono byteArray = Flux.from(inputStream).reduce((rec$, xva$0) -> ((DataBuffer)rec$).write((DataBuffer)xva$0)).map(dataBuffer -> {
            byte[] bytes = new byte[dataBuffer.readableByteCount()];
            dataBuffer.read(bytes);
            DataBufferUtils.release(dataBuffer);
            return bytes;
        });
        if (InputStreamResource.class == clazz) {
            return Mono.from((Publisher)byteArray.map(ByteArrayInputStream::new).map(InputStreamResource::new));
        }
        if (clazz.isAssignableFrom(ByteArrayResource.class)) {
            return Mono.from((Publisher)byteArray.map(ByteArrayResource::new));
        }
        return Mono.error((Throwable)new IllegalStateException("Unsupported resource class: " + clazz));
    }
}

