/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;

public class FrameDescriptor {
    public static final int FRAME_ALIGNMENT = 32;
    public static final byte BEGIN_FRAG_FLAG = -128;
    public static final byte END_FRAG_FLAG = 64;
    public static final byte UNFRAGMENTED = -64;
    public static final int VERSION_OFFSET = 4;
    public static final int FLAGS_OFFSET = 5;
    public static final int TYPE_OFFSET = 6;
    public static final int TERM_OFFSET = 8;
    public static final int TERM_ID_OFFSET = 20;
    public static final int PADDING_FRAME_TYPE = 0;

    public static int computeMaxMessageLength(int capacity) {
        return capacity / 8;
    }

    public static int computeExclusiveMaxMessageLength(int capacity) {
        return capacity / 4;
    }

    public static int lengthOffset(int termOffset) {
        return termOffset;
    }

    public static int versionOffset(int termOffset) {
        return termOffset + 4;
    }

    public static int flagsOffset(int termOffset) {
        return termOffset + 5;
    }

    public static int typeOffset(int termOffset) {
        return termOffset + 6;
    }

    public static int termOffsetOffset(int termOffset) {
        return termOffset + 8;
    }

    public static int termIdOffset(int termOffset) {
        return termOffset + 20;
    }

    public static int frameVersion(UnsafeBuffer buffer, int termOffset) {
        return buffer.getByte(FrameDescriptor.versionOffset(termOffset));
    }

    public static int frameType(UnsafeBuffer buffer, int termOffset) {
        return buffer.getShort(FrameDescriptor.typeOffset(termOffset), ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static boolean isPaddingFrame(UnsafeBuffer buffer, int termOffset) {
        return buffer.getShort(FrameDescriptor.typeOffset(termOffset)) == 0;
    }

    public static int frameLength(UnsafeBuffer buffer, int termOffset) {
        return buffer.getInt(termOffset, ByteOrder.LITTLE_ENDIAN);
    }

    public static int frameLengthVolatile(UnsafeBuffer buffer, int termOffset) {
        int frameLength = buffer.getIntVolatile(termOffset);
        if (ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
            frameLength = Integer.reverseBytes(frameLength);
        }
        return frameLength;
    }

    public static void frameLengthOrdered(UnsafeBuffer buffer, int termOffset, int frameLength) {
        int length = frameLength;
        if (ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
            length = Integer.reverseBytes(frameLength);
        }
        buffer.putIntOrdered(termOffset, length);
    }

    public static void frameType(UnsafeBuffer buffer, int termOffset, int type) {
        buffer.putShort(FrameDescriptor.typeOffset(termOffset), (short)type, ByteOrder.LITTLE_ENDIAN);
    }

    public static void frameFlags(UnsafeBuffer buffer, int termOffset, byte flags) {
        buffer.putByte(FrameDescriptor.flagsOffset(termOffset), flags);
    }

    public static void frameTermOffset(UnsafeBuffer buffer, int termOffset) {
        buffer.putInt(FrameDescriptor.termOffsetOffset(termOffset), termOffset, ByteOrder.LITTLE_ENDIAN);
    }

    public static void frameTermId(UnsafeBuffer buffer, int termOffset, int termId) {
        buffer.putInt(FrameDescriptor.termIdOffset(termOffset), termId, ByteOrder.LITTLE_ENDIAN);
    }
}

