/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.FilenameUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.sax.ContentHandlerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RecursiveParserWrapper
implements Parser {
    private static final long serialVersionUID = 9086536568120690938L;
    public static final Property TIKA_CONTENT = Property.internalText("X-TIKA:content");
    public static final Property PARSE_TIME_MILLIS = Property.internalText("X-TIKA:parse_time_millis");
    public static final Property WRITE_LIMIT_REACHED = Property.internalBoolean("X-TIKA:EXCEPTION:write_limit_reached");
    public static final Property EMBEDDED_RESOURCE_LIMIT_REACHED = Property.internalBoolean("X-TIKA:EXCEPTION:embedded_resource_limit_reached");
    public static final Property EMBEDDED_RESOURCE_PATH = Property.internalText("X-TIKA:embedded_resource_path");
    private final Parser wrappedParser;
    private final ContentHandlerFactory contentHandlerFactory;
    private final List<Metadata> metadatas = new LinkedList<Metadata>();
    private int unknownCount = 0;
    private int maxEmbeddedResources = -1;
    private boolean hitMaxEmbeddedResources = false;

    public RecursiveParserWrapper(Parser wrappedParser, ContentHandlerFactory contentHandlerFactory) {
        this.wrappedParser = wrappedParser;
        this.contentHandlerFactory = contentHandlerFactory;
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.wrappedParser.getSupportedTypes(context);
    }

    @Override
    public void parse(InputStream stream, ContentHandler ignore, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        String name = this.getResourceName(metadata);
        EmbeddedParserDecorator decorator = new EmbeddedParserDecorator(name);
        context.set(Parser.class, decorator);
        ContentHandler localHandler = this.contentHandlerFactory.getNewContentHandler();
        long started = new Date().getTime();
        try {
            this.wrappedParser.parse(stream, localHandler, metadata, context);
        }
        catch (SAXException e) {
            boolean wlr = this.isWriteLimitReached(e);
            if (!wlr) {
                throw e;
            }
            metadata.set(WRITE_LIMIT_REACHED, "true");
        }
        long elapsedMillis = new Date().getTime() - started;
        metadata.set(PARSE_TIME_MILLIS, Long.toString(elapsedMillis));
        this.addContent(localHandler, metadata);
        if (this.hitMaxEmbeddedResources) {
            metadata.set(EMBEDDED_RESOURCE_LIMIT_REACHED, "true");
        }
        this.metadatas.add(0, this.deepCopy(metadata));
    }

    public List<Metadata> getMetadata() {
        return this.metadatas;
    }

    public void setMaxEmbeddedResources(int max) {
        this.maxEmbeddedResources = max;
    }

    public void reset() {
        this.metadatas.clear();
        this.unknownCount = 0;
        this.hitMaxEmbeddedResources = false;
    }

    private boolean isWriteLimitReached(Throwable t) {
        if (t.getMessage().indexOf("Your document contained more than") == 0) {
            return true;
        }
        return t.getCause() != null && this.isWriteLimitReached(t.getCause());
    }

    private Metadata deepCopy(Metadata m) {
        Metadata clone = new Metadata();
        for (String n : m.names()) {
            if (!m.isMultiValued(n)) {
                clone.set(n, m.get(n));
                continue;
            }
            String[] vals = m.getValues(n);
            for (int i = 0; i < vals.length; ++i) {
                clone.add(n, vals[i]);
            }
        }
        return clone;
    }

    private String getResourceName(Metadata metadata) {
        String objectName = "";
        objectName = metadata.get("resourceName") != null ? metadata.get("resourceName") : (metadata.get("embeddedRelationshipId") != null ? metadata.get("embeddedRelationshipId") : "embedded-" + ++this.unknownCount);
        objectName = FilenameUtils.getName(objectName);
        return objectName;
    }

    private void addContent(ContentHandler handler, Metadata metadata) {
        String content;
        if (!handler.getClass().equals(DefaultHandler.class) && (content = handler.toString()) != null && content.trim().length() > 0) {
            metadata.add(TIKA_CONTENT, content);
        }
    }

    private class EmbeddedParserDecorator
    extends ParserDecorator {
        private static final long serialVersionUID = 207648200464263337L;
        private String location;

        private EmbeddedParserDecorator(String location) {
            super(RecursiveParserWrapper.this.wrappedParser);
            this.location = null;
            this.location = location;
            if (!this.location.endsWith("/")) {
                this.location = this.location + "/";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(InputStream stream, ContentHandler ignore, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
            ContentHandler localHandler;
            block8: {
                if (RecursiveParserWrapper.this.maxEmbeddedResources > -1 && RecursiveParserWrapper.this.metadatas.size() >= RecursiveParserWrapper.this.maxEmbeddedResources) {
                    RecursiveParserWrapper.this.hitMaxEmbeddedResources = true;
                    return;
                }
                String objectName = RecursiveParserWrapper.this.getResourceName(metadata);
                String objectLocation = this.location + objectName;
                metadata.add(EMBEDDED_RESOURCE_PATH, objectLocation);
                localHandler = RecursiveParserWrapper.this.contentHandlerFactory.getNewContentHandler();
                Parser preContextParser = context.get(Parser.class);
                context.set(Parser.class, new EmbeddedParserDecorator(objectLocation));
                try {
                    super.parse(stream, localHandler, metadata, context);
                }
                catch (SAXException e) {
                    boolean wlr = RecursiveParserWrapper.this.isWriteLimitReached(e);
                    if (wlr) {
                        metadata.add(WRITE_LIMIT_REACHED, "true");
                        break block8;
                    }
                    throw e;
                }
                finally {
                    context.set(Parser.class, preContextParser);
                }
            }
            if (RecursiveParserWrapper.this.maxEmbeddedResources > -1 && RecursiveParserWrapper.this.metadatas.size() >= RecursiveParserWrapper.this.maxEmbeddedResources) {
                RecursiveParserWrapper.this.hitMaxEmbeddedResources = true;
                return;
            }
            RecursiveParserWrapper.this.addContent(localHandler, metadata);
            RecursiveParserWrapper.this.metadatas.add(RecursiveParserWrapper.this.deepCopy(metadata));
        }
    }
}

