/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.scaladsl;

import akka.pattern.BackoffSupervisor$;
import akka.stream.Inlet;
import akka.stream.Outlet;
import akka.stream.Shape;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.stream.stage.TimerGraphStageLogicWithLogging;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%c!B\u0001\u0003\u0003\u0013I!a\u0006*fgR\f'\u000f^,ji\"\u0014\u0015mY6pM\u001adunZ5d\u0015\t\u0019A!\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0002\u000f\u0005!\u0011m[6b\u0007\u0001)\"A\u0003\u0013\u0014\u0005\u0001Y\u0001C\u0001\u0007\u0010\u001b\u0005i!B\u0001\b\u0005\u0003\u0015\u0019H/Y4f\u0013\t\u0001RBA\u0010US6,'o\u0012:ba\"\u001cF/Y4f\u0019><\u0017nY,ji\"dunZ4j]\u001eD\u0001B\u0005\u0001\u0003\u0002\u0003\u0006IaE\u0001\u0005]\u0006lW\r\u0005\u0002\u0015;9\u0011Qc\u0007\t\u0003-ei\u0011a\u0006\u0006\u00031!\ta\u0001\u0010:p_Rt$\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\u0012A\u0002)sK\u0012,g-\u0003\u0002\u001f?\t11\u000b\u001e:j]\u001eT!\u0001H\r\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\nQa\u001d5ba\u0016\u0004\"a\t\u0013\r\u0001\u0011)Q\u0005\u0001b\u0001M\t\t1+\u0005\u0002(WA\u0011\u0001&K\u0007\u00023%\u0011!&\u0007\u0002\b\u001d>$\b.\u001b8h!\taS&D\u0001\u0005\u0013\tqCAA\u0003TQ\u0006\u0004X\r\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0003)i\u0017N\u001c\"bG.|gM\u001a\t\u0003e]j\u0011a\r\u0006\u0003iU\n\u0001\u0002Z;sCRLwN\u001c\u0006\u0003me\t!bY8oGV\u0014(/\u001a8u\u0013\tA4G\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\t\u0011i\u0002!\u0011!Q\u0001\nE\n!\"\\1y\u0005\u0006\u001c7n\u001c4g\u0011!a\u0004A!A!\u0002\u0013i\u0014\u0001\u0004:b]\u0012|WNR1di>\u0014\bC\u0001\u0015?\u0013\ty\u0014D\u0001\u0004E_V\u0014G.\u001a\u0005\u0006\u0003\u0002!\tAQ\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\r+ei\u0012%J!\r!\u0005AI\u0007\u0002\u0005!)!\u0003\u0011a\u0001'!)\u0011\u0005\u0011a\u0001E!)\u0001\u0007\u0011a\u0001c!)!\b\u0011a\u0001c!)A\b\u0011a\u0001{!91\n\u0001a\u0001\n\u0003a\u0015\u0001\u0004:fgR\f'\u000f^\"pk:$X#A'\u0011\u0005!r\u0015BA(\u001a\u0005\rIe\u000e\u001e\u0005\b#\u0002\u0001\r\u0011\"\u0001S\u0003A\u0011Xm\u001d;beR\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002T-B\u0011\u0001\u0006V\u0005\u0003+f\u0011A!\u00168ji\"9q\u000bUA\u0001\u0002\u0004i\u0015a\u0001=%c!1\u0011\f\u0001Q!\n5\u000bQB]3ti\u0006\u0014HoQ8v]R\u0004\u0003bB.\u0001\u0001\u0004%\t\u0001X\u0001\u000ee\u0016\u001cX\r\u001e#fC\u0012d\u0017N\\3\u0016\u0003u\u0003\"A\r0\n\u0005}\u001b$\u0001\u0003#fC\u0012d\u0017N\\3\t\u000f\u0005\u0004\u0001\u0019!C\u0001E\u0006\t\"/Z:fi\u0012+\u0017\r\u001a7j]\u0016|F%Z9\u0015\u0005M\u001b\u0007bB,a\u0003\u0003\u0005\r!\u0018\u0005\u0007K\u0002\u0001\u000b\u0015B/\u0002\u001dI,7/\u001a;EK\u0006$G.\u001b8fA!9q\r\u0001a\u0001\n\u0003A\u0017!\u00034j]&\u001c\b.\u001b8h+\u0005I\u0007C\u0001\u0015k\u0013\tY\u0017DA\u0004C_>dW-\u00198\t\u000f5\u0004\u0001\u0019!C\u0001]\u0006ia-\u001b8jg\"LgnZ0%KF$\"aU8\t\u000f]c\u0017\u0011!a\u0001S\"1\u0011\u000f\u0001Q!\n%\f!BZ5oSND\u0017N\\4!\u0011\u0015\u0019\bA\"\u0005u\u0003)\u0019H/\u0019:u\u000fJ\f\u0007\u000f\u001b\u000b\u0002'\")a\u000f\u0001D\ti\u00069!-Y2l_\u001a4\u0007\"\u0002=\u0001\t+I\u0018AD2sK\u0006$XmU;c\u0013:dW\r^\u000b\u0004u\u0006\u0015AcA>\u0002\u0012A!A0`A\u0002\u001b\u0005\u0001\u0011B\u0001@\u0000\u00051\u0019VOY*j].Le\u000e\\3u\u0013\r\t\t!\u0004\u0002\u0010\u000fJ\f\u0007\u000f[*uC\u001e,Gj\\4jGB\u00191%!\u0002\u0005\u000f\u0005\u001dqO1\u0001\u0002\n\t\tA+E\u0002(\u0003\u0017\u00012\u0001KA\u0007\u0013\r\ty!\u0007\u0002\u0004\u0003:L\bbBA\no\u0002\u0007\u0011QC\u0001\u0004_V$\b#\u0002\u0017\u0002\u0018\u0005\r\u0011bAA\r\t\t1q*\u001e;mKRDq!!\b\u0001\t+\ty\"A\bde\u0016\fG/Z*vE>+H\u000f\\3u+\u0011\t\t#a\u000b\u0015\t\u0005\r\u0012Q\u0006\t\u0006y\u0006\u0015\u0012\u0011F\u0005\u0004\u0003Oy(aD*vEN{WO]2f\u001fV$H.\u001a;\u0011\u0007\r\nY\u0003\u0002\u0005\u0002\b\u0005m!\u0019AA\u0005\u0011!\ty#a\u0007A\u0002\u0005E\u0012AA5o!\u0015a\u00131GA\u0015\u0013\r\t)\u0004\u0002\u0002\u0006\u0013:dW\r\u001e\u0005\u0007\u0003s\u0001AQ\u0003;\u0002'=t7i\\7qY\u0016$Xm\u0014:GC&dWO]3\t\u000f\u0005u\u0002\u0001\"\u0015\u0002@\u00059qN\u001c+j[\u0016\u0014HcA*\u0002B!A\u00111IA\u001e\u0001\u0004\tY!\u0001\u0005uS6,'oS3z\u0011\u0019\t9\u0005\u0001C!i\u0006A\u0001O]3Ti\u0006\u0014H\u000f")
public abstract class RestartWithBackoffLogic<S extends Shape>
extends TimerGraphStageLogicWithLogging {
    private final String name;
    private final FiniteDuration minBackoff;
    private final FiniteDuration maxBackoff;
    private final double randomFactor;
    private int restartCount;
    private Deadline resetDeadline;
    private boolean finishing;

    public int restartCount() {
        return this.restartCount;
    }

    public void restartCount_$eq(int x$1) {
        this.restartCount = x$1;
    }

    public Deadline resetDeadline() {
        return this.resetDeadline;
    }

    public void resetDeadline_$eq(Deadline x$1) {
        this.resetDeadline = x$1;
    }

    public boolean finishing() {
        return this.finishing;
    }

    public void finishing_$eq(boolean x$1) {
        this.finishing = x$1;
    }

    public abstract void startGraph();

    public abstract void backoff();

    /*
     * WARNING - void declaration
     */
    public final <T> GraphStageLogic.SubSinkInlet<T> createSubInlet(Outlet<T> out) {
        void var2_2;
        GraphStageLogic.SubSinkInlet sinkIn = new GraphStageLogic.SubSinkInlet(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RestartWithBackoff", ".subIn"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name})));
        sinkIn.setHandler(new InHandler(this, out, sinkIn){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final Outlet out$1;
            private final GraphStageLogic.SubSinkInlet sinkIn$1;

            public void onPush() {
                this.$outer.push(this.out$1, this.sinkIn$1.grab());
            }

            public void onUpstreamFinish() {
                if (this.$outer.finishing()) {
                    this.$outer.complete(this.out$1);
                } else {
                    this.$outer.log().debug("Graph out finished");
                    this.$outer.onCompleteOrFailure();
                }
            }

            public void onUpstreamFailure(Throwable ex) {
                if (this.$outer.finishing()) {
                    this.$outer.fail(this.out$1, ex);
                } else {
                    this.$outer.log().error(ex, "Restarting graph due to failure");
                    this.$outer.onCompleteOrFailure();
                }
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.out$1 = out$1;
                this.sinkIn$1 = var3_3;
                InHandler.$init$(this);
            }
        });
        this.setHandler(out, new OutHandler(this, sinkIn){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final GraphStageLogic.SubSinkInlet sinkIn$1;

            public void onPull() {
                this.sinkIn$1.pull();
            }

            public void onDownstreamFinish() {
                this.$outer.finishing_$eq(true);
                this.sinkIn$1.cancel();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sinkIn$1 = sinkIn$1;
                OutHandler.$init$(this);
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> GraphStageLogic.SubSourceOutlet<T> createSubOutlet(Inlet<T> in) {
        void var2_2;
        GraphStageLogic.SubSourceOutlet sourceOut = new GraphStageLogic.SubSourceOutlet(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RestartWithBackoff", ".subOut"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name})));
        sourceOut.setHandler(new OutHandler(this, in, sourceOut){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final Inlet in$1;
            private final GraphStageLogic.SubSourceOutlet sourceOut$1;

            public void onPull() {
                if (this.$outer.isAvailable(this.in$1)) {
                    this.sourceOut$1.push(this.$outer.grab(this.in$1));
                } else {
                    this.$outer.pull(this.in$1);
                }
            }

            public void onDownstreamFinish() {
                if (this.$outer.finishing()) {
                    this.$outer.cancel(this.in$1);
                } else {
                    this.$outer.log().debug("Graph in finished");
                    this.$outer.onCompleteOrFailure();
                }
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.in$1 = in$1;
                this.sourceOut$1 = var3_3;
                OutHandler.$init$(this);
            }
        });
        this.setHandler(in, new InHandler(this, in, sourceOut){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final Inlet in$1;
            private final GraphStageLogic.SubSourceOutlet sourceOut$1;

            public void onPush() {
                block0: {
                    if (!this.sourceOut$1.isAvailable()) break block0;
                    this.sourceOut$1.push(this.$outer.grab(this.in$1));
                }
            }

            public void onUpstreamFinish() {
                this.$outer.finishing_$eq(true);
                this.sourceOut$1.complete();
            }

            public void onUpstreamFailure(Throwable ex) {
                this.$outer.finishing_$eq(true);
                this.sourceOut$1.fail(ex);
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.in$1 = in$1;
                this.sourceOut$1 = var3_3;
                InHandler.$init$(this);
            }
        });
        return var2_2;
    }

    public final void onCompleteOrFailure() {
        if (this.resetDeadline().isOverdue()) {
            this.log().debug("Last restart attempt was more than {} ago, resetting restart count", (Object)this.minBackoff);
            this.restartCount_$eq(0);
        }
        FiniteDuration restartDelay = BackoffSupervisor$.MODULE$.calculateDelay(this.restartCount(), this.minBackoff, this.maxBackoff, this.randomFactor);
        this.log().debug("Restarting graph in {}", (Object)restartDelay);
        this.scheduleOnce("RestartTimer", restartDelay);
        this.restartCount_$eq(this.restartCount() + 1);
        this.backoff();
    }

    @Override
    public void onTimer(Object timerKey) {
        this.startGraph();
        this.resetDeadline_$eq(this.minBackoff.fromNow());
    }

    @Override
    public void preStart() {
        this.startGraph();
    }

    public RestartWithBackoffLogic(String name, S shape, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor) {
        this.name = name;
        this.minBackoff = minBackoff;
        this.maxBackoff = maxBackoff;
        this.randomFactor = randomFactor;
        super((Shape)shape);
        this.restartCount = 0;
        this.resetDeadline = minBackoff.fromNow();
        this.finishing = false;
    }
}

