/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.share;

import com.hierynomus.mserref.NtStatus;
import com.hierynomus.msfscc.fileinformation.FileEndOfFileInformation;
import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.SMB2Header;
import com.hierynomus.mssmb2.SMBApiException;
import com.hierynomus.mssmb2.messages.SMB2ReadResponse;
import com.hierynomus.mssmb2.messages.SMB2WriteResponse;
import com.hierynomus.smbj.ProgressListener;
import com.hierynomus.smbj.io.ArrayByteChunkProvider;
import com.hierynomus.smbj.io.ByteChunkProvider;
import com.hierynomus.smbj.share.DiskEntry;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.FileInputStream;
import com.hierynomus.smbj.share.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class File
extends DiskEntry {
    private static final Logger logger = LoggerFactory.getLogger(File.class);

    File(SMB2FileId fileId, DiskShare diskShare, String fileName) {
        super(fileId, diskShare, fileName);
    }

    public int write(byte[] buffer, long fileOffset) {
        return this.write(buffer, fileOffset, 0, buffer.length);
    }

    public int write(byte[] buffer, long fileOffset, int offset, int length) {
        return this.write(new ArrayByteChunkProvider(buffer, offset, length, fileOffset), null);
    }

    public int write(ByteChunkProvider provider) {
        return this.write(provider, null);
    }

    public int write(ByteChunkProvider provider, ProgressListener progressListener) {
        int bytesWritten = 0;
        while (provider.isAvailable()) {
            logger.debug("Writing to {} from offset {}", (Object)this.fileName, (Object)provider.getOffset());
            SMB2WriteResponse wresp = this.share.write(this.fileId, provider);
            bytesWritten = (int)((long)bytesWritten + wresp.getBytesWritten());
            if (progressListener == null) continue;
            progressListener.onProgressChanged(wresp.getBytesWritten(), provider.getOffset());
        }
        return bytesWritten;
    }

    public OutputStream getOutputStream() {
        return this.getOutputStream(null);
    }

    public OutputStream getOutputStream(ProgressListener listener) {
        return new FileOutputStream(this, this.share.getWriteBufferSize(), listener);
    }

    public int read(byte[] buffer, long fileOffset) {
        return this.read(buffer, fileOffset, 0, buffer.length);
    }

    public int read(byte[] buffer, long fileOffset, int offset, int length) {
        SMB2ReadResponse response = this.share.read(this.fileId, fileOffset, length);
        if (((SMB2Header)response.getHeader()).getStatus() == NtStatus.STATUS_END_OF_FILE) {
            return -1;
        }
        byte[] data = response.getData();
        int bytesRead = Math.min(length, data.length);
        System.arraycopy(data, 0, buffer, offset, bytesRead);
        return bytesRead;
    }

    Future<SMB2ReadResponse> readAsync(long offset, int length) {
        return this.share.readAsync(this.fileId, offset, length);
    }

    public void read(OutputStream destStream) throws IOException {
        this.read(destStream, null);
    }

    public void read(OutputStream destStream, ProgressListener progressListener) throws IOException {
        int numRead;
        InputStream is = this.getInputStream(progressListener);
        byte[] buf = new byte[this.share.getReadBufferSize()];
        while ((numRead = is.read(buf)) != -1) {
            destStream.write(buf, 0, numRead);
        }
        is.close();
    }

    public void setLength(long endOfFile) throws SMBApiException {
        FileEndOfFileInformation endOfFileInfo = new FileEndOfFileInformation(endOfFile);
        this.setFileInformation(endOfFileInfo);
    }

    public InputStream getInputStream() {
        return this.getInputStream(null);
    }

    public InputStream getInputStream(ProgressListener listener) {
        return new FileInputStream(this, this.share.getReadBufferSize(), this.share.getReadTimeout(), listener);
    }

    public String toString() {
        return "File{fileId=" + this.fileId + ", fileName='" + this.fileName + '\'' + '}';
    }
}

