/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.Arrays;
import java.util.function.LongUnaryOperator;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.LongLongConsumer;

public class Long2LongCounterMap {
    private final float loadFactor;
    private final long initialValue;
    private int resizeThreshold;
    private int size = 0;
    private long[] entries;

    public Long2LongCounterMap(long initialValue) {
        this(8, 0.55f, initialValue);
    }

    public Long2LongCounterMap(int initialCapacity, float loadFactor, long initialValue) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.initialValue = initialValue;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(initialCapacity));
    }

    public long initialValue() {
        return this.initialValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public long get(long key) {
        long[] entries = this.entries;
        long initialValue = this.initialValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        long value = initialValue;
        while (entries[index + 1] != initialValue) {
            if (entries[index] == key) {
                value = entries[index + 1];
                break;
            }
            index = Long2LongCounterMap.next(index, mask);
        }
        return value;
    }

    public long put(long key, long value) {
        if (value == this.initialValue) {
            throw new IllegalArgumentException("Cannot accept initialValue");
        }
        long[] entries = this.entries;
        long initialValue = this.initialValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        long oldValue = initialValue;
        while (entries[index + 1] != initialValue) {
            if (entries[index] == key) {
                oldValue = entries[index + 1];
                break;
            }
            index = Long2LongCounterMap.next(index, mask);
        }
        if (oldValue == initialValue) {
            ++this.size;
            entries[index] = key;
        }
        entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    public long incrementAndGet(long key) {
        return this.addAndGet(key, 1L);
    }

    public long decrementAndGet(long key) {
        return this.addAndGet(key, -1L);
    }

    public long addAndGet(long key, long amount) {
        return this.getAndAdd(key, amount) + amount;
    }

    public long getAndIncrement(long key) {
        return this.getAndAdd(key, 1L);
    }

    public long getAndDecrement(long key) {
        return this.getAndAdd(key, -1L);
    }

    public long getAndAdd(long key, long amount) {
        long[] entries = this.entries;
        long initialValue = this.initialValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        long oldValue = initialValue;
        while (entries[index + 1] != initialValue) {
            if (entries[index] == key) {
                oldValue = entries[index + 1];
                break;
            }
            index = Long2LongCounterMap.next(index, mask);
        }
        if (amount != 0L) {
            long newValue;
            entries[index + 1] = newValue = oldValue + amount;
            if (oldValue == initialValue) {
                ++this.size;
                entries[index] = key;
                this.increaseCapacity();
            } else if (newValue == initialValue) {
                --this.size;
                this.compactChain(index);
            }
        }
        return oldValue;
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        long[] oldEntries = this.entries;
        long initialValue = this.initialValue;
        int length = this.entries.length;
        this.capacity(newCapacity);
        for (int i = 0; i < length; i += 2) {
            long key = oldEntries[i];
            if (oldEntries[i + 1] == initialValue) continue;
            this.put(key, oldEntries[i + 1]);
        }
    }

    public void forEach(LongLongConsumer consumer) {
        long[] entries = this.entries;
        long initialValue = this.initialValue;
        int length = entries.length;
        for (int i = 0; i < length; i += 2) {
            if (entries[i + 1] == initialValue) continue;
            consumer.accept(entries[i], entries[i + 1]);
        }
    }

    public boolean containsKey(long key) {
        return this.get(key) != this.initialValue;
    }

    public boolean containsValue(long value) {
        boolean found = false;
        if (value != this.initialValue) {
            long[] entries = this.entries;
            int length = entries.length;
            for (int i = 1; i < length; i += 2) {
                if (value != entries[i]) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public void clear() {
        Arrays.fill(this.entries, this.initialValue);
        this.size = 0;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(idealCapacity));
    }

    public long computeIfAbsent(long key, LongUnaryOperator mappingFunction) {
        long value = this.get(key);
        if (value == this.initialValue && (value = mappingFunction.applyAsLong(key)) != this.initialValue) {
            this.put(key, value);
        }
        return value;
    }

    public long remove(long key) {
        long[] entries = this.entries;
        long initialValue = this.initialValue;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        long oldValue = initialValue;
        while (entries[keyIndex + 1] != initialValue) {
            if (entries[keyIndex] == key) {
                int valueIndex = keyIndex + 1;
                oldValue = entries[keyIndex + 1];
                entries[keyIndex + 1] = initialValue;
                --this.size;
                this.compactChain(keyIndex);
                break;
            }
            keyIndex = Long2LongCounterMap.next(keyIndex, mask);
        }
        return oldValue;
    }

    private void compactChain(int deleteKeyIndex) {
        long[] entries = this.entries;
        long initialValue = this.initialValue;
        int mask = entries.length - 1;
        int index = deleteKeyIndex;
        while (entries[(index = Long2LongCounterMap.next(index, mask)) + 1] != initialValue) {
            int hash = Hashing.evenHash(entries[index], mask);
            if ((index >= hash || hash > deleteKeyIndex && deleteKeyIndex > index) && (hash > deleteKeyIndex || deleteKeyIndex > index)) continue;
            entries[deleteKeyIndex] = entries[index];
            entries[deleteKeyIndex + 1] = entries[index + 1];
            entries[index + 1] = initialValue;
            deleteKeyIndex = index;
        }
    }

    public long minValue() {
        long initialValue = this.initialValue;
        long min = this.size == 0 ? initialValue : Long.MAX_VALUE;
        long[] entries = this.entries;
        int length = entries.length;
        for (int i = 1; i < length; i += 2) {
            long value = entries[i];
            if (value == initialValue) continue;
            min = Math.min(min, value);
        }
        return min;
    }

    public long maxValue() {
        long initialValue = this.initialValue;
        long max = this.size == 0 ? initialValue : Long.MIN_VALUE;
        long[] entries = this.entries;
        int length = entries.length;
        for (int i = 1; i < length; i += 2) {
            long value = entries[i];
            if (value == initialValue) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        long[] entries = this.entries;
        long initialValue = this.initialValue;
        int length = entries.length;
        for (int i = 0; i < length; i += 2) {
            if (entries[i + 1] == initialValue) continue;
            sb.append(entries[i]);
            sb.append('=');
            sb.append(entries[i + 1]);
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void capacity(int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = new long[entriesLength];
        this.size = 0;
        Arrays.fill(this.entries, this.initialValue);
    }
}

