/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.package;
import com.xebialabs.deployit.engine.spi.event.CiCopiedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.repository.sql.CiHistoryRepository;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactRepository;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.InsertCommand;
import com.xebialabs.deployit.repository.sql.reader.CiReader;
import com.xebialabs.deployit.repository.sql.specific.TypeSpecificInserter;
import com.xebialabs.deployit.repository.validation.CommandValidator;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.deployit.util.Tuple;
import com.xebialabs.license.LicenseCiCounter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0001\u0003\u0001=\u00111bQ8qs\u000e{W.\\1oI*\u00111\u0001B\u0001\tG>lW.\u00198eg*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u0013)\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u00171\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!!D%og\u0016\u0014HoQ8n[\u0006tG\r\u0003\u0005\u0016\u0001\t\u0015\r\u0011\"\u0011\u0017\u00031QGMY2UK6\u0004H.\u0019;f+\u00059\u0002C\u0001\r\"\u001b\u0005I\"B\u0001\u000e\u001c\u0003\u0011\u0019wN]3\u000b\u0005qi\u0012\u0001\u00026eE\u000eT!AH\u0010\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001I\u0001\u0004_J<\u0017B\u0001\u0012\u001a\u00051QEMY2UK6\u0004H.\u0019;f\u0011%!\u0003A!A!\u0002\u00139R%A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0005\u0003+IA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0013CJ$\u0018NZ1diJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002*Y5\t!F\u0003\u0002,\t\u0005I\u0011M\u001d;jM\u0006\u001cGo]\u0005\u0003[)\u0012!#\u0011:uS\u001a\f7\r\u001e*fa>\u001c\u0018\u000e^8ss\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\ndS\"K7\u000f^8ssJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00022e5\tA!\u0003\u00024\t\t\u00192)\u001b%jgR|'/\u001f*fa>\u001c\u0018\u000e^8ss\"AQ\u0007\u0001B\u0001B\u0003%a'A\tqCN\u001cxo\u001c:e\u000b:\u001c'/\u001f9uKJ\u0004\"a\u000e\u001e\u000e\u0003aR!!\u000f\u0005\u0002\tU$\u0018\u000e\\\u0005\u0003wa\u0012\u0011\u0003U1tg^|'\u000fZ#oGJL\b\u000f^3s\u0011!i\u0004A!A!\u0002\u0013q\u0014\u0001\u00057jG\u0016t7/Z\"j\u0007>,h\u000e^3s!\ty$)D\u0001A\u0015\t\t%\"A\u0004mS\u000e,gn]3\n\u0005\r\u0003%\u0001\u0005'jG\u0016t7/Z\"j\u0007>,h\u000e^3s\u0011!)\u0005A!A!\u0002\u00131\u0015\u0001C2j%\u0016\fG-\u001a:\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%#\u0011A\u0002:fC\u0012,'/\u0003\u0002L\u0011\nA1)\u001b*fC\u0012,'\u000f\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0003m\u0019'/Z1uKRK\b/Z*qK\u000eLg-[2J]N,'\u000f^3sgB)qJ\u0015+_m6\t\u0001KC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0006KA\u0005Gk:\u001cG/[8oeA\u0011Q\u000bX\u0007\u0002-*\u0011q\u000bW\u0001\be\u00164G.Z2u\u0015\tI&,A\u0002ba&T!a\u0017\u0005\u0002\rAdWoZ5o\u0013\tifK\u0001\u0003UsB,\u0007CA0t\u001d\t\u0001\u0007O\u0004\u0002b]:\u0011!-\u001c\b\u0003G2t!\u0001Z6\u000f\u0005\u0015TgB\u00014j\u001b\u00059'B\u00015\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005=$\u0011\u0001\u00022bg\u0016L!!\u001d:\u0002\u000fA\f7m[1hK*\u0011q\u000eB\u0005\u0003iV\u0014\u0001bQ5Q\u0017RK\b/\u001a\u0006\u0003cJ\u00042a^>\u007f\u001d\tA(P\u0004\u0002gs&\t\u0011+\u0003\u0002r!&\u0011A0 \u0002\u0005\u0019&\u001cHO\u0003\u0002r!B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002\t\u0005A1\u000f]3dS\u001aL7-\u0003\u0003\u0002\b\u0005\u0005!\u0001\u0006+za\u0016\u001c\u0006/Z2jM&\u001c\u0017J\\:feR,'\u000f\u0003\u0006\u0002\f\u0001\u0011\t\u0011)A\u0005\u0003\u001b\t\u0001cY8n[\u0006tGMV1mS\u0012\fGo\u001c:\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005\u0007\u0003)1\u0018\r\\5eCRLwN\\\u0005\u0005\u0003/\t\tB\u0001\tD_6l\u0017M\u001c3WC2LG-\u0019;pe\"Q\u00111\u0004\u0001\u0003\u0002\u0003\u0006I!!\b\u0002\u000f\r|\u0007/_\"jgB)q/a\b\u0002$%\u0019\u0011\u0011E?\u0003\u0011%#XM]1cY\u0016\u0004raNA\u0013\u0003S\tI#C\u0002\u0002(a\u0012Q\u0001V;qY\u0016\u0004B!a\u000b\u000249!\u0011QFA\u0018!\t1\u0007+C\u0002\u00022A\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u001b\u0003o\u0011aa\u0015;sS:<'bAA\u0019!\"Q\u00111\b\u0001\u0003\u0006\u0004%\u0019!!\u0010\u0002\u0015M\fH\u000eR5bY\u0016\u001cG/\u0006\u0002\u0002@A!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0006\u0003\u000bR!A\u0007\u0005\n\t\u0005%\u00131\t\u0002\u000b'FdG)[1mK\u000e$\bBCA'\u0001\t\u0005\t\u0015!\u0003\u0002@\u0005Y1/\u001d7ES\u0006dWm\u0019;!\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'\na\u0001P5oSRtD\u0003FA+\u00037\ni&a\u0018\u0002b\u0005\r\u0014QMA4\u0003S\nY\u0007\u0006\u0003\u0002X\u0005e\u0003CA\t\u0001\u0011!\tY$a\u0014A\u0004\u0005}\u0002BB\u000b\u0002P\u0001\u0007q\u0003\u0003\u0004(\u0003\u001f\u0002\r\u0001\u000b\u0005\u0007_\u0005=\u0003\u0019\u0001\u0019\t\rU\ny\u00051\u00017\u0011\u0019i\u0014q\na\u0001}!1Q)a\u0014A\u0002\u0019Ca!TA(\u0001\u0004q\u0005\u0002CA\u0006\u0003\u001f\u0002\r!!\u0004\t\u0011\u0005m\u0011q\na\u0001\u0003;Aq!a\u001c\u0001\t\u0003\n\t(A\u0004fq\u0016\u001cW\u000f^3\u0015\t\u0005M\u0014\u0011\u0010\t\u0004\u001f\u0006U\u0014bAA<!\n!QK\\5u\u0011!\tY(!\u001cA\u0002\u0005u\u0014aB2p]R,\u0007\u0010\u001e\t\u0004#\u0005}\u0014bAAA\u0005\t\u00012\t[1oO\u0016\u001cV\r^\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u000b\u0003A\u0011IAD\u0003!1\u0018\r\\5eCR,G\u0003BA:\u0003\u0013C\u0001\"a\u001f\u0002\u0004\u0002\u0007\u0011Q\u0010\u0005\b\u0003\u001b\u0003A\u0011BAH\u0003\u0011\u0019w\u000e]=\u0015\u0011\u0005M\u0014\u0011SAK\u00033C\u0001\"a%\u0002\f\u0002\u0007\u0011\u0011F\u0001\u0007MJ|W.\u00133\t\u0011\u0005]\u00151\u0012a\u0001\u0003S\tA\u0001^8JI\"A\u00111PAF\u0001\u0004\ti\bC\u0004\u0002\u001e\u0002!I!a(\u0002#I,\u0007\u000f\\1dKJ+g-\u001a:f]\u000e,7\u000f\u0006\u0003\u0002t\u0005\u0005\u0006\u0002CAR\u00037\u0003\r!!*\u0002\u0015I,g-\u001a:f]\u000e,7\u000f\u0005\u0005\u0002,\u0005\u001d\u0016\u0011FAV\u0013\u0011\tI+a\u000e\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002.\u0006MVBAAX\u0015\r\t\t\fW\u0001\u0004k\u0012l\u0017\u0002BA[\u0003_\u0013\u0011cQ8oM&<WO]1uS>t\u0017\n^3n\u0011\u001d\tI\f\u0001C\u0005\u0003w\u000bAB^1mS\u0012\fG/Z\"paf$\u0002\"a\u001d\u0002>\u0006}\u0016\u0011\u0019\u0005\t\u0003'\u000b9\f1\u0001\u0002*!A\u0011qSA\\\u0001\u0004\tI\u0003\u0003\u0005\u0002|\u0005]\u0006\u0019AA?\u0011\u001d\t)\r\u0001C\u0005\u0003\u000f\f\u0001B]3oC6,7)\u001b\u000b\t\u0003g\nI-!4\u0002P\"A\u00111ZAb\u0001\u0004\tY+\u0001\u0002dS\"A\u00111SAb\u0001\u0004\tI\u0003\u0003\u0005\u0002\u0018\u0006\r\u0007\u0019AA\u0015\u0011\u001d\t\u0019\u000e\u0001C\u0005\u0003+\f!B^1mS\u0012\fG/Z\"j)!\t\u0019(a6\u0002Z\u0006m\u0007\u0002CAJ\u0003#\u0004\r!!\u000b\t\u0011\u0005]\u0015\u0011\u001ba\u0001\u0003SA\u0001\"a3\u0002R\u0002\u0007\u00111\u0016")
public class CopyCommand
extends InsertCommand {
    private final ArtifactRepository artifactRepository;
    private final CiReader ciReader;
    private final CommandValidator commandValidator;
    private final Iterable<Tuple<String, String>> copyCis;
    private final SqlDialect sqlDialect;

    @Override
    public JdbcTemplate jdbcTemplate() {
        return super.jdbcTemplate();
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.copyCis.foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.copy((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.copyCis.foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateCopy((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    private void copy(String fromId, String toId, ChangeSetContext context) {
        String string = fromId;
        String string2 = toId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot copy ci [%s] to same location", (Object[])new Object[]{toId});
        String path = package$.MODULE$.idToPath(fromId);
        ConfigurationItem ci = this.ciReader.readByPath(path, 0);
        this.validateCi(fromId, toId, ci);
        Buffer tuples = (Buffer)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.jdbcTemplate().query(this.SELECT_CI_TREE_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{path, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))})).map((Function1 & Serializable & scala.Serializable)map -> {
            ConfigurationItem ci = $this.ciReader.readUsingCache(package$.MODULE$.asCiPKType(map.get(CIS$.MODULE$.ID().name())), 1, (Function0<Map<String, Object>>)(Function0 & Serializable & scala.Serializable)() -> map);
            String copiedId = ci.getId();
            this.renameCi(ci, fromId, toId);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)copiedId), (Object)ci);
        }, Buffer$.MODULE$.canBuildFrom());
        this.replaceReferences((scala.collection.immutable.Map<String, ConfigurationItem>)tuples.toMap(Predef$.MODULE$.$conforms()));
        this.insertCis((Iterable<ConfigurationItem>)((Iterable)tuples.map((Function1 & Serializable & scala.Serializable)x$1 -> (ConfigurationItem)x$1._2(), Buffer$.MODULE$.canBuildFrom())), context, (Function2<Integer, ConfigurationItem, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(ciPk, copiedCi) -> {
            CopyCommand.$anonfun$copy$4(this, fromId, toId, ciPk, copiedCi);
            return BoxedUnit.UNIT;
        });
        EventBusHolder.publish((Object)new CiCopiedEvent(ci, toId));
    }

    private void replaceReferences(scala.collection.immutable.Map<String, ConfigurationItem> references) {
        references.values().foreach((Function1 & Serializable & scala.Serializable)newCi -> {
            CopyCommand.$anonfun$replaceReferences$1(references, newCi);
            return BoxedUnit.UNIT;
        });
    }

    private void validateCopy(String fromId, String toId, ChangeSetContext context) {
        String string = fromId;
        String string2 = toId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot copy ci [%s] to same location", (Object[])new Object[]{toId});
        String path = package$.MODULE$.idToPath(fromId);
        ConfigurationItem ci = this.ciReader.readByPath(path, 0);
        this.validateCi(fromId, toId, ci);
        this.insertCisValidation((Iterable<ConfigurationItem>)((Iterable)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.jdbcTemplate().query(this.SELECT_CI_TREE_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{path, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))})).map((Function1 & Serializable & scala.Serializable)map -> {
            ConfigurationItem ci = $this.ciReader.readUsingCache(package$.MODULE$.asCiPKType(map.get(CIS$.MODULE$.ID().name())), 1, (Function0<Map<String, Object>>)(Function0 & Serializable & scala.Serializable)() -> map);
            this.renameCi(ci, fromId, toId);
            return ci;
        }, Buffer$.MODULE$.canBuildFrom())), context);
    }

    private void renameCi(ConfigurationItem ci, String fromId, String toId) {
        String newId = toId + ci.getId().substring(fromId.length());
        ci.setId(newId);
    }

    private void validateCi(String fromId, String toId, ConfigurationItem ci) {
        Type type = ci.getType();
        Type type2 = Type.valueOf(Root.class);
        Checks.checkArgument(((type == null ? type2 != null : !type.equals(type2)) ? 1 : 0) != 0, (String)"Cannot copy root node [%s].", (Object[])new Object[]{toId});
        this.commandValidator.checkCopyAllowed(this.ciReader.readByPath((String)package$.MODULE$.parentPath(fromId).get(), 0).getType(), this.ciReader.readByPath((String)package$.MODULE$.parentPath(toId).get(), 0).getType());
        if (this.exists(toId)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{toId});
        }
    }

    public static final /* synthetic */ void $anonfun$copy$4(CopyCommand $this, String fromId$1, String toId$1, Integer ciPk, ConfigurationItem copiedCi) {
        ConfigurationItem configurationItem = copiedCi;
        if (configurationItem instanceof SourceArtifact) {
            SourceArtifact sourceArtifact = (SourceArtifact)configurationItem;
            $this.artifactRepository.copy(fromId$1 + sourceArtifact.getId().substring(toId$1.length()), ciPk);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void replaceCiReference$1(scala.collection.immutable.Map references$1, ConfigurationItem newCi$1, PropertyDescriptor pd$1) {
        Object object = pd$1.get(newCi$1);
        if (object instanceof ConfigurationItem) {
            ConfigurationItem configurationItem = (ConfigurationItem)object;
            pd$1.set(newCi$1, references$1.getOrElse((Object)configurationItem.getId(), (Function0 & Serializable & scala.Serializable)() -> configurationItem));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void replaceListReferences$1(scala.collection.immutable.Map references$1, ConfigurationItem newCi$1, PropertyDescriptor pd$1) {
        ListIterator itr = ((java.util.List)pd$1.get(newCi$1)).listIterator();
        while (itr.hasNext()) {
            String oldId = ((ConfigurationItem)itr.next()).getId();
            references$1.get((Object)oldId).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                itr.set(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$replaceReferences$5(HashSet toAdd$1, Iterator itr$2, ConfigurationItem ci) {
        toAdd$1.add(ci);
        itr$2.remove();
    }

    private static final void replaceSetReferences$1(scala.collection.immutable.Map references$1, ConfigurationItem newCi$1, PropertyDescriptor pd$1) {
        HashSet toAdd = new HashSet();
        Set set = (Set)pd$1.get(newCi$1);
        Iterator itr = set.iterator();
        while (itr.hasNext()) {
            String oldId = ((ConfigurationItem)itr.next()).getId();
            references$1.get((Object)oldId).foreach((Function1 & Serializable & scala.Serializable)ci -> {
                CopyCommand.$anonfun$replaceReferences$5(toAdd, itr, ci);
                return BoxedUnit.UNIT;
            });
        }
        set.addAll(toAdd);
    }

    public static final /* synthetic */ void $anonfun$replaceReferences$2(scala.collection.immutable.Map references$1, ConfigurationItem newCi$1, PropertyDescriptor pd) {
        PropertyKind propertyKind = pd.getKind();
        if (PropertyKind.CI.equals(propertyKind)) {
            CopyCommand.replaceCiReference$1(references$1, newCi$1, pd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PropertyKind.LIST_OF_CI.equals(propertyKind)) {
            CopyCommand.replaceListReferences$1(references$1, newCi$1, pd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PropertyKind.SET_OF_CI.equals(propertyKind)) {
            CopyCommand.replaceSetReferences$1(references$1, newCi$1, pd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$replaceReferences$1(scala.collection.immutable.Map references$1, ConfigurationItem newCi) {
        ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(newCi.getType().getDescriptor().getPropertyDescriptors()).foreach((Function1 & Serializable & scala.Serializable)pd -> {
            CopyCommand.$anonfun$replaceReferences$2(references$1, newCi, pd);
            return BoxedUnit.UNIT;
        });
    }

    public CopyCommand(JdbcTemplate jdbcTemplate, ArtifactRepository artifactRepository, CiHistoryRepository ciHistoryRepository, PasswordEncrypter passwordEncrypter, LicenseCiCounter licenseCiCounter, CiReader ciReader, Function2<Type, Integer, List<TypeSpecificInserter>> createTypeSpecificInserters, CommandValidator commandValidator, Iterable<Tuple<String, String>> copyCis, SqlDialect sqlDialect) {
        this.artifactRepository = artifactRepository;
        this.ciReader = ciReader;
        this.commandValidator = commandValidator;
        this.copyCis = copyCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactRepository, ciHistoryRepository, passwordEncrypter, licenseCiCounter, createTypeSpecificInserters);
    }
}

