/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.package;
import com.xebialabs.deployit.engine.spi.event.CiRenamedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.UpdatePathCommand;
import com.xebialabs.deployit.util.Tuple;
import java.io.Serializable;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0001=\u0011QBU3oC6,7i\\7nC:$'BA\u0002\u0005\u0003!\u0019w.\\7b]\u0012\u001c(BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\t!B]3q_NLGo\u001c:z\u0015\tI!\"\u0001\u0005eKBdw._5u\u0015\tYA\"A\u0005yK\nL\u0017\r\\1cg*\tQ\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0012+B$\u0017\r^3QCRD7i\\7nC:$\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\t\f\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0016\u0003]\u0001\"\u0001G\u0011\u000e\u0003eQ!AG\u000e\u0002\t\r|'/\u001a\u0006\u00039u\tAA\u001b3cG*\u0011adH\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001%A\u0002pe\u001eL!AI\r\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\t\u0011\u0011\u0002!\u0011!Q\u0001\n]\tQB\u001b3cGR+W\u000e\u001d7bi\u0016\u0004\u0003\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002%\u0005\u0014H/\u001b4bGR\u0014V\r]8tSR|'/\u001f\t\u0003Q-j\u0011!\u000b\u0006\u0003U\u0011\t\u0011\"\u0019:uS\u001a\f7\r^:\n\u00051J#AF!si&4\u0017m\u0019;ECR\f'+\u001a9pg&$xN]=\t\u00119\u0002!\u0011!Q\u0001\n=\n\u0011B]3oC6,7)[:\u0011\u0007ARTH\u0004\u00022o9\u0011!'N\u0007\u0002g)\u0011AGD\u0001\u0007yI|w\u000e\u001e \n\u0003Y\nQa]2bY\u0006L!\u0001O\u001d\u0002\u000fA\f7m[1hK*\ta'\u0003\u0002<y\tA\u0011\n^3sC\ndWM\u0003\u00029sA!a(Q\"D\u001b\u0005y$B\u0001!\t\u0003\u0011)H/\u001b7\n\u0005\t{$!\u0002+va2,\u0007C\u0001#I\u001d\t)e\t\u0005\u00023s%\u0011q)O\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002Hs!AA\n\u0001BC\u0002\u0013\rQ*\u0001\u0006tc2$\u0015.\u00197fGR,\u0012A\u0014\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003\u000bES!A\u0007\u0005\n\u0005M\u0003&AC*rY\u0012K\u0017\r\\3di\"AQ\u000b\u0001B\u0001B\u0003%a*A\u0006tc2$\u0015.\u00197fGR\u0004\u0003\"B,\u0001\t\u0003A\u0016A\u0002\u001fj]&$h\b\u0006\u0003Z9vsFC\u0001.\\!\t\t\u0002\u0001C\u0003M-\u0002\u000fa\nC\u0003\u0016-\u0002\u0007q\u0003C\u0003'-\u0002\u0007q\u0005C\u0003/-\u0002\u0007q\u0006C\u0003a\u0001\u0011\u0005\u0013-A\u0004fq\u0016\u001cW\u000f^3\u0015\u0005\t4\u0007CA2e\u001b\u0005I\u0014BA3:\u0005\u0011)f.\u001b;\t\u000b\u001d|\u0006\u0019\u00015\u0002\u000f\r|g\u000e^3yiB\u0011\u0011#[\u0005\u0003U\n\u0011\u0001c\u00115b]\u001e,7+\u001a;D_:$X\r\u001f;\t\u000b1\u0004A\u0011I7\u0002\u0011Y\fG.\u001b3bi\u0016$\"A\u00198\t\u000b\u001d\\\u0007\u0019\u00015\t\u000bA\u0004A\u0011B9\u0002\rI,g.Y7f)\r\u0011'\u000f\u001e\u0005\u0006g>\u0004\raQ\u0001\u0006_2$\u0017\n\u001a\u0005\u0006k>\u0004\raQ\u0001\b]\u0016<h*Y7f\u0011\u00159\b\u0001\"\u0003y\u000391\u0018\r\\5eCR,'+\u001a8b[\u0016$2AY={\u0011\u0015\u0019h\u000f1\u0001D\u0011\u0015)h\u000f1\u0001D\u0011\u0015a\b\u0001\"\u0003~\u0003M\tX/\u001a:z\u0003:$\u0007K]3WC2LG-\u0019;f)\u0015q\u0018QDA\u0010!\u0015\u0019wpQA\u0002\u0013\r\t\t!\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000f\u0005\u0015\u0011QB\"\u0002\u00125\u0011\u0011q\u0001\u0006\u0004\u0001\u0006%!BAA\u0006\u0003\u0011Q\u0017M^1\n\t\u0005=\u0011q\u0001\u0002\u0004\u001b\u0006\u0004\b\u0003BA\n\u00033i!!!\u0006\u000b\t\u0005]\u0011\u0011B\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u001c\u0005U!AB(cU\u0016\u001cG\u000fC\u0003tw\u0002\u00071\tC\u0003vw\u0002\u00071\t")
public class RenameCommand
extends UpdatePathCommand {
    private final JdbcTemplate jdbcTemplate;
    private final Iterable<Tuple<String, String>> renameCis;
    private final SqlDialect sqlDialect;

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.renameCis.foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.rename((String)t.a, (String)t.b);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.renameCis.foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateRename((String)t.a, (String)t.b);
            return BoxedUnit.UNIT;
        });
    }

    private void rename(String oldId, String newName) {
        String string;
        Map map;
        block3: {
            Tuple2<String, Map<String, Object>> tuple2;
            block2: {
                tuple2 = this.queryAndPreValidate(oldId, newName);
                if (tuple2 == null) break block2;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block2;
                string = oldPath;
                if (map != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        Tuple2 tuple22 = tuple2;
        String oldPath = (String)tuple22._1();
        Map map3 = (Map)tuple22._2();
        this.updateNameAndPath(oldPath, (String)package$.MODULE$.parentPath(oldId).get() + "/" + newName);
        EventBusHolder.publish((Object)new CiRenamedEvent(package$.MODULE$.readBaseCiFromMap(map3), newName));
    }

    private void validateRename(String oldId, String newName) {
        this.queryAndPreValidate(oldId, newName);
        String newPath = (String)package$.MODULE$.parentPath(oldId).get() + "/" + newName;
        if (this.exists(newPath)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{package$.MODULE$.pathToId(newPath)});
        }
    }

    private Tuple2<String, Map<String, Object>> queryAndPreValidate(String oldId, String newName) {
        Type ciType;
        Checks.checkArgument((!new StringOps(Predef$.MODULE$.augmentString(newName)).contains((Object)BoxesRunTime.boxToCharacter((char)'/')) ? 1 : 0) != 0, (String)"New name [%s] should not contain a /", (Object[])new Object[]{newName});
        String oldPath = package$.MODULE$.idToPath(oldId);
        Map map = (Map)this.jdbcTemplate().queryForObject(this.SELECT_CI_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{oldPath});
        Type type = ciType = Type.valueOf((String)((String)map.get(CIS$.MODULE$.ci_type().name())));
        Type type2 = Type.valueOf(Root.class);
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            throw new DeployitException("Cannot rename a core.Root configuration item");
        }
        return new Tuple2((Object)oldPath, (Object)map);
    }

    public RenameCommand(JdbcTemplate jdbcTemplate, ArtifactDataRepository artifactRepository, Iterable<Tuple<String, String>> renameCis, SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.renameCis = renameCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactRepository);
    }
}

