/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.principal;

import java.security.Principal;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPrincipalIterator
implements PrincipalIterator {
    private static Logger log = LoggerFactory.getLogger((Class)AbstractPrincipalIterator.class);
    long size = -1L;
    long position = 0L;
    Principal next;

    AbstractPrincipalIterator() {
    }

    abstract Principal seekNext();

    public Principal nextPrincipal() {
        Principal p = this.next;
        if (p == null) {
            throw new NoSuchElementException();
        }
        this.next = this.seekNext();
        ++this.position;
        return p;
    }

    public void skip(long skipNum) {
        while (skipNum-- > 0L) {
            this.next();
        }
    }

    public long getSize() {
        return this.size;
    }

    public long getPosition() {
        return this.position;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        return this.nextPrincipal();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

