/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployfile.execute;

import com.xebialabs.deployit.core.rest.api.InvalidDeploymentException;
import com.xebialabs.deployit.deployfile.execute.CommandExecutor$;
import com.xebialabs.deployit.deployfile.execute.DeployfileCommand;
import com.xebialabs.deployit.deployfile.execute.DeploymentCommand;
import com.xebialabs.deployit.deployfile.execute.PermissionCommand;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.service.deployment.DeploymentTaskService;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u00015\u0011qbQ8n[\u0006tG-\u0012=fGV$xN\u001d\u0006\u0003\u0007\u0011\tq!\u001a=fGV$XM\u0003\u0002\u0006\r\u0005QA-\u001a9m_f4\u0017\u000e\\3\u000b\u0005\u001dA\u0011\u0001\u00033fa2|\u00170\u001b;\u000b\u0005%Q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0011aA2p[\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\"AQ\u0003\u0001B\u0001B\u0003%a#A\tsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0004\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002\u001c1\t\t\"+\u001a9pg&$xN]=TKJ4\u0018nY3)\u0005Qi\u0002C\u0001\u0010*\u001b\u0005y\"B\u0001\u0011\"\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003E\r\nqAZ1di>\u0014\u0018P\u0003\u0002%K\u0005)!-Z1og*\u0011aeJ\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001&A\u0002pe\u001eL!AK\u0010\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002!A,'/\\5tg&|g.\u00123ji>\u0014\bC\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0007\u0003!\u0019XmY;sSRL\u0018B\u0001\u001a0\u0005A\u0001VM]7jgNLwN\\#eSR|'\u000f\u000b\u0002,;!AQ\u0007\u0001B\u0001B\u0003%a'A\u000beKBdw._7f]R$\u0016m]6TKJ4\u0018nY3\u0011\u0005]bT\"\u0001\u001d\u000b\u0005eR\u0014A\u00033fa2|\u00170\\3oi*\u00111HB\u0001\bg\u0016\u0014h/[2f\u0013\ti\u0004HA\u000bEKBdw._7f]R$\u0016m]6TKJ4\u0018nY3)\u0005Qj\u0002\"\u0002!\u0001\t\u0003\t\u0015A\u0002\u001fj]&$h\b\u0006\u0003C\t\u001aC\u0005CA\"\u0001\u001b\u0005\u0011\u0001\"B\u000b@\u0001\u00041\u0002F\u0001#\u001e\u0011\u0015as\b1\u0001.Q\t1U\u0004C\u00036\u007f\u0001\u0007a\u0007\u000b\u0002I;!)1\u0001\u0001C\u0001\u0017R\u0011A\n\u0019\t\u0004\u001bVCfB\u0001(T\u001d\ty%+D\u0001Q\u0015\t\tF\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0011A\u000bE\u0001\ba\u0006\u001c7.Y4f\u0013\t1vK\u0001\u0003MSN$(B\u0001+\u0011!\tIVL\u0004\u0002[7B\u0011q\nE\u0005\u00039B\ta\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011A\f\u0005\u0005\u0006C*\u0003\rAY\u0001\tG>lW.\u00198egB\u0019Q*V2\u0011\u0005\r#\u0017BA3\u0003\u0005E!U\r\u001d7ps\u001aLG.Z\"p[6\fg\u000e\u001a\u0005\u0006O\u0002!I\u0001[\u0001\u0013gVlW.\u0019:ju\u0016\u001c\u0005.\u00198hKN+G\u000f\u0006\u0002MS\")!N\u001aa\u0001W\u0006I1\r[1oO\u0016\u001cV\r\u001e\t\u0003/1L!!\u001c\r\u0003\u0013\rC\u0017M\\4f'\u0016$\b\"B8\u0001\t\u0013\u0001\u0018!\u00053fa2|\u00170\u00119qY&\u001c\u0017\r^5p]R\u0011\u0001,\u001d\u0005\u0006e:\u0004\ra]\u0001\bG>lW.\u00198e!\t\u0019E/\u0003\u0002v\u0005\t\tB)\u001a9m_flWM\u001c;D_6l\u0017M\u001c3\t\u000b]\u0004A\u0011\u0002=\u0002+\u001d,GOV1mS\u0012\fG/[8o\u001b\u0016\u001c8/Y4fgR\u0011\u0001,\u001f\u0005\u0006sY\u0004\rA\u001f\t\u0004w\u0006\u0015Q\"\u0001?\u000b\u0005ut\u0018a\u00013u_*\u0019q0!\u0001\u0002\u0007\u0005\u0004\u0018NC\u0002\u0002\u0004\u0019\ta!\u001a8hS:,\u0017bAA\u0004y\nQA)\u001a9m_flWM\u001c;\t\r]\u0004A\u0011BA\u0006)\rA\u0016Q\u0002\u0005\t\u0003\u001f\tI\u00011\u0001\u0002\u0012\u0005\u00111-\u001b\t\u0005\u0003'\ty\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\r)H-\u001c\u0006\u0004\u007f\u0006m!bAA\u000f\r\u00051\u0001\u000f\\;hS:LA!!\t\u0002\u0016\t\t2i\u001c8gS\u001e,(/\u0019;j_:LE/Z7\t\u0013\u0005\u0015\u0002A1A\u0005\n\u0005\u001d\u0012A\u00027pO\u001e,'/\u0006\u0002\u0002*A!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020\u001d\nQa\u001d7gi)LA!a\r\u0002.\t1Aj\\4hKJD\u0001\"a\u000e\u0001A\u0003%\u0011\u0011F\u0001\bY><w-\u001a:!Q\r\u0001\u00111\b\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011I\u0013\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002F\u0005}\"!C\"p[B|g.\u001a8u\u000f\u001d\tIE\u0001E\u0001\u0003\u0017\nqbQ8n[\u0006tG-\u0012=fGV$xN\u001d\t\u0004\u0007\u00065cAB\u0001\u0003\u0011\u0003\tyeE\u0002\u0002N9Aq\u0001QA'\t\u0003\t\u0019\u0006\u0006\u0002\u0002L!Y\u0011qKA'\u0011\u000b\u0007I\u0011AA-\u0003e1\u0015)\u0013'F\t~#U\t\u0015'P36+e\nV0N\u000bN\u001b\u0016iR#\u0016\u0005\u0005m\u0003\u0003BA/\u0003Oj!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\u0005Y\u0006twM\u0003\u0002\u0002f\u0005!!.\u0019<b\u0013\rq\u0016q\f")
public class CommandExecutor {
    @Autowired
    private final RepositoryService repositoryService;
    @Autowired
    private final PermissionEditor permissionEditor;
    @Autowired
    private final DeploymentTaskService deploymentTaskService;
    private final Logger logger;

    public static String FAILED_DEPLOYMENT_MESSAGE() {
        return CommandExecutor$.MODULE$.FAILED_DEPLOYMENT_MESSAGE();
    }

    public List<String> execute(List<DeployfileCommand> commands) {
        Tuple2 tuple2 = commands.partition((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CommandExecutor.$anonfun$execute$1(x$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List permissionCommands = (List)tuple2._1();
        List deployfileCommands = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)permissionCommands, (Object)deployfileCommands);
        Tuple2 tuple23 = tuple22;
        List permissionCommands2 = (List)tuple23._1();
        List deployfileCommands2 = (List)tuple23._2();
        Tuple2 tuple24 = deployfileCommands2.partition((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CommandExecutor.$anonfun$execute$2(x$3)));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        List deploymentCommands = (List)tuple24._1();
        List ciCommands = (List)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)deploymentCommands, (Object)ciCommands);
        Tuple2 tuple26 = tuple25;
        List deploymentCommands2 = (List)tuple26._1();
        List ciCommands2 = (List)tuple26._2();
        ChangeSet changeSet = (ChangeSet)ciCommands2.foldLeft((Object)new ChangeSet(), (Function2 & Serializable & scala.Serializable)(cs, command) -> {
            command.addTo((ChangeSet)cs);
            return cs;
        });
        this.repositoryService.execute(changeSet);
        permissionCommands2.foreach((Function1 & Serializable & scala.Serializable)command -> {
            this.permissionEditor.editPermissions(command.ci(), command.permissions());
            return BoxedUnit.UNIT;
        });
        List<String> list = this.summarizeChangeSet(changeSet);
        return ((List)deploymentCommands2.map((Function1 & Serializable & scala.Serializable)command -> this.deployApplication((DeploymentCommand)command), List$.MODULE$.canBuildFrom())).$colon$colon$colon(list);
    }

    private List<String> summarizeChangeSet(ChangeSet changeSet) {
        return (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(changeSet.getCreateCis()).asScala()).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(summary, ci) -> (List)summary.$colon$plus((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created configuration item: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ci.getId()})), List$.MODULE$.canBuildFrom()));
    }

    private String deployApplication(DeploymentCommand command) {
        String string;
        String appId = command.appId();
        String environmentId = command.environmentId();
        String version = command.version();
        boolean isDeployed = this.deploymentTaskService.isDeployed(appId, environmentId);
        String deployedApplicationId = environmentId + "/" + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])appId.split("/"))).last();
        Deployment deployment = isDeployed ? this.deploymentTaskService.prepareUpdate(version, deployedApplicationId) : this.deploymentTaskService.prepareInitial(version, environmentId);
        Deployment deployeds = this.deploymentTaskService.prepareAutoDeployeds(deployment);
        try {
            this.deploymentTaskService.validate(deployeds);
            String taskId = this.deploymentTaskService.createTask(deployeds);
            this.deploymentTaskService.startDeploymentTask(taskId);
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started deployment: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskId}));
        }
        catch (InvalidDeploymentException e) {
            this.logger().error("deployment failed due to : ", new Object[]{e.getMessage()});
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deployment failed due to: ", ". ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getValidationMessages(deployeds), CommandExecutor$.MODULE$.FAILED_DEPLOYMENT_MESSAGE()}));
        }
        catch (Exception e) {
            this.logger().error("deployment failed due to : ", new Object[]{e.getMessage()});
            throw e;
        }
        return string;
    }

    private String getValidationMessages(Deployment deployment) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(deployment.getDeployeds()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CommandExecutor.$anonfun$getValidationMessages$1(x$6)))).map((Function1 & Serializable & scala.Serializable)ci -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " on ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getValidationMessages((ConfigurationItem)ci), ci.getName()})), Buffer$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String getValidationMessages(ConfigurationItem ci) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ci.get$validationMessages()).asScala()).map((Function1 & Serializable & scala.Serializable)message -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " for property '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message.getMessage(), message.getPropertyName()})), Buffer$.MODULE$.canBuildFrom())).mkString(" and ");
    }

    private Logger logger() {
        return this.logger;
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(DeployfileCommand x$1) {
        return x$1 instanceof PermissionCommand;
    }

    public static final /* synthetic */ boolean $anonfun$execute$2(DeployfileCommand x$3) {
        return x$3 instanceof DeploymentCommand;
    }

    public static final /* synthetic */ boolean $anonfun$getValidationMessages$1(ConfigurationItem x$6) {
        return x$6.get$validationMessages().isEmpty();
    }

    public CommandExecutor(@Autowired RepositoryService repositoryService, @Autowired PermissionEditor permissionEditor, @Autowired DeploymentTaskService deploymentTaskService) {
        this.repositoryService = repositoryService;
        this.permissionEditor = permissionEditor;
        this.deploymentTaskService = deploymentTaskService;
        this.logger = LoggerFactory.getLogger(CommandExecutor.class);
    }
}

