/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.CncFileDescriptor;
import java.io.File;
import java.io.PrintStream;
import java.nio.MappedByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.ErrorLogReader;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;

public class CommonContext
implements AutoCloseable {
    public static final String AERON_DIR_PROP_NAME = "aeron.dir";
    public static final String AERON_DIR_PROP_DEFAULT;
    public static final String IPC_CHANNEL = "aeron:ipc";
    public static final String SPY_PREFIX = "aeron-spy:";
    public static final long DEFAULT_DRIVER_TIMEOUT_MS = 10000L;
    public static final String INITIAL_TERM_ID_PARAM_NAME = "init-term-id";
    public static final String TERM_ID_PARAM_NAME = "term-id";
    public static final String TERM_OFFSET_PARAM_NAME = "term-offset";
    public static final String TERM_LENGTH_PARAM_NAME = "term-length";
    public static final String MTU_LENGTH_URI_PARAM_NAME = "mtu";
    public static final String MDC_CONTROL_MODE = "control-mode";
    public static final String MDC_CONTROL_MODE_MANUAL = "manual";
    public static final String RELIABLE_STREAM_PARAM_NAME = "reliable";
    private long driverTimeoutMs = 10000L;
    private String aeronDirectoryName = System.getProperty("aeron.dir", AERON_DIR_PROP_DEFAULT);
    private File aeronDirectory;
    private File cncFile;
    private UnsafeBuffer countersMetaDataBuffer;
    private UnsafeBuffer countersValuesBuffer;

    public static String generateRandomDirName() {
        return AERON_DIR_PROP_DEFAULT + "-" + UUID.randomUUID().toString();
    }

    public CommonContext conclude() {
        this.concludeAeronDirectory();
        this.cncFile = new File(this.aeronDirectory, "cnc.dat");
        return this;
    }

    public CommonContext concludeAeronDirectory() {
        if (null == this.aeronDirectory) {
            this.aeronDirectory = new File(this.aeronDirectoryName);
        }
        return this;
    }

    public String aeronDirectoryName() {
        return this.aeronDirectoryName;
    }

    public File aeronDirectory() {
        return this.aeronDirectory;
    }

    public CommonContext aeronDirectoryName(String dirName) {
        this.aeronDirectoryName = dirName;
        return this;
    }

    public static File newDefaultCncFile() {
        return new File(System.getProperty(AERON_DIR_PROP_NAME, AERON_DIR_PROP_DEFAULT), "cnc.dat");
    }

    public UnsafeBuffer countersMetaDataBuffer() {
        return this.countersMetaDataBuffer;
    }

    public CommonContext countersMetaDataBuffer(UnsafeBuffer countersMetaDataBuffer) {
        this.countersMetaDataBuffer = countersMetaDataBuffer;
        return this;
    }

    public UnsafeBuffer countersValuesBuffer() {
        return this.countersValuesBuffer;
    }

    public CommonContext countersValuesBuffer(UnsafeBuffer countersValuesBuffer) {
        this.countersValuesBuffer = countersValuesBuffer;
        return this;
    }

    public File cncFile() {
        return this.cncFile;
    }

    public CommonContext driverTimeoutMs(long driverTimeoutMs) {
        this.driverTimeoutMs = driverTimeoutMs;
        return this;
    }

    public long driverTimeoutMs() {
        return this.driverTimeoutMs;
    }

    public void deleteAeronDirectory() {
        IoUtil.delete((File)this.aeronDirectory, (boolean)false);
    }

    public MappedByteBuffer mapExistingCncFile(Consumer<String> logProgress) {
        File cncFile = new File(this.aeronDirectory, "cnc.dat");
        if (cncFile.exists()) {
            if (null != logProgress) {
                logProgress.accept("INFO: Aeron CnC file " + cncFile + " exists");
            }
            return IoUtil.mapExistingFile((File)cncFile, (String)"cnc.dat");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDriverActive(File directory, long driverTimeoutMs, Consumer<String> logProgress) {
        File cncFile = new File(directory, "cnc.dat");
        if (cncFile.exists()) {
            logProgress.accept("INFO: Aeron CnC file " + cncFile + " exists");
            MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile((File)cncFile, (String)"CnC file");
            try {
                boolean bl = CommonContext.isDriverActive(driverTimeoutMs, logProgress, cncByteBuffer);
                return bl;
            }
            finally {
                IoUtil.unmap((MappedByteBuffer)cncByteBuffer);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDriverActive(long driverTimeoutMs, Consumer<String> logHandler) {
        MappedByteBuffer cncByteBuffer = this.mapExistingCncFile(logHandler);
        try {
            boolean bl = CommonContext.isDriverActive(driverTimeoutMs, logHandler, cncByteBuffer);
            return bl;
        }
        finally {
            IoUtil.unmap((MappedByteBuffer)cncByteBuffer);
        }
    }

    public static boolean isDriverActive(long driverTimeoutMs, Consumer<String> logProgress, MappedByteBuffer cncByteBuffer) {
        if (null == cncByteBuffer) {
            return false;
        }
        UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset(0));
        if (6 != cncVersion) {
            throw new IllegalStateException("Aeron CnC version does not match: version=" + cncVersion + " required=" + 6);
        }
        ManyToOneRingBuffer toDriverBuffer = new ManyToOneRingBuffer((AtomicBuffer)CncFileDescriptor.createToDriverBuffer(cncByteBuffer, (DirectBuffer)cncMetaDataBuffer));
        long timestamp = toDriverBuffer.consumerHeartbeatTime();
        long now = System.currentTimeMillis();
        long diff = now - timestamp;
        logProgress.accept("INFO: Aeron toDriver consumer heartbeat is " + diff + "ms old");
        return diff <= driverTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveErrorLog(PrintStream out) {
        MappedByteBuffer cncByteBuffer = this.mapExistingCncFile(null);
        try {
            int n = this.saveErrorLog(out, cncByteBuffer);
            return n;
        }
        finally {
            IoUtil.unmap((MappedByteBuffer)cncByteBuffer);
        }
    }

    public int saveErrorLog(PrintStream out, MappedByteBuffer cncByteBuffer) {
        if (null == cncByteBuffer) {
            return 0;
        }
        UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset(0));
        if (6 != cncVersion) {
            throw new IllegalStateException("Aeron CnC version does not match: version=" + cncVersion + " required=" + 6);
        }
        UnsafeBuffer buffer = CncFileDescriptor.createErrorLogBuffer(cncByteBuffer, (DirectBuffer)cncMetaDataBuffer);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
        int distinctErrorCount = ErrorLogReader.read((AtomicBuffer)buffer, (observationCount, firstObservationTimestamp, lastObservationTimestamp, encodedException) -> out.format("***%n%d observations from %s to %s for:%n %s%n", observationCount, dateFormat.format(new Date(firstObservationTimestamp)), dateFormat.format(new Date(lastObservationTimestamp)), encodedException));
        out.format("%n%d distinct errors observed.%n", distinctErrorCount);
        return distinctErrorCount;
    }

    @Override
    public void close() {
    }

    static {
        File devShmDir;
        String baseDirName = null;
        if ("Linux".equalsIgnoreCase(System.getProperty("os.name")) && (devShmDir = new File("/dev/shm")).exists()) {
            baseDirName = "/dev/shm/aeron";
        }
        if (null == baseDirName) {
            baseDirName = IoUtil.tmpDirName() + "aeron";
        }
        AERON_DIR_PROP_DEFAULT = baseDirName + '-' + System.getProperty("user.name", "default");
    }
}

