/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.PathHelper;
import com.xebialabs.deployit.repository.core.Securable;
import com.xebialabs.deployit.security.JcrPermissions;
import com.xebialabs.deployit.security.JcrRoleService;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class JcrPermissionEditor
implements PermissionEditor {
    private static final Type SECURABLE = Type.valueOf(Securable.class);
    private final JcrTemplate jcrTemplate;
    private final JcrRoleService roleService;
    private static final Logger logger = LoggerFactory.getLogger(JcrPermissionEditor.class);

    @Autowired
    public JcrPermissionEditor(JcrTemplate jcrTemplate, JcrRoleService roleService) {
        this.jcrTemplate = jcrTemplate;
        this.roleService = roleService;
    }

    public Map<Role, Set<Permission>> readPermissions(String onConfigurationItem) {
        String absPath = this.getPath(onConfigurationItem);
        logger.debug("Reading permissions from [{}]", (Object)absPath);
        return (Map)this.jcrTemplate.execute(session -> this.internalReadPermissions(session, absPath));
    }

    public void editPermissions(String onConfigurationItem, Map<Role, Set<Permission>> permissions) {
        String absPath = this.getPath(onConfigurationItem);
        logger.debug("Going to write permissions {} to node [{}]", permissions, (Object)absPath);
        ArrayList ps = new ArrayList();
        permissions.values().forEach(ps::addAll);
        Collection notApplicableTo = Permissions.isApplicableTo(ps, (String)onConfigurationItem);
        Checks.checkArgument((boolean)notApplicableTo.isEmpty(), (String)"The permissions %s are not applicable to [%s]", (Object[])new Object[]{notApplicableTo, onConfigurationItem});
        this.jcrTemplate.execute(session -> {
            this.internalWritePermissions(session, absPath, permissions);
            session.save();
            return null;
        });
    }

    private Map<Role, Set<Permission>> internalReadPermissions(Session session, String absPath) throws RepositoryException {
        Node node = this.readNode(session, absPath);
        this.checkType(node);
        HashMap<Role, Set<Permission>> permissions = new HashMap<Role, Set<Permission>>();
        List<Role> roles = this.roleService.getRoles();
        roles.addAll(this.roleService.getRoles(absPath));
        Map<String, Role> lookup = JcrPermissions.buildLookupById(roles);
        Map<String, String> permissionEntries = JcrPermissions.readPermissionMap(node);
        logger.debug("Found permission entries on node: {}", permissionEntries);
        for (Map.Entry<String, String> permissionRoles : permissionEntries.entrySet()) {
            Permission p = Permission.find((String)permissionRoles.getKey());
            JcrPermissions.splitIds(permissionRoles.getValue()).stream().filter(lookup::containsKey).forEach(roleId -> permissions.computeIfAbsent((Role)lookup.get(roleId), r -> new HashSet()).add(p));
        }
        logger.debug("Read from [{}] permissions {}", (Object)absPath, permissions);
        return permissions;
    }

    private void checkType(Node node) throws RepositoryException {
        if (node.hasProperty("$configuration.item.type")) {
            Type type = Type.valueOf((String)node.getProperty("$configuration.item.type").getString());
            Checks.checkArgument((boolean)type.instanceOf(SECURABLE), (String)"The type [%s] does not support security permissions, because it doesn't implement com.xebialabs.deployit.repository.core.Securable", (Object[])new Object[]{type});
        }
    }

    private void internalWritePermissions(Session session, String absPath, Map<Role, Set<Permission>> permissions) throws RepositoryException {
        Node node = this.readNode(session, absPath);
        HashMap<Permission, List> permission2Roles = new HashMap<Permission, List>();
        for (Map.Entry<Role, Set<Permission>> roleListEntry : permissions.entrySet()) {
            for (Permission permission : roleListEntry.getValue()) {
                permission2Roles.computeIfAbsent(permission, p -> new ArrayList()).add(roleListEntry.getKey());
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Permission permission : permission2Roles.keySet()) {
            Collection roles = (Collection)permission2Roles.get(permission);
            String value = JcrPermissions.joinIds(JcrPermissions.rolesToIds(roles).stream());
            logger.debug("Going to write permission-roles: [{} -> {}]", (Object)permission, (Object)value);
            map.put(permission.getPermissionName(), value);
        }
        JcrPermissions.writePermissionMap(node, map);
    }

    private Node readNode(Session session, String absPath) throws RepositoryException {
        Checks.checkArgument((boolean)session.nodeExists(absPath), (String)"Couldn't find a node at [%s]", (Object[])new Object[]{PathHelper.getIdFromAbsolutePath((String)absPath)});
        return session.getNode(absPath);
    }

    private String getPath(String id) {
        String nodeId = Strings.isEmpty((String)id) || "global".equals(id) ? "/$configuration/security" : PathHelper.getAbsolutePathFromId((String)id);
        return nodeId;
    }
}

