/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.CodecException;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.StringDecoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServerSentEventHttpMessageReader
implements HttpMessageReader<Object> {
    private static final IntPredicate NEWLINE_DELIMITER = b -> b == 10 || b == 13;
    private static final DataBufferFactory bufferFactory = new DefaultDataBufferFactory();
    private static final StringDecoder stringDecoder = StringDecoder.textPlainOnly((boolean)false);
    @Nullable
    private final Decoder<?> decoder;

    public ServerSentEventHttpMessageReader() {
        this(null);
    }

    public ServerSentEventHttpMessageReader(@Nullable Decoder<?> decoder) {
        this.decoder = decoder;
    }

    @Nullable
    public Decoder<?> getDecoder() {
        return this.decoder;
    }

    @Override
    public List<MediaType> getReadableMediaTypes() {
        return Collections.singletonList(MediaType.TEXT_EVENT_STREAM);
    }

    @Override
    public boolean canRead(ResolvableType elementType, @Nullable MediaType mediaType) {
        return MediaType.TEXT_EVENT_STREAM.includes(mediaType) || this.isServerSentEvent(elementType);
    }

    private boolean isServerSentEvent(ResolvableType elementType) {
        Class rawClass = elementType.getRawClass();
        return rawClass != null && ServerSentEvent.class.isAssignableFrom(rawClass);
    }

    @Override
    public Flux<Object> read(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        boolean shouldWrap = this.isServerSentEvent(elementType);
        ResolvableType valueType = shouldWrap ? elementType.getGeneric(new int[]{0}) : elementType;
        return Flux.from(message.getBody()).concatMap(ServerSentEventHttpMessageReader::splitOnNewline).map(buffer -> {
            CharBuffer charBuffer = StandardCharsets.UTF_8.decode(buffer.asByteBuffer());
            DataBufferUtils.release((DataBuffer)buffer);
            return charBuffer.toString();
        }).bufferUntil(line -> line.equals("\n")).concatMap(rawLines -> {
            String[] lines = rawLines.stream().collect(Collectors.joining()).split("\\r?\\n");
            ServerSentEvent<Object> event = this.buildEvent(lines, valueType, hints);
            return shouldWrap ? Mono.just(event) : Mono.justOrEmpty((Object)event.data());
        }).cast(Object.class);
    }

    private static Flux<DataBuffer> splitOnNewline(DataBuffer dataBuffer) {
        int endIdx;
        ArrayList<DataBuffer> results = new ArrayList<DataBuffer>();
        int startIdx = 0;
        int limit = dataBuffer.readableByteCount();
        do {
            int length = (endIdx = dataBuffer.indexOf(NEWLINE_DELIMITER, startIdx)) != -1 ? endIdx - startIdx + 1 : limit - startIdx;
            DataBuffer token = dataBuffer.slice(startIdx, length);
            results.add(DataBufferUtils.retain((DataBuffer)token));
        } while ((startIdx = endIdx + 1) < limit && endIdx != -1);
        DataBufferUtils.release((DataBuffer)dataBuffer);
        return Flux.fromIterable(results);
    }

    private ServerSentEvent<Object> buildEvent(String[] lines, ResolvableType valueType, Map<String, Object> hints) {
        ServerSentEvent.Builder<Object> sseBuilder = ServerSentEvent.builder();
        StringBuilder mutableData = new StringBuilder();
        StringBuilder mutableComment = new StringBuilder();
        for (String line : lines) {
            if (line.startsWith("id:")) {
                sseBuilder.id(line.substring(3));
                continue;
            }
            if (line.startsWith("event:")) {
                sseBuilder.event(line.substring(6));
                continue;
            }
            if (line.startsWith("data:")) {
                mutableData.append(line.substring(5)).append("\n");
                continue;
            }
            if (line.startsWith("retry:")) {
                sseBuilder.retry(Duration.ofMillis(Long.valueOf(line.substring(6))));
                continue;
            }
            if (!line.startsWith(":")) continue;
            mutableComment.append(line.substring(1)).append("\n");
        }
        if (mutableData.length() > 0) {
            String data = mutableData.toString();
            sseBuilder.data(this.decodeData(data, valueType, hints));
        }
        if (mutableComment.length() > 0) {
            String comment = mutableComment.toString();
            sseBuilder.comment(comment.substring(0, comment.length() - 1));
        }
        return sseBuilder.build();
    }

    @Nullable
    private Object decodeData(String data, ResolvableType dataType, Map<String, Object> hints) {
        if (String.class == dataType.resolve()) {
            return data.substring(0, data.length() - 1);
        }
        if (this.decoder == null) {
            return Flux.error((Throwable)new CodecException("No SSE decoder configured and the data is not String."));
        }
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        Mono input = Mono.just((Object)bufferFactory.wrap(bytes));
        return this.decoder.decodeToMono((Publisher)input, dataType, (MimeType)MediaType.TEXT_EVENT_STREAM, hints).block(Duration.ZERO);
    }

    @Override
    public Mono<Object> readMono(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        if (String.class.equals((Object)elementType.getRawClass())) {
            Flux<DataBuffer> body = message.getBody();
            return stringDecoder.decodeToMono(body, elementType, null, null).cast(Object.class);
        }
        return Mono.error((Throwable)new UnsupportedOperationException("ServerSentEventHttpMessageReader only supports reading stream of events as a Flux"));
    }
}

