/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorNotFound;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.ActorSystem;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.ScalaActorSelection;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.pattern.AskableActorRef$;
import akka.pattern.AskableActorSelection$;
import akka.util.Timeout;
import com.github.nscala_time.time.Imports$;
import com.github.nscala_time.time.RichDateTime$;
import com.github.nscala_time.time.RichReadableInstant$;
import com.github.nscala_time.time.RichReadableInterval$;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.engine.tasker.ActiveTasksQueue$;
import com.xebialabs.deployit.engine.tasker.Archive;
import com.xebialabs.deployit.engine.tasker.ArchiveActor$;
import com.xebialabs.deployit.engine.tasker.ArchivedListeningActor;
import com.xebialabs.deployit.engine.tasker.ArchivedListeningActor$;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import com.xebialabs.deployit.engine.tasker.BlockPath$Root$;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.engine.tasker.RecoverySupervisorActor;
import com.xebialabs.deployit.engine.tasker.RecoverySupervisorActor$;
import com.xebialabs.deployit.engine.tasker.RecoverySupervisorActor$ReadAll$;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine$;
import com.xebialabs.deployit.engine.tasker.TaskManagingActor;
import com.xebialabs.deployit.engine.tasker.TaskManagingActor$;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskRecoveryListener$;
import com.xebialabs.deployit.engine.tasker.TaskRegistryExtension;
import com.xebialabs.deployit.engine.tasker.TaskRegistryExtension$;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskTransitionActor$;
import com.xebialabs.deployit.engine.tasker.TaskerException;
import com.xebialabs.deployit.engine.tasker.messages.Abort;
import com.xebialabs.deployit.engine.tasker.messages.AddPauseStep;
import com.xebialabs.deployit.engine.tasker.messages.Enqueue;
import com.xebialabs.deployit.engine.tasker.messages.ModifySteps;
import com.xebialabs.deployit.engine.tasker.messages.PathsNotFound;
import com.xebialabs.deployit.engine.tasker.messages.SkipSteps;
import com.xebialabs.deployit.engine.tasker.messages.StepModificationError;
import com.xebialabs.deployit.engine.tasker.messages.Stop;
import com.xebialabs.deployit.engine.tasker.messages.Stop$;
import com.xebialabs.deployit.engine.tasker.messages.TaskDone;
import com.xebialabs.deployit.engine.tasker.messages.UnSkipSteps;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.xlplatform.settings.CommonSettings;
import com.xebialabs.xlplatform.settings.CommonSettings$;
import com.xebialabs.xlplatform.settings.TaskerSettings;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\rf\u0001B\u0001\u0003\u00015\u00111\u0003V1tW\u0016CXmY;uS>tWI\\4j]\u0016T!a\u0001\u0003\u0002\rQ\f7o[3s\u0015\t)a!\u0001\u0004f]\u001eLg.\u001a\u0006\u0003\u000f!\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u0013)\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u0019B\u0001\u0001\b\u00175A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001815\t!!\u0003\u0002\u001a\u0005\t9\u0011*\u00128hS:,\u0007CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005y\u0012\u0001C4sSjTH.\u001a3\n\u0005\u0005b\"a\u0002'pO\u001eLgn\u001a\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u00059\u0011M]2iSZ,\u0007CA\f&\u0013\t1#AA\u0004Be\u000eD\u0017N^3\t\u0011!\u0002!\u0011!Q\u0001\n%\n\u0011C]3q_NLGo\u001c:z\r\u0006\u001cGo\u001c:z!\tQs&D\u0001,\u0015\taS&\u0001\u0005tKJ4\u0018nY3t\u0015\tqC!A\u0002ta&L!\u0001M\u0016\u0003#I+\u0007o\\:ji>\u0014\u0018PR1di>\u0014\u0018\u0010\u0003\u00053\u0001\t\u0015\r\u0011b\u00014\u0003\u0019\u0019\u0018p\u001d;f[V\tA\u0007\u0005\u00026u5\taG\u0003\u00028q\u0005)\u0011m\u0019;pe*\t\u0011(\u0001\u0003bW.\f\u0017BA\u001e7\u0005-\t5\r^8s'f\u001cH/Z7\t\u0011u\u0002!\u0011!Q\u0001\nQ\nqa]=ti\u0016l\u0007\u0005C\u0003@\u0001\u0011\u0005\u0001)\u0001\u0004=S:LGO\u0010\u000b\u0005\u0003\n\u001bE\t\u0005\u0002\u0018\u0001!)1E\u0010a\u0001I!)\u0001F\u0010a\u0001S!)!G\u0010a\u0002i!9a\t\u0001b\u0001\n\u00039\u0015A\u0004;bg.,'oU3ui&twm]\u000b\u0002\u0011B\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\tg\u0016$H/\u001b8hg*\u0011Q\nC\u0001\u000bq2\u0004H.\u0019;g_Jl\u0017BA(K\u00059!\u0016m]6feN+G\u000f^5oONDa!\u0015\u0001!\u0002\u0013A\u0015a\u0004;bg.,'oU3ui&twm\u001d\u0011\t\u000fM\u0003!\u0019!C\u0001)\u0006A\u0011M]2iSZ,'/F\u0001V!\t)d+\u0003\u0002Xm\tA\u0011i\u0019;peJ+g\r\u0003\u0004Z\u0001\u0001\u0006I!V\u0001\nCJ\u001c\u0007.\u001b<fe\u0002Bqa\u0017\u0001C\u0002\u0013\u0005A+\u0001\tuCN\\GK]1og&$\u0018n\u001c8fe\"1Q\f\u0001Q\u0001\nU\u000b\u0011\u0003^1tWR\u0013\u0018M\\:ji&|g.\u001a:!\u0011\u001dy\u0006A1A\u0005\u0002Q\u000b!C]3d_Z,'/_*va\u0016\u0014h/[:pe\"1\u0011\r\u0001Q\u0001\nU\u000b1C]3d_Z,'/_*va\u0016\u0014h/[:pe\u0002Bqa\u0019\u0001C\u0002\u0013\u0005A+\u0001\u000buCN\\'+Z2pm\u0016\u0014\u0018\u0010T5ti\u0016tWM\u001d\u0005\u0007K\u0002\u0001\u000b\u0011B+\u0002+Q\f7o\u001b*fG>4XM]=MSN$XM\\3sA!)q\r\u0001C\u0001Q\u0006i1\u000f[;uI><h\u000eV1tWN$\u0012!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0002Y\u0006)1oY1mC&\u0011an\u001b\u0002\u0005+:LG\u000f\u000b\u0002gaB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\u000bC:tw\u000e^1uS>t'\"A;\u0002\u000b)\fg/\u0019=\n\u0005]\u0014(A\u0003)sK\u0012+7\u000f\u001e:ps\")\u0011\u0010\u0001C\u0001Q\u0006!\u0011N\\5uQ\tA8\u0010\u0005\u0002ry&\u0011QP\u001d\u0002\u000e!>\u001cHoQ8ogR\u0014Xo\u0019;\t\u000b}\u0004A\u0011\u00015\u0002\u0019I,7m\u001c<feR\u000b7o[:\t\r\u0005\r\u0001\u0001\"\u0003i\u0003=\u0019G.Z1o+B$V\u000e\u001d$jY\u0016\u001c\bbBA\u0004\u0001\u0011\u0005\u0011\u0011B\u0001\n_:\u0014VmY8wKJ$2![A\u0006\u0011!\ti!!\u0002A\u0002\u0005=\u0011\u0001\u0002;bg.\u00042aFA\t\u0013\r\t\u0019B\u0001\u0002\u0005)\u0006\u001c8\u000e\u0003\u0004$\u0001\u0011\u0005\u0011q\u0003\u000b\u0004S\u0006e\u0001\u0002CA\u000e\u0003+\u0001\r!!\b\u0002\rQ\f7o[5e!\u0011\ty\"!\f\u000f\t\u0005\u0005\u0012\u0011\u0006\t\u0004\u0003GYWBAA\u0013\u0015\r\t9\u0003D\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-2.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\t\tD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003WY\u0007bBA\u001b\u0001\u0011\u0005\u0011qG\u0001\fCJ\u001c\u0007.\u001b<f/&$\b\u000eF\u0003j\u0003s\tI\u0005\u0003\u0005\u0002\u001c\u0005M\u0002\u0019AA\u001e!\u0011\ti$a\u0011\u000f\u0007]\ty$C\u0002\u0002B\t\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002F\u0005\u001d#A\u0002+bg.LEMC\u0002\u0002B\tA\u0001\"a\u0013\u00024\u0001\u0007\u0011QJ\u0001\u0004[N<\u0007#\u00036\u0002P\u0005mR+VA*\u0013\r\t\tf\u001b\u0002\n\rVt7\r^5p]N\u00022A[A+\u0013\r\t9f\u001b\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^\u0005I1o[5q'R,\u0007o\u001d\u000b\u0006S\u0006}\u0013\u0011\r\u0005\t\u00037\tI\u00061\u0001\u0002\u001e!A\u00111MA-\u0001\u0004\t)'A\u0004ti\u0016\u0004hJ]:\u0011\r\u0005\u001d\u0014QNA9\u001b\t\tIGC\u0002\u0002lI\tA!\u001e;jY&!\u0011qNA5\u0005\u0011a\u0015n\u001d;\u0011\u0007=\t\u0019(C\u0002\u0002vA\u0011q!\u00138uK\u001e,'\u000fC\u0004\u0002z\u0001!\t%a\u001f\u0002\u0017Ut7o[5q'R,\u0007o\u001d\u000b\u0006S\u0006u\u0014q\u0010\u0005\t\u00037\t9\b1\u0001\u0002\u001e!A\u00111MA<\u0001\u0004\t)\u0007C\u0004\u0002\u0004\u0002!\t%!\"\u0002\u0019\u0005$G\rU1vg\u0016\u001cF/\u001a9\u0015\u000b%\f9)!#\t\u0011\u0005m\u0011\u0011\u0011a\u0001\u0003;A\u0001\"a#\u0002\u0002\u0002\u0007\u0011\u0011O\u0001\ta>\u001c\u0018\u000e^5p]\"9\u00111\u0011\u0001\u0005\u0002\u0005=E#B5\u0002\u0012\u0006M\u0005\u0002CA\u000e\u0003\u001b\u0003\r!!\b\t\u0011\u0005-\u0015Q\u0012a\u0001\u0003+\u00032aFAL\u0013\r\tIJ\u0001\u0002\n\u00052|7m\u001b)bi\"Dq!!(\u0001\t\u0003\ty*A\bv]N\\\u0017\u000e]*uKB\u0004\u0016\r\u001e5t)\u0015I\u0017\u0011UAR\u0011!\tY\"a'A\u0002\u0005u\u0001\u0002CA2\u00037\u0003\r!!*\u0011\r\u0005\u001d\u0014QNAK\u0011!\ti\n\u0001Q\u0005\n\u0005%F#B5\u0002,\u00065\u0006\u0002CA\u000e\u0003O\u0003\r!!\b\t\u0011\u0005\r\u0014q\u0015a\u0001\u0003_\u0003b!!-\u0002:\u0006Ue\u0002BAZ\u0003osA!a\t\u00026&\tA.C\u0002\u0002B-LA!a/\u0002>\n\u00191+Z9\u000b\u0007\u0005\u00053\u000eC\u0004\u0002B\u0002!\t!a1\u0002\u001bM\\\u0017\u000e]*uKB\u0004\u0016\r\u001e5t)\u0015I\u0017QYAd\u0011!\tY\"a0A\u0002\u0005u\u0001\u0002CA2\u0003\u007f\u0003\r!!*\t\u0011\u0005\u0005\u0007\u0001)C\u0005\u0003\u0017$R![Ag\u0003\u001fD\u0001\"a\u0007\u0002J\u0002\u0007\u0011Q\u0004\u0005\t\u0003G\nI\r1\u0001\u00020\"9\u00111\u001b\u0001\u0005\n\u0005U\u0017!D5oiJ\u0012En\\2l!\u0006$\b\u000e\u0006\u0003\u0002\u0016\u0006]\u0007\u0002CAm\u0003#\u0004\r!!\u001d\u0002\u0017=dG\rU8tSRLwN\u001c\u0005\b\u0003;\u0004A\u0011BAp\u0003)i\u0017M\\1hKN#X\r\u001d\u000b\u0006S\u0006\u0005\u00181\u001d\u0005\t\u00037\tY\u000e1\u0001\u0002\u001e!A\u0011Q]An\u0001\u0004\t9/A\u0004nKN\u001c\u0018mZ3\u0011\t\u0005%\u0018q^\u0007\u0003\u0003WT1!!<\u0003\u0003!iWm]:bO\u0016\u001c\u0018\u0002BAy\u0003W\u00141\"T8eS\u001aL8\u000b^3qg\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]\u0018AB2b]\u000e,G\u000eF\u0002j\u0003sD\u0001\"a\u0007\u0002t\u0002\u0007\u0011Q\u0004\u0005\b\u0003{\u0004A\u0011AA\u0000\u0003\u0011\u0019Ho\u001c9\u0015\u0007%\u0014\t\u0001\u0003\u0005\u0002\u001c\u0005m\b\u0019AA\u000f\u0011\u001d\u0011)\u0001\u0001C\u0001\u0005\u000f\tQ!\u00192peR$2!\u001bB\u0005\u0011!\tYBa\u0001A\u0002\u0005u\u0001b\u0002B\u0007\u0001\u0011\u0005!qB\u0001\bKb,7-\u001e;f)\rI'\u0011\u0003\u0005\t\u00037\u0011Y\u00011\u0001\u0002\u001e!9!Q\u0003\u0001\u0005\u0002\t]\u0011\u0001C:dQ\u0016$W\u000f\\3\u0015\u000b%\u0014IBa\u0007\t\u0011\u0005m!1\u0003a\u0001\u0003;A\u0001B!\b\u0003\u0014\u0001\u0007!qD\u0001\u000bg\u000eDW\rZ;mK\u0006#\b\u0003\u0002B\u0011\u0005\u0007rAAa\t\u0003>9!!Q\u0005B\u001c\u001d\u0011\u00119C!\r\u000f\t\t%\"Q\u0006\b\u0005\u0003G\u0011Y#C\u0001\f\u0013\r\u0011yCC\u0001\u0007O&$\b.\u001e2\n\t\tM\"QG\u0001\f]N\u001c\u0017\r\\1`i&lWMC\u0002\u00030)IAA!\u000f\u0003<\u0005!A/[7f\u0015\u0011\u0011\u0019D!\u000e\n\t\t}\"\u0011I\u0001\b\u00136\u0004xN\u001d;t\u0015\u0011\u0011IDa\u000f\n\t\t\u0015#q\t\u0002\t\t\u0006$X\rV5nK&!!\u0011\nB!\u0005-!\u0016\u0010]3J[B|'\u000f^:\t\u000f\t5\u0003\u0001\"\u0001\u0003P\u0005A!/Z4jgR,'\u000f\u0006\u0003\u0002\u001e\tE\u0003\u0002\u0003B*\u0005\u0017\u0002\rA!\u0016\u0002\tM\u0004Xm\u0019\t\u0004/\t]\u0013b\u0001B-\u0005\t\tB+Y:l'B,7-\u001b4jG\u0006$\u0018n\u001c8\t\u000f\tu\u0003\u0001\"\u0003\u0003`\u0005\u00012M]3bi\u0016\u0014V\r]8tSR|'/\u001f\u000b\u0005\u0005C\u0012\u0019\b\u0005\u0003\u0003d\t=TB\u0001B3\u0015\ra#q\r\u0006\u0005\u0005S\u0012Y'A\u0002ba&T1A!\u001c\u0007\u0003\u0019\u0001H.^4j]&!!\u0011\u000fB3\u0005)\u0011V\r]8tSR|'/\u001f\u0005\t\u0003\u001b\u0011Y\u00061\u0001\u0002\u0010!9!q\u000f\u0001\u0005\u0002\te\u0014\u0001\u0003:fiJLWM^3\u0015\t\u0005=!1\u0010\u0005\t\u00037\u0011)\b1\u0001\u0002\u001e!9!q\u0010\u0001\u0005\u0002\t\u0005\u0015!F4fi\u0006cG.\u00138d_6\u0004H.\u001a;f)\u0006\u001c8n\u001d\u000b\u0003\u0005\u0007\u0003b!a\u001a\u0002n\u0005=\u0001\u0002\u0003BD\u0001\u0011E!A!#\u0002\u001f1|wn[;q)\u0006\u001c8.Q2u_J$BAa#\u0003\u0012B\u0019QG!$\n\u0007\t=eG\u0001\bBGR|'oU3mK\u000e$\u0018n\u001c8\t\u0011\tM%Q\u0011a\u0001\u0003;\t\u0011a\u001d\u0005\t\u0005/\u0003A\u0011\u0003\u0002\u0003\u001a\u0006y1M]3bi\u0016$\u0016m]6BGR|'\u000fF\u0002V\u00057C\u0001\"!\u0004\u0003\u0016\u0002\u0007\u0011q\u0002\u0005\b\u0005?\u0003A\u0011\u0001BQ\u0003%9W\r^*zgR,W\u000eF\u00015\u0001")
public class TaskExecutionEngine
implements IEngine,
Logging {
    private final RepositoryFactory repositoryFactory;
    private final ActorSystem system;
    private final TaskerSettings taskerSettings;
    private final ActorRef archiver;
    private final ActorRef taskTransitioner;
    private final ActorRef recoverySupervisor;
    private final ActorRef taskRecoveryListener;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TaskExecutionEngine taskExecutionEngine = this;
        synchronized (taskExecutionEngine) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ActorSystem system() {
        return this.system;
    }

    public TaskerSettings taskerSettings() {
        return this.taskerSettings;
    }

    public ActorRef archiver() {
        return this.archiver;
    }

    public ActorRef taskTransitioner() {
        return this.taskTransitioner;
    }

    public ActorRef recoverySupervisor() {
        return this.recoverySupervisor;
    }

    public ActorRef taskRecoveryListener() {
        return this.taskRecoveryListener;
    }

    @Override
    @PreDestroy
    public void shutdownTasks() {
        ((IterableLike)((TaskRegistryExtension)TaskRegistryExtension$.MODULE$.apply(this.system())).getTasks().filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)TaskExecutionEngine.$anonfun$shutdownTasks$1(t)))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            TaskExecutionEngine.$anonfun$shutdownTasks$2(this, t);
            return BoxedUnit.UNIT;
        });
        Await$.MODULE$.ready((Awaitable)this.system().terminate(), (Duration)this.taskerSettings().shutdownTimeout());
    }

    @PostConstruct
    public void init() {
        ActiveTasksQueue$.MODULE$.apply(this.system());
        this.recoverTasks();
    }

    @Override
    public void recoverTasks() {
        this.cleanUpTmpFiles();
        try {
            Timeout timeout = this.taskerSettings().askTimeout();
            ActorRef qual$2 = akka.pattern.package$.MODULE$.ask(this.recoverySupervisor());
            RecoverySupervisorActor$ReadAll$ x$3 = RecoverySupervisorActor$ReadAll$.MODULE$;
            Timeout x$4 = timeout;
            ActorRef x$5 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$2, (Object)x$3);
            Task[] tasks = ((RecoverySupervisorActor.Tasks)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$2, (Object)x$3, x$4, x$5), (Duration)timeout.duration())).tasks();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tasks)).foreach((Function1 & Serializable & scala.Serializable)task -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.onRecover((Task)task)).recover((PartialFunction)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TaskExecutionEngine $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof Exception) {
                        Exception exception = (Exception)A1;
                        this.$outer.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error while recovering tasks.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    boolean bl = throwable instanceof Exception;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(java.lang.Exception )}, serializedLambda);
                }
            }));
        }
        catch (Exception e) {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error while recovering.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    private void cleanUpTmpFiles() {
        File[] tmpFiles = this.taskerSettings().recoveryDir().listFiles(new FileFilter(null){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".task.tmp");
            }
        });
        ((List)Option$.MODULE$.apply((Object)tmpFiles).toList().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            TaskExecutionEngine.$anonfun$cleanUpTmpFiles$2(this, file);
            return BoxedUnit.UNIT;
        });
    }

    public void onRecover(Task task) {
        block0: {
            task.context().repository_$eq(this.createRepository(task));
            Timeout timeout = this.taskerSettings().askTimeout();
            ActorRef qual$3 = akka.pattern.package$.MODULE$.ask(this.createTaskActor(task));
            TaskManagingActor.messages.Recovered x$6 = new TaskManagingActor.messages.Recovered(task);
            Timeout x$7 = timeout;
            ActorRef x$8 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$3, (Object)x$6);
            Await$.MODULE$.ready((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$3, (Object)x$6, x$7, x$8), (Duration)timeout.duration());
            if (!task.cancelling()) break block0;
            this.cancel(task.getId());
        }
    }

    @Override
    public void archive(String taskid) {
        this.archiveWith(taskid, (Function3<String, ActorRef, ActorRef, Object>)(Function3 & Serializable & scala.Serializable)(taskId, archiveActor, notificationActor) -> new TaskManagingActor.messages.ArchiveTask((String)taskId, (ActorRef)archiveActor, (ActorRef)notificationActor));
    }

    public void archiveWith(String taskid, Function3<String, ActorRef, ActorRef, Object> msg) {
        Promise p = Promise$.MODULE$.apply();
        ActorRef listener = this.system().actorOf(ArchivedListeningActor$.MODULE$.props(taskid, (Promise<String>)p));
        Object message = msg.apply((Object)taskid, (Object)this.archiver(), (Object)listener);
        ActorSelection taskActor = this.lookupTaskActor(taskid);
        ScalaActorRef qual$4 = package$.MODULE$.actorRef2Scala(listener);
        ArchivedListeningActor.Forward x$9 = new ArchivedListeningActor.Forward(taskActor, message);
        ActorRef x$10 = qual$4.$bang$default$2((Object)x$9);
        qual$4.$bang((Object)x$9, x$10);
        Await$.MODULE$.ready((Awaitable)p.future(), (Duration)Duration$.MODULE$.Inf());
        this.system().stop(listener);
        Try try_ = (Try)p.future().value().get();
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            throw ex;
        }
        if (!(try_ instanceof Success)) {
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        String taskId = (String)success.value();
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task ", " successfully archived."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskId})));
        ((TaskRegistryExtension)TaskRegistryExtension$.MODULE$.apply(this.system())).deleteTask(taskid);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public void skipSteps(String taskid, java.util.List<Integer> stepNrs) {
        this.skipStepPaths(taskid, (Seq<BlockPath>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()).map((Function1 & Serializable & scala.Serializable)oldPosition -> this.int2BlockPath((Integer)oldPosition), Buffer$.MODULE$.canBuildFrom())));
    }

    @Override
    public void unskipSteps(String taskid, java.util.List<Integer> stepNrs) {
        this.unskipStepPaths(taskid, (Seq<BlockPath>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()).map((Function1 & Serializable & scala.Serializable)oldPosition -> this.int2BlockPath((Integer)oldPosition), Buffer$.MODULE$.canBuildFrom())));
    }

    @Override
    public void addPauseStep(String taskid, Integer position) {
        this.addPauseStep(taskid, this.int2BlockPath(position));
    }

    @Override
    public void addPauseStep(String taskid, BlockPath position) {
        this.manageStep(taskid, new AddPauseStep(taskid, position));
    }

    @Override
    public void unskipStepPaths(String taskid, java.util.List<BlockPath> stepNrs) {
        this.unskipStepPaths(taskid, (Seq<BlockPath>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()));
    }

    private void unskipStepPaths(String taskid, Seq<BlockPath> stepNrs) {
        this.manageStep(taskid, new UnSkipSteps(taskid, stepNrs));
    }

    @Override
    public void skipStepPaths(String taskid, java.util.List<BlockPath> stepNrs) {
        this.skipStepPaths(taskid, (Seq<BlockPath>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()));
    }

    private void skipStepPaths(String taskid, Seq<BlockPath> stepNrs) {
        this.manageStep(taskid, new SkipSteps(taskid, stepNrs));
    }

    private BlockPath int2BlockPath(Integer oldPosition) {
        return BlockPath$Root$.MODULE$.$div(1).$div(1).$div(Predef$.MODULE$.Integer2int(oldPosition));
    }

    private void manageStep(String taskid, ModifySteps message) {
        ActorRef x$13;
        Timeout x$12;
        ModifySteps x$11;
        Timeout timeout = ((CommonSettings)CommonSettings$.MODULE$.apply(this.system())).satellite().remoteAskTimeout();
        ActorSelection qual$5 = akka.pattern.package$.MODULE$.ask(this.lookupTaskActor(taskid));
        Object object = Await$.MODULE$.result((Awaitable)AskableActorSelection$.MODULE$.$qmark$extension1(qual$5, (Object)(x$11 = message), x$12 = timeout, x$13 = AskableActorSelection$.MODULE$.$qmark$default$3$extension(qual$5, (Object)x$11)), (Duration)timeout.duration());
        if (object instanceof StepModificationError) {
            StepModificationError stepModificationError = (StepModificationError)object;
            throw new TaskerException(stepModificationError.msg());
        }
        if (object instanceof PathsNotFound) {
            PathsNotFound pathsNotFound = (PathsNotFound)object;
            Seq<BlockPath> paths = pathsNotFound.paths();
            throw new TaskerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find a path to add a pause step at the position ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paths})));
        }
        if (object instanceof ActorNotFound) {
            throw new RuntimeException("Probably connection to satellite is lost");
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public void cancel(String taskid) {
        this.archiveWith(taskid, (Function3<String, ActorRef, ActorRef, Object>)(Function3 & Serializable & scala.Serializable)(taskId, archiveActor, notificationActor) -> new TaskManagingActor.messages.Cancel((String)taskId, (ActorRef)archiveActor, (ActorRef)notificationActor));
    }

    @Override
    public void stop(String taskid) {
        ScalaActorSelection qual$6 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        Stop x$14 = new Stop(taskid);
        ActorRef x$15 = qual$6.$bang$default$2((Object)x$14);
        qual$6.$bang((Object)x$14, x$15);
    }

    @Override
    public void abort(String taskid) {
        ScalaActorSelection qual$7 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        Abort x$16 = new Abort(taskid);
        ActorRef x$17 = qual$7.$bang$default$2((Object)x$16);
        qual$7.$bang((Object)x$16, x$17);
    }

    @Override
    public void execute(String taskid) {
        Task task = this.retrieve(taskid);
        task.setState(TaskExecutionState.QUEUED);
        ScalaActorSelection qual$8 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        Enqueue x$18 = new Enqueue(taskid);
        ActorRef x$19 = qual$8.$bang$default$2((Object)x$18);
        qual$8.$bang((Object)x$18, x$19);
    }

    @Override
    public void schedule(String taskid, DateTime scheduleAt) {
        long tickMillis;
        if (scheduleAt.isBeforeNow()) {
            throw new TaskerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot schedule a task for the past, date entered was [", ", now is [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TaskExecutionEngine.p$1(scheduleAt), TaskExecutionEngine.p$1(Imports$.MODULE$.DateTime().now())})));
        }
        long delayMillis = RichReadableInterval$.MODULE$.millis$extension(Imports$.MODULE$.richReadableInterval((ReadableInterval)RichReadableInstant$.MODULE$.to$extension(Imports$.MODULE$.richReadableInstant((ReadableInstant)Imports$.MODULE$.DateTime().now()), (ReadableInstant)scheduleAt)));
        if (delayMillis > (long)Integer.MAX_VALUE * (tickMillis = this.taskerSettings().tickDuration().toMillis())) {
            DateTime time = new DateTime((Object)RichDateTime$.MODULE$.millis$extension(Imports$.MODULE$.richDateTime(Imports$.MODULE$.DateTime().now())).addToCopy(tickMillis * Integer.MAX_VALUE));
            throw new TaskerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot schedule task [", "] at [", "], because it is too far into the future. Can only schedule to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskid, TaskExecutionEngine.p$1(scheduleAt), TaskExecutionEngine.p$1(time)})));
        }
        ScalaActorSelection qual$9 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        TaskManagingActor.messages.Schedule x$20 = new TaskManagingActor.messages.Schedule(taskid, scheduleAt);
        ActorRef x$21 = qual$9.$bang$default$2((Object)x$20);
        qual$9.$bang((Object)x$20, x$21);
    }

    @Override
    public String register(TaskSpecification spec) {
        Task task = new Task(spec.getId(), spec);
        task.context().repository_$eq(this.createRepository(task));
        Timeout timeout = this.taskerSettings().askTimeout();
        ActorRef qual$10 = akka.pattern.package$.MODULE$.ask(this.createTaskActor(task));
        TaskManagingActor.messages.Register x$22 = new TaskManagingActor.messages.Register(task);
        Timeout x$23 = timeout;
        ActorRef x$24 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$10, (Object)x$22);
        Await$.MODULE$.ready((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$10, (Object)x$22, x$23, x$24), (Duration)timeout.duration());
        return task.getId();
    }

    private Repository createRepository(Task task) {
        return this.repositoryFactory.create(new File(task.getWorkDir().getPath()));
    }

    @Override
    public Task retrieve(String taskid) {
        return (Task)((TaskRegistryExtension)TaskRegistryExtension$.MODULE$.apply(this.system())).getTask(taskid).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new TaskNotFoundException("registry", taskid);
        });
    }

    @Override
    public java.util.List<Task> getAllIncompleteTasks() {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(((TaskRegistryExtension)TaskRegistryExtension$.MODULE$.apply(this.system())).getTasks()).asJava();
    }

    public ActorSelection lookupTaskActor(String s) {
        return this.system().actorSelection(this.system().child(s));
    }

    public ActorRef createTaskActor(Task task) {
        return this.system().actorOf(TaskManagingActor$.MODULE$.props(task), task.getId());
    }

    @Override
    public ActorSystem getSystem() {
        return this.system();
    }

    public static final /* synthetic */ boolean $anonfun$shutdownTasks$1(Task t) {
        return ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TaskExecutionState[]{TaskExecutionState.ABORTING, TaskExecutionState.EXECUTING, TaskExecutionState.FAILING, TaskExecutionState.STOPPING}))).contains((Object)t.getState());
    }

    public static final /* synthetic */ void $anonfun$shutdownTasks$2(TaskExecutionEngine $this, Task t) {
        $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping task [", "] due to shutdown"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getId()})));
        ScalaActorSelection qual$1 = ActorSelection$.MODULE$.toScala($this.lookupTaskActor(t.getId()));
        Stop$ x$1 = Stop$.MODULE$;
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
        Promise promise = Promise$.MODULE$.apply();
        $this.system().actorOf(Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Actor(null, promise, t){
            private final ActorContext context;
            private final ActorRef self;
            public final Promise promise$1;
            public final Task t$1;

            public final ActorRef sender() {
                return Actor.sender$((Actor)this);
            }

            public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
                Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
            }

            public void aroundPreStart() {
                Actor.aroundPreStart$((Actor)this);
            }

            public void aroundPostStop() {
                Actor.aroundPostStop$((Actor)this);
            }

            public void aroundPreRestart(Throwable reason, Option<Object> message) {
                Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
            }

            public void aroundPostRestart(Throwable reason) {
                Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
            }

            public SupervisorStrategy supervisorStrategy() {
                return Actor.supervisorStrategy$((Actor)this);
            }

            public void preStart() throws Exception {
                Actor.preStart$((Actor)this);
            }

            public void postStop() throws Exception {
                Actor.postStop$((Actor)this);
            }

            public void preRestart(Throwable reason, Option<Object> message) throws Exception {
                Actor.preRestart$((Actor)this, (Throwable)reason, message);
            }

            public void postRestart(Throwable reason) throws Exception {
                Actor.postRestart$((Actor)this, (Throwable)reason);
            }

            public void unhandled(Object message) {
                Actor.unhandled$((Actor)this, (Object)message);
            }

            public ActorContext context() {
                return this.context;
            }

            public final ActorRef self() {
                return this.self;
            }

            public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
                this.context = x$1;
            }

            public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
                this.self = x$1;
            }

            public PartialFunction<Object, BoxedUnit> receive() {
                return new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof TaskDone) {
                            TaskDone taskDone = (TaskDone)A1;
                            Task doneTask = taskDone.task();
                            String string = doneTask.getId();
                            String string2 = this.$outer.t$1.getId();
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                this.$outer.promise$1.success((Object)doneTask.getId());
                                object = BoxedUnit.UNIT;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Object x1) {
                        Object object = x1;
                        if (!(object instanceof TaskDone)) return false;
                        TaskDone taskDone = (TaskDone)object;
                        Task doneTask = taskDone.task();
                        String string = doneTask.getId();
                        String string2 = this.$outer.t$1.getId();
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
            {
                this.promise$1 = promise$1;
                this.t$1 = t$1;
                Actor.$init$((Actor)this);
            }
        }, ClassTag$.MODULE$.apply(Actor.class)));
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (String)Await$.MODULE$.result((Awaitable)promise.future(), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds()));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            $this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to stop task [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getId()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            String value = (String)success.value();
            $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully stopped task [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$cleanUpTmpFiles$2(TaskExecutionEngine $this, File file) {
        try {
            $this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting corrupted task file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
            Files.delete(file.toPath());
        }
        catch (Throwable e) {
            $this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete corrupted recovery file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    private static final String p$1(DateTime d) {
        return d.toString("yyyy-MM-dd HH:mm:ss Z");
    }

    public TaskExecutionEngine(Archive archive, RepositoryFactory repositoryFactory, ActorSystem system) {
        this.repositoryFactory = repositoryFactory;
        this.system = system;
        Logging.$init$((Logging)this);
        this.taskerSettings = ((CommonSettings)CommonSettings$.MODULE$.apply(system)).tasker();
        this.archiver = system.actorOf(ArchiveActor$.MODULE$.props(archive), ArchiveActor$.MODULE$.name());
        this.taskTransitioner = system.actorOf(TaskTransitionActor$.MODULE$.props(this), TaskTransitionActor$.MODULE$.name());
        this.recoverySupervisor = system.actorOf(RecoverySupervisorActor$.MODULE$.props(this.taskerSettings().recoveryDir()), RecoverySupervisorActor$.MODULE$.name());
        this.taskRecoveryListener = system.actorOf(TaskRecoveryListener$.MODULE$.props(this.recoverySupervisor()), TaskRecoveryListener$.MODULE$.name());
    }
}

