/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.PerQueryCache;
import org.apache.jackrabbit.core.query.lucene.RangeQuery;
import org.apache.lucene.index.Term;

public class LocalNameRangeQuery
extends RangeQuery {
    public LocalNameRangeQuery(String lowerName, String upperName, boolean inclusive, PerQueryCache cache) {
        super(LocalNameRangeQuery.getLowerTerm(lowerName), LocalNameRangeQuery.getUpperTerm(upperName), inclusive, cache);
    }

    private static Term getLowerTerm(String lowerName) {
        String text = lowerName == null ? "" : lowerName;
        return new Term(FieldNames.LOCAL_NAME, text);
    }

    private static Term getUpperTerm(String upperName) {
        String text = upperName == null ? "\uffff" : upperName;
        return new Term(FieldNames.LOCAL_NAME, text);
    }
}

