/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Function;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Provisionable;
import com.xebialabs.deployit.plugin.api.udm.Provisioned;
import com.xebialabs.deployit.plugin.api.udm.ProvisioningPackage;
import com.xebialabs.deployit.service.deployment.AbstractChainGenerator;
import com.xebialabs.deployit.service.deployment.DeployedApplicationFactory;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.DeploymentContext;
import com.xebialabs.deployit.service.deployment.GeneratedDeployeds;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import java.util.stream.IntStream;

public class CardinalDeployedGenerator
extends AbstractChainGenerator {
    private String cardinalityFieldName = "cardinality";

    public CardinalDeployedGenerator(DeployedGenerator nextGenerator) {
        super(nextGenerator);
    }

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        if (this.isProvisioning(deploymentContext.getDeployedApplication()) && this.supportsCardinality(deployable)) {
            return this.provisioned(deploymentContext, deployable, container);
        }
        return this.nextGenerator.generateDeployed(deploymentContext, deployable, container);
    }

    private boolean supportsCardinality(Deployable deployable) {
        return deployable instanceof Provisionable;
    }

    private GeneratedDeployeds provisioned(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        GeneratedDeployeds generatedDeployeds = new GeneratedDeployeds();
        int cardinality = this.resolveCardinality(deploymentContext, (Provisionable)deployable, container);
        Function id = deployed -> deployed.getOrdinal() > 1 ? deployed.getId() + "-" + deployed.getOrdinal() : deployed.getId();
        IntStream.range(1, cardinality + 1).forEach(ordinal -> {
            Deployed deployed = this.nextGenerator.generateDeployed(deploymentContext, deployable, container).getDeployeds().get(0);
            Provisioned provisioned = (Provisioned)deployed;
            provisioned.setOrdinal(ordinal);
            provisioned.setId((String)id.apply((Object)provisioned));
            generatedDeployeds.addDeployed(deployed);
        });
        return generatedDeployeds;
    }

    private boolean isProvisioning(DeployedApplication deployedApplication) {
        return deployedApplication.getVersion() instanceof ProvisioningPackage;
    }

    private int resolveCardinality(DeploymentContext deploymentContext, Provisionable provisionable, Container container) {
        try {
            Object o = deploymentContext.dictionaryFilteredByContainer(container).resolve((Object)provisionable.getCardinality(), provisionable.getType().getDescriptor().getPropertyDescriptor(this.cardinalityFieldName));
            return Integer.parseInt(((StringValue)o).toPublicFacingValue());
        }
        catch (DictionaryValueException e) {
            throw new DeployedApplicationFactory.IncorrectDeployedException(e, "Couldn't resolve cardinality property from [%s]", provisionable.getName());
        }
    }
}

