/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.replacer;

import com.xebialabs.deployit.engine.replacer.PlaceholderReplacer;
import com.xebialabs.deployit.engine.replacer.PlaceholderScanner;
import com.xebialabs.deployit.engine.unicode.BOM;
import com.xebialabs.deployit.engine.unicode.DetectBOM;
import com.xebialabs.deployit.plugin.api.udm.artifact.ArchiveArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereUtils;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.file.TFileReader;
import de.schlichtherle.truezip.file.TVFS;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Placeholders {
    public static final String DEFAULT_DELIMS = "{{ }}";
    public static Function<String, Pattern> COMPUTE_FUNCTION = key -> Pattern.compile(key, 6);
    public static Map<String, Pattern> patternMap = new ConcurrentHashMap<String, Pattern>();
    private static final Logger logger = LoggerFactory.getLogger(Placeholders.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanPlaceholders(SourceArtifact artifact, PlaceholderScanner scanner) {
        OverthereFile artifactFile = artifact.getFile();
        OverthereUtils.checkArgument((artifactFile != null ? 1 : 0) != 0, (String)(artifact + " has no file"), (Object[])new Object[0]);
        artifact.setPlaceholders(new TreeSet());
        if (!Placeholders.shouldScanPlaceholders(artifact)) {
            logger.debug("Artifact [{}] has disabled placeholder scanning", (Object)artifact);
            return;
        }
        TFile from = Placeholders.asTfile(artifactFile);
        try {
            Placeholders.doScanPlaceholders(artifact, from, scanner, true, artifactFile.getPath());
        }
        finally {
            Placeholders.umountQuietly(from);
        }
    }

    public static boolean shouldScanPlaceholders(SourceArtifact artifact) {
        return !artifact.hasProperty("scanPlaceholders") || (Boolean)artifact.getProperty("scanPlaceholders") != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doScanPlaceholders(SourceArtifact artifact, TFile from, PlaceholderScanner scanner, boolean isRoot, String basePath) {
        if (Placeholders.shouldExcludeFile(from, artifact, isRoot)) {
            return;
        }
        logger.trace("File [{}] is a [directory, archive, file]: [{}, {}, {}]", new Object[]{from, from.isDirectory(), from.isArchive(), from.isFile()});
        if (from.isDirectory()) {
            try {
                for (TFile f : from.listFiles(Placeholders.getTArchiveDetector())) {
                    Placeholders.doScanPlaceholders(artifact, f, scanner, false, basePath);
                }
            }
            finally {
                Placeholders.umountQuietly(from);
            }
        } else if (Placeholders.isTextFile(from.getName(), artifact.getTextFileNamesRegex())) {
            artifact.getPlaceholders().addAll(Placeholders.readPlaceholders(artifact, from, scanner, basePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> readPlaceholders(SourceArtifact artifact, TFile from, PlaceholderScanner scanner, String basePath) {
        Set<String> set;
        TFileReader in;
        Charset charset = Placeholders.getCharset(artifact, from, basePath);
        if (charset == null) {
            logger.debug("Replacing placeholders in [{}] using default charset", (Object)from);
            in = new TFileReader(from);
        } else {
            logger.debug("Replacing placeholders in [{}] using charset [{}]", (Object)from, (Object)charset);
            in = new TFileReader(from, charset.newDecoder());
        }
        try {
            set = scanner.scan((Reader)in, Placeholders.getDelimiters(artifact));
        }
        catch (Throwable throwable) {
            try {
                OverthereUtils.closeQuietly((Closeable)in);
                throw throwable;
            }
            catch (IOException exc) {
                throw new RuntimeIOException(String.format("Cannot scan placeholders in [%s]", from), (Throwable)exc);
            }
            catch (RuntimeException exc) {
                throw new RuntimeException(String.format("Cannot scan placeholders in [%s]", from), exc);
            }
        }
        OverthereUtils.closeQuietly((Closeable)in);
        return set;
    }

    private static String getDelimiters(SourceArtifact artifact) {
        return artifact.hasProperty("delimiters") ? (String)artifact.getProperty("delimiters") : DEFAULT_DELIMS;
    }

    public static void replacePlaceholders(DerivedArtifact<? extends SourceArtifact> derivedArtifact, PlaceholderReplacer replacer) {
        if (derivedArtifact.getSourceArtifact() == null) {
            derivedArtifact.setFile(null);
        } else {
            OverthereFile derivedFile = Placeholders.createDerivedFile(derivedArtifact, replacer);
            derivedArtifact.setFile(derivedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OverthereFile createDerivedFile(DerivedArtifact<? extends SourceArtifact> derivedArtifact, PlaceholderReplacer replacer) {
        OverthereFile fromFile;
        block8: {
            OverthereUtils.checkArgument((derivedArtifact.getSourceArtifact() != null ? 1 : 0) != 0, (String)"Source artifact is not specified for [%s]", (Object[])new Object[]{derivedArtifact.getId()});
            fromFile = derivedArtifact.getSourceArtifact().getFile();
            OverthereUtils.checkArgument((fromFile != null ? 1 : 0) != 0, (String)"[%s] has no file", (Object[])new Object[]{derivedArtifact.getSourceArtifact()});
            TFile from = null;
            try {
                boolean bl;
                boolean isBinaryFile;
                from = Placeholders.getTFileWithCorrectDirectoryDetection(fromFile);
                boolean bl2 = isBinaryFile = from.isFile() && !Placeholders.isTextFile(fromFile.getName(), Placeholders.getTextFileNamesRegex(derivedArtifact));
                if (derivedArtifact.getPlaceholders().isEmpty() || isBinaryFile) break block8;
                OverthereFile derivedFile = Placeholders.getOutputFile(derivedArtifact);
                try {
                    fromFile.copyTo(derivedFile);
                    TFile to = Placeholders.getTFileWithCorrectDirectoryDetection(derivedFile);
                    try {
                        Placeholders.doReplacePlaceholders(derivedArtifact, to, replacer, true, derivedFile.getPath());
                        Placeholders.saveArchive(to);
                    }
                    finally {
                        Placeholders.umountQuietly(to);
                    }
                    bl = derivedFile.getParentFile().listFiles().size() == 1;
                }
                catch (Throwable throwable) {
                    OverthereUtils.checkState((derivedFile.getParentFile().listFiles().size() == 1 ? 1 : 0) != 0, (String)"Should only be one file in the deployed dir, was %s", (Object[])new Object[]{derivedFile.getParentFile().listFiles()});
                    throw throwable;
                }
                OverthereUtils.checkState((boolean)bl, (String)"Should only be one file in the deployed dir, was %s", (Object[])new Object[]{derivedFile.getParentFile().listFiles()});
                OverthereFile overthereFile = derivedFile;
                return overthereFile;
            }
            finally {
                Placeholders.umountQuietly(from);
            }
        }
        return fromFile;
    }

    private static TFile getTFileWithCorrectDirectoryDetection(OverthereFile derivedFile) {
        TFile to;
        if (derivedFile.isDirectory()) {
            to = new TFile(derivedFile.getPath(), TArchiveDetector.NULL);
        } else {
            String parentPath = derivedFile.getParentFile().getPath();
            to = new TFile((File)new TFile(parentPath, TArchiveDetector.NULL), derivedFile.getName(), Placeholders.getTArchiveDetector());
        }
        return to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doReplacePlaceholders(DerivedArtifact<? extends SourceArtifact> derivedArtifact, TFile to, PlaceholderReplacer replacer, boolean isRoot, String basePath) {
        boolean include;
        boolean bl = include = !Placeholders.shouldExcludeFile(to, derivedArtifact.getSourceArtifact(), isRoot);
        if (include && to.isDirectory()) {
            try {
                for (TFile t : to.listFiles(Placeholders.getTArchiveDetector())) {
                    Placeholders.doReplacePlaceholders(derivedArtifact, t, replacer, false, basePath);
                }
            }
            finally {
                Placeholders.umountQuietly(to);
            }
        } else if (include && Placeholders.isTextFile(to.getName(), Placeholders.getTextFileNamesRegex(derivedArtifact))) {
            Placeholders.replace(to, replacer, derivedArtifact, basePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replace(TFile toBeReplaced, PlaceholderReplacer replacer, DerivedArtifact<? extends SourceArtifact> artifact, String basePath) {
        try {
            Charset charset = Placeholders.getCharset(artifact.getSourceArtifact(), toBeReplaced, basePath);
            File tempFile = File.createTempFile(toBeReplaced.getName(), ".tmp");
            try {
                OutputStreamWriter writer;
                TFileReader reader;
                if (charset == null) {
                    logger.debug("Replacing placeholders in [{}] using default charset", (Object)toBeReplaced);
                    reader = new TFileReader(toBeReplaced);
                    writer = new OutputStreamWriter(new FileOutputStream(tempFile));
                } else {
                    logger.debug("Replacing placeholders in [{}] using charset [{}]", (Object)toBeReplaced, (Object)charset);
                    reader = new TFileReader(toBeReplaced, charset.newDecoder());
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), charset.newEncoder());
                }
                try {
                    replacer.replace((Reader)reader, writer, artifact.getPlaceholders(), Placeholders.getDelimiters(artifact.getSourceArtifact()));
                }
                finally {
                    OverthereUtils.closeQuietly((Closeable)reader);
                    OverthereUtils.closeQuietly((Closeable)writer);
                }
                try (FileInputStream is = new FileInputStream(tempFile);
                     TFileOutputStream os = new TFileOutputStream((File)toBeReplaced);){
                    OverthereUtils.write((InputStream)is, (OutputStream)os);
                }
            }
            finally {
                if (!tempFile.delete()) {
                    logger.warn("Cannot delete temporary file [{}]", (Object)tempFile);
                }
            }
        }
        catch (IOException | RuntimeException exc) {
            throw new RuntimeIOException(String.format("Cannot replace placeholders in [%s]", toBeReplaced), (Throwable)exc);
        }
    }

    private static OverthereFile getOutputFile(DerivedArtifact<? extends SourceArtifact> derivedArtifact) {
        OverthereFile sourceFile = derivedArtifact.getSourceArtifact().getFile();
        OverthereFile workDir = sourceFile.getParentFile();
        return OverthereUtils.getUniqueFolder((OverthereFile)workDir, (String)derivedArtifact.getName()).getFile(sourceFile.getName());
    }

    private static File saveArchive(TFile outputArchive) {
        if (outputArchive.isArchive() && outputArchive.getEnclArchive() == null && outputArchive.isDirectory()) {
            try {
                TVFS.umount((TFile)outputArchive);
            }
            catch (IOException exc) {
                throw new RuntimeIOException(String.format("Cannot write archive [%s]", outputArchive), (Throwable)exc);
            }
        }
        return new File(outputArchive.getPath());
    }

    private static boolean shouldExcludeFile(TFile f, SourceArtifact artifact, boolean isRoot) {
        if (isRoot && artifact instanceof FolderArtifact) {
            return false;
        }
        if (artifact.getExcludeFileNamesRegex() == null || artifact.getExcludeFileNamesRegex().trim().isEmpty()) {
            return false;
        }
        Pattern excludeFileNamesPattern = patternMap.computeIfAbsent(artifact.getExcludeFileNamesRegex(), COMPUTE_FUNCTION);
        Matcher excludeFileNamesMatcher = excludeFileNamesPattern.matcher(f.getPath());
        boolean exclude = excludeFileNamesMatcher.matches();
        if (exclude) {
            logger.debug("Excluding file [{}] from scanning", (Object)f);
        }
        return exclude;
    }

    private static boolean isTextFile(String name, String textFileNamesRegex) {
        OverthereUtils.checkNotNull((Object)textFileNamesRegex, (String)"Regex is null", (Object[])new Object[0]);
        Pattern textFileNamesPattern = patternMap.computeIfAbsent(textFileNamesRegex, COMPUTE_FUNCTION);
        Matcher textFileNamesMatcher = textFileNamesPattern.matcher(name);
        boolean isTextFile = textFileNamesMatcher.matches();
        logger.debug("Determined [{}] to be a {} file", (Object)name, (Object)(isTextFile ? "text" : "binary"));
        return isTextFile;
    }

    private static String getTextFileNamesRegex(DerivedArtifact<? extends SourceArtifact> derivedArtifact) {
        return derivedArtifact.getSourceArtifact().getTextFileNamesRegex();
    }

    private static TFile asTfile(OverthereFile file) {
        File from = new File(file.getPath());
        if (from.isDirectory()) {
            return new TFile(from, TArchiveDetector.NULL);
        }
        return new TFile(from);
    }

    static void umountQuietly(TFile file) {
        if (file != null && file.isArchive() && file.getEnclArchive() == null) {
            try {
                TVFS.umount((TFile)file);
            }
            catch (Exception e) {
                logger.error("Cannot umount [{}], ignoring exception.", (Object)file);
                logger.debug("Exception while umounting was: ", (Throwable)e);
            }
        }
    }

    private static Charset getCharset(SourceArtifact artifact, TFile file, String basePath) throws IOException {
        String relativePath = Placeholders.getRelativePath(artifact, file, basePath);
        logger.trace("Relative path = {}", (Object)relativePath);
        Map fileEncodings = artifact.getFileEncodings();
        for (Map.Entry regexToCharset : fileEncodings.entrySet()) {
            if (!relativePath.matches((String)regexToCharset.getKey())) continue;
            logger.debug("Relative path [{}] matched regex [{}], using charset [{}]", new Object[]{relativePath, regexToCharset.getKey(), regexToCharset.getValue()});
            return Charset.forName((String)regexToCharset.getValue());
        }
        BOM detect = DetectBOM.detect(file);
        return detect.getCharset();
    }

    private static String getRelativePath(SourceArtifact artifact, TFile file, String basePath) {
        if (artifact instanceof FolderArtifact || artifact instanceof ArchiveArtifact) {
            return file.getPath().substring(basePath.length() + 1);
        }
        return file.getName();
    }

    private static TArchiveDetector getTArchiveDetector() {
        return TConfig.get().getArchiveDetector();
    }
}

