/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.LocalMethodDescriptor;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodVerification;
import com.xebialabs.deployit.plugin.api.reflect.VerificationContext;
import com.xebialabs.deployit.plugin.api.reflect.Verify;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultDelegates {
    @Delegate(name="methodInvoker")
    public static List<Step> invokeMethod(ConfigurationItem ci, String methodName, Map<String, String> arguments, Parameters parameters) {
        List<Method> methods = Arrays.asList(ci.getClass().getMethods());
        Method method = methods.stream().filter(m -> m.getName().equals(methodName) && m.isAnnotationPresent(ControlTask.class)).findFirst().get();
        try {
            if (method.getParameterTypes().length == 1) {
                return (List)method.invoke((Object)ci, parameters);
            }
            return (List)method.invoke((Object)ci, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not invoke " + methodName + " on " + ci, e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleInvocationTargetException(e, "Could not invoke " + methodName + " on " + ci);
        }
    }

    @Delegate(name="dispatcherInvoker")
    @DispatcherVerification
    public static List<Step> invokeDispatcher(ConfigurationItem ci, String methodName, Map<String, String> arguments, Parameters parameters) {
        Method dispatcher = DefaultDelegates.getDispatcher(ci);
        try {
            if (dispatcher.getParameterTypes().length == 3) {
                return (List)dispatcher.invoke((Object)ci, methodName, arguments, parameters);
            }
            if (dispatcher.getParameterTypes().length == 2) {
                return (List)dispatcher.invoke((Object)ci, methodName, arguments);
            }
            return (List)dispatcher.invoke((Object)ci, methodName);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleInvocationTargetException(e, "Could not invoke " + methodName + " on " + ci);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not invoke " + methodName + " on " + ci, e);
        }
    }

    private static Method getDispatcher(ConfigurationItem ci) {
        Class<?> clazz = ci.getClass();
        return Arrays.stream(clazz.getMethods()).filter(m -> m.getName().equals("controlTaskDispatch")).findFirst().get();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Verify(clazz=Verification.class, type="dispatcherVerification")
    static @interface DispatcherVerification {

        public static class Verification
        implements MethodVerification {
            public void verify(MethodDescriptor descriptor, VerificationContext context) {
                Class clazz = ((LocalMethodDescriptor)descriptor).getDescriptor().getClazz();
                List filter = Arrays.stream(clazz.getMethods()).filter(m -> m.getName().equals("controlTaskDispatch")).collect(Collectors.toList());
                if (filter.size() == 0) {
                    context.error("ControlTask dispatcher [%s] for [%s] is not present.", new Object[]{"controlTaskDispatch", descriptor.getFqn()});
                } else if (filter.size() > 1) {
                    context.error("Found more than 1 ControlTask dispatcher [%s] for [%s].", new Object[]{"controlTaskDispatch", descriptor.getFqn()});
                } else {
                    boolean methodWithOnlyArguments;
                    Method method = (Method)filter.get(0);
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    boolean methodWithArgumentsAndParameters = parameterTypes.length == 3;
                    boolean bl = methodWithOnlyArguments = parameterTypes.length == 2;
                    if (!List.class.isAssignableFrom(method.getReturnType())) {
                        context.error("ControlTask dispatcher [%s] for [%s] should return a List<Step>", new Object[]{"controlTaskDispatch", descriptor.getFqn()});
                    }
                    if (!String.class.isAssignableFrom(parameterTypes[0])) {
                        context.error("ControlTask dispatcher [%s] for [%s] doesn't take a String as first parameter.", new Object[]{"controlTaskDispatch", descriptor.getFqn()});
                    }
                    if ((methodWithArgumentsAndParameters || methodWithOnlyArguments) && !Map.class.isAssignableFrom(parameterTypes[1])) {
                        context.error("ControlTask dispatcher [%s] for [%s] should take a Map<String,String> as second parameter.", new Object[]{"controlTaskDispatch", descriptor.getFqn()});
                    }
                    if (methodWithArgumentsAndParameters && !Parameters.class.isAssignableFrom(parameterTypes[2])) {
                        context.error("ControlTask dispatcher [%s] for [%s] should take a [udm.Parameters] sub-type as third parameter.", new Object[]{"controlTaskDispatch", descriptor.getFqn()});
                    }
                    if (descriptor.getParameterObjectType() != null && !methodWithArgumentsAndParameters) {
                        context.error("ControlTask dispatcher [%s] for [%s] doesn't take parameters of type [%s].", new Object[]{"controlTaskDispatch", descriptor.getFqn(), descriptor.getParameterObjectType()});
                    }
                    if (descriptor.getParameterObjectType() == null && descriptor.getAttributes().size() > 0 && !methodWithOnlyArguments) {
                        context.error("ControlTask dispatcher [%s] for [%s] doesn't take a Map of arguments", new Object[]{"controlTaskDispatch", descriptor.getFqn()});
                    }
                }
            }
        }
    }
}

