/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.security.Role;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class DtoReader {
    public static final Function<ConfigurationItem, ConfigurationItemId> ciToCiId = ci -> new ConfigurationItemId(ci.getId(), ci.getType());
    public static final Function<ConfigurationItemData, ConfigurationItemId> ciDataToCiId = cid -> new ConfigurationItemId(cid.getId(), cid.getType());
    public static final Function<ConfigurationItemId, ConfigurationItemData> ciIdToCiData = input -> new ConfigurationItemData(input.getId(), input.getType());

    public List<com.xebialabs.deployit.security.Role> readRoleAssignments(List<RolePrincipals> assignments) {
        ArrayList<com.xebialabs.deployit.security.Role> roles = new ArrayList<com.xebialabs.deployit.security.Role>();
        for (RolePrincipals roleAssignment : assignments) {
            Role roleDto = roleAssignment.getRole();
            com.xebialabs.deployit.security.Role role = DtoReader.asRole(roleDto);
            List principals = roleAssignment.getPrincipals();
            role.getPrincipals().addAll(principals);
            roles.add(role);
        }
        return roles;
    }

    private static com.xebialabs.deployit.security.Role asRole(Role roleDto) {
        return new com.xebialabs.deployit.security.Role(roleDto.getId(), roleDto.getName());
    }

    public Map<com.xebialabs.deployit.security.Role, Set<Permission>> readRolePermissions(List<RolePermissions> permissions, List<com.xebialabs.deployit.security.Role> roles) {
        HashMap<com.xebialabs.deployit.security.Role, Set<Permission>> map = new HashMap<com.xebialabs.deployit.security.Role, Set<Permission>>();
        for (RolePermissions rolePermission : permissions) {
            com.xebialabs.deployit.security.Role role = DtoReader.asRole(rolePermission.getRole());
            if (role.getId() == null) {
                role = DtoReader.findRole(role.getName(), roles);
            }
            Set collect = rolePermission.getPermissions().stream().map(Permission::find).collect(Collectors.toSet());
            map.put(role, collect);
        }
        return map;
    }

    private static com.xebialabs.deployit.security.Role findRole(String name, List<com.xebialabs.deployit.security.Role> roles) {
        for (com.xebialabs.deployit.security.Role role : roles) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        throw new IllegalArgumentException(String.format("Couldn't find role with name [%s]", name));
    }
}

