/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.jndi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.commons.AbstractRepository;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;

public class BindableRepository
extends AbstractRepository
implements JackrabbitRepository,
Referenceable,
Serializable {
    private static final long serialVersionUID = 8864716577016297651L;
    public static final String CONFIGFILEPATH_ADDRTYPE = "configFilePath";
    public static final String REPHOMEDIR_ADDRTYPE = "repHomeDir";
    private final Reference reference;
    private transient JackrabbitRepository repository;
    private transient Thread hook;

    public BindableRepository(Reference reference) throws RepositoryException {
        this.reference = reference;
        this.init();
    }

    private void init() throws RepositoryException {
        this.repository = this.createRepository();
        this.hook = new Thread(){

            public void run() {
                BindableRepository.this.shutdown();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.hook);
    }

    protected JackrabbitRepository createRepository() throws RepositoryException {
        RepositoryConfig config = RepositoryConfig.create(this.reference.get(CONFIGFILEPATH_ADDRTYPE).getContent().toString(), this.reference.get(REPHOMEDIR_ADDRTYPE).getContent().toString());
        return RepositoryImpl.create(config);
    }

    protected JackrabbitRepository getRepository() {
        return this.repository;
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.repository.login(credentials, workspaceName);
    }

    public String getDescriptor(String key) {
        return this.repository.getDescriptor(key);
    }

    public String[] getDescriptorKeys() {
        return this.repository.getDescriptorKeys();
    }

    public Reference getReference() {
        return this.reference;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.init();
        }
        catch (RepositoryException e) {
            IOException exception = new IOException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    public void shutdown() {
        this.repository.shutdown();
        try {
            Runtime.getRuntime().removeShutdownHook(this.hook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

