/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.jsr283.security.AccessControlException;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicy;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicyIterator;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AbstractAccessControlManager;
import org.apache.jackrabbit.core.security.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccessManager
extends AbstractAccessControlManager
implements AccessManager {
    private static final Logger log = LoggerFactory.getLogger((Class)DefaultAccessManager.class);
    private static final CompiledPermissions NO_PERMISSION = new CompiledPermissions(){

        public void close() {
        }

        public boolean grants(Path absPath, int permissions) {
            return false;
        }

        public int getPrivileges(Path absPath) {
            return 0;
        }

        public boolean canReadAll() {
            return false;
        }
    };
    private boolean initialized;
    private NamePathResolver resolver;
    private Set principals;
    private AccessControlProvider acProvider;
    private AccessControlEditor editor;
    private PrivilegeRegistry privilegeRegistry;
    private WorkspaceAccess wspAccess;
    private HierarchyManager hierMgr;
    private CompiledPermissions compiledPermissions;

    public void init(AMContext amContext) throws AccessDeniedException, Exception {
        this.init(amContext, null, null);
    }

    public void init(AMContext amContext, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessManager) throws AccessDeniedException, Exception {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized.");
        }
        this.acProvider = acProvider;
        this.resolver = amContext.getNamePathResolver();
        this.hierMgr = amContext.getHierarchyManager();
        Subject subject = amContext.getSubject();
        this.principals = subject == null ? Collections.EMPTY_SET : subject.getPrincipals();
        this.wspAccess = new WorkspaceAccess(wspAccessManager, DefaultAccessManager.isSystemOrAdmin(subject));
        this.privilegeRegistry = new PrivilegeRegistry(this.resolver);
        if (acProvider != null) {
            this.editor = acProvider.getEditor(amContext.getSession());
            this.compiledPermissions = acProvider.compilePermissions(this.principals);
        } else {
            log.warn("No AccessControlProvider defined -> no access is granted.");
            this.editor = null;
            this.compiledPermissions = NO_PERMISSION;
        }
        this.initialized = true;
        if (!this.canAccess(amContext.getWorkspaceName())) {
            throw new AccessDeniedException("Not allowed to access Workspace " + amContext.getWorkspaceName());
        }
    }

    public void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("Manager is not initialized.");
        }
        this.initialized = false;
        this.compiledPermissions.close();
        this.hierMgr = null;
        this.acProvider = null;
        this.editor = null;
        this.wspAccess = null;
    }

    public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        if (!this.isGranted(id, permissions)) {
            throw new AccessDeniedException("Not sufficient privileges for permissions : " + permissions + " on " + id);
        }
    }

    public boolean isGranted(ItemId id, int actions) throws ItemNotFoundException, RepositoryException {
        this.checkInitialized();
        if (actions == 1 && this.compiledPermissions.canReadAll()) {
            return true;
        }
        int perm = 0;
        if ((actions & 1) == 1) {
            perm |= 1;
        }
        if ((actions & 2) == 2) {
            if (id.denotesNode()) {
                perm |= 2;
                perm |= 4;
            } else {
                perm |= 2;
            }
        }
        if ((actions & 4) == 4) {
            perm |= id.denotesNode() ? 8 : 16;
        }
        Path path = this.hierMgr.getPath(id);
        return this.isGranted(path, perm);
    }

    public boolean isGranted(Path absPath, int permissions) throws RepositoryException {
        this.checkInitialized();
        if (!absPath.isAbsolute()) {
            throw new RepositoryException("Absolute path expected");
        }
        return this.compiledPermissions.grants(absPath, permissions);
    }

    public boolean isGranted(Path parentPath, Name childName, int permissions) throws RepositoryException {
        Path p = PathFactoryImpl.getInstance().create(parentPath, childName, true);
        return this.isGranted(p, permissions);
    }

    public boolean canRead(Path itemPath) throws RepositoryException {
        if (this.compiledPermissions.canReadAll()) {
            return true;
        }
        return this.isGranted(itemPath, 1);
    }

    public boolean canAccess(String workspaceName) throws RepositoryException {
        this.checkInitialized();
        return this.wspAccess.canAccess(workspaceName);
    }

    public boolean hasPrivileges(String absPath, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        this.checkInitialized();
        this.checkValidNodePath(absPath);
        if (privileges == null || privileges.length == 0) {
            log.debug("No privileges defined for hasPrivilege test.");
            return true;
        }
        int privs = PrivilegeRegistry.getBits(privileges);
        return this.internalHasPrivileges(absPath, privs);
    }

    public Privilege[] getPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        this.checkInitialized();
        this.checkValidNodePath(absPath);
        int bits = this.compiledPermissions.getPrivileges(this.resolver.getQPath(absPath));
        return bits == 0 ? new Privilege[]{} : this.privilegeRegistry.getPrivileges(bits);
    }

    public AccessControlPolicy[] getPolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPrivileges(absPath, 32);
        AccessControlPolicy[] policies = this.editor != null ? this.editor.getPolicies(absPath) : new AccessControlPolicy[]{};
        return policies;
    }

    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPrivileges(absPath, 32);
        return this.acProvider.getEffectivePolicies(this.getPath(absPath));
    }

    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPrivileges(absPath, 32);
        if (this.editor != null) {
            try {
                AccessControlPolicy[] applicable = this.editor.editAccessControlPolicies(absPath);
                return new AccessControlPolicyIteratorAdapter(Arrays.asList(applicable));
            }
            catch (AccessControlException e) {
                log.debug("No applicable policy at " + absPath);
            }
        }
        return AccessControlPolicyIteratorAdapter.EMPTY;
    }

    public void setPolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPrivileges(absPath, 64);
        if (this.editor == null) {
            throw new UnsupportedRepositoryOperationException("Modification of AccessControlPolicies is not supported. ");
        }
        this.editor.setPolicy(absPath, policy);
    }

    public void removePolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPrivileges(absPath, 64);
        if (this.editor == null) {
            throw new UnsupportedRepositoryOperationException("Removal of AccessControlPolicies is not supported.");
        }
        this.editor.removePolicy(absPath, policy);
    }

    public AccessControlPolicy[] getApplicablePolicies(Principal principal) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        this.checkInitialized();
        if (this.editor == null) {
            throw new UnsupportedRepositoryOperationException("Editing of access control policies is not supported.");
        }
        return this.editor.editAccessControlPolicies(principal);
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }

    protected void checkValidNodePath(String absPath) throws PathNotFoundException, RepositoryException {
        Path p = this.resolver.getQPath(absPath);
        if (!p.isAbsolute()) {
            throw new RepositoryException("Absolute path expected.");
        }
        if (this.hierMgr.resolveNodePath(p) == null) {
            throw new PathNotFoundException("No such node " + absPath);
        }
    }

    protected void checkPrivileges(String absPath, int privileges) throws AccessDeniedException, RepositoryException {
        this.checkValidNodePath(absPath);
        if (!this.internalHasPrivileges(absPath, privileges)) {
            throw new AccessDeniedException("No privilege " + privileges + " at " + absPath);
        }
    }

    protected PrivilegeRegistry getPrivilegeRegistry() throws RepositoryException {
        this.checkInitialized();
        return this.privilegeRegistry;
    }

    private boolean internalHasPrivileges(String absPath, int privileges) throws RepositoryException {
        Path p = this.resolver.getQPath(absPath);
        return (this.compiledPermissions.getPrivileges(p) | ~privileges) == -1;
    }

    private Path getPath(String absPath) throws RepositoryException {
        return this.resolver.getQPath(absPath);
    }

    private static boolean isSystemOrAdmin(Subject subject) {
        if (subject == null) {
            return false;
        }
        return !subject.getPrincipals(SystemPrincipal.class).isEmpty() || !subject.getPrincipals(AdminPrincipal.class).isEmpty();
    }

    private class WorkspaceAccess {
        private final WorkspaceAccessManager wspAccessManager;
        private final boolean isAdmin;
        private final List allowed;
        private final List denied;

        private WorkspaceAccess(WorkspaceAccessManager wspAccessManager, boolean isAdmin) {
            this.wspAccessManager = wspAccessManager;
            this.isAdmin = isAdmin;
            if (!isAdmin) {
                this.allowed = new ArrayList(5);
                this.denied = new ArrayList(5);
            } else {
                this.denied = null;
                this.allowed = null;
            }
        }

        private boolean canAccess(String workspaceName) throws RepositoryException {
            if (this.isAdmin || this.wspAccessManager == null || this.allowed.contains(workspaceName)) {
                return true;
            }
            if (this.denied.contains(workspaceName)) {
                return false;
            }
            boolean canAccess = this.wspAccessManager.grants(DefaultAccessManager.this.principals, workspaceName);
            if (canAccess) {
                this.allowed.add(workspaceName);
            } else {
                this.denied.add(workspaceName);
            }
            return canAccess;
        }
    }
}

