/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config.annotation;

import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.socket.config.annotation.ServletWebSocketHandlerRegistry;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

public class WebSocketConfigurationSupport {
    @Nullable
    private ServletWebSocketHandlerRegistry handlerRegistry;
    @Nullable
    private TaskScheduler scheduler;

    @Bean
    public HandlerMapping webSocketHandlerMapping() {
        ServletWebSocketHandlerRegistry registry = this.initHandlerRegistry();
        if (registry.requiresTaskScheduler()) {
            registry.setTaskScheduler(this.initTaskScheduler());
        }
        return registry.getHandlerMapping();
    }

    private ServletWebSocketHandlerRegistry initHandlerRegistry() {
        if (this.handlerRegistry == null) {
            this.handlerRegistry = new ServletWebSocketHandlerRegistry();
            this.registerWebSocketHandlers(this.handlerRegistry);
        }
        return this.handlerRegistry;
    }

    protected void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
    }

    @Bean
    public TaskScheduler defaultSockJsTaskScheduler() {
        return this.initTaskScheduler();
    }

    private TaskScheduler initTaskScheduler() {
        if (this.scheduler == null) {
            ServletWebSocketHandlerRegistry registry = this.initHandlerRegistry();
            if (registry.requiresTaskScheduler()) {
                ThreadPoolTaskScheduler threadPoolScheduler = new ThreadPoolTaskScheduler();
                threadPoolScheduler.setThreadNamePrefix("SockJS-");
                threadPoolScheduler.setPoolSize(Runtime.getRuntime().availableProcessors());
                threadPoolScheduler.setRemoveOnCancelPolicy(true);
                this.scheduler = threadPoolScheduler;
            } else {
                this.scheduler = new NoOpScheduler();
            }
        }
        return this.scheduler;
    }

    private static class NoOpScheduler
    implements TaskScheduler {
        private NoOpScheduler() {
        }

        @Nullable
        public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
            throw new IllegalStateException("Unexpected use of scheduler.");
        }

        public ScheduledFuture<?> schedule(Runnable task, Date startTime) {
            throw new IllegalStateException("Unexpected use of scheduler.");
        }

        public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Date startTime, long period) {
            throw new IllegalStateException("Unexpected use of scheduler.");
        }

        public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long period) {
            throw new IllegalStateException("Unexpected use of scheduler.");
        }

        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Date startTime, long delay) {
            throw new IllegalStateException("Unexpected use of scheduler.");
        }

        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long delay) {
            throw new IllegalStateException("Unexpected use of scheduler.");
        }
    }
}

