/*
 * Decompiled with CFR 0.152.
 */
package kamon.trace;

import akka.event.LoggingAdapter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kamon.trace.LevelOfDetail;
import kamon.trace.MetricsOnlyContext;
import kamon.trace.Segment;
import kamon.trace.SegmentInfo;
import kamon.trace.Status;
import kamon.trace.Status$Open$;
import kamon.trace.TraceInfo;
import kamon.util.NanoTimestamp$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a!B\u0001\u0003\u0001\t1!A\u0004+sC\u000eLgnZ\"p]R,\u0007\u0010\u001e\u0006\u0003\u0007\u0011\tQ\u0001\u001e:bG\u0016T\u0011!B\u0001\u0006W\u0006lwN\\\n\u0003\u0001\u001d\u0001\"\u0001C\u0005\u000e\u0003\tI!A\u0003\u0002\u0003%5+GO]5dg>sG._\"p]R,\u0007\u0010\u001e\u0005\t\u0019\u0001\u0011\t\u0011)A\u0005\u001d\u0005IAO]1dK:\u000bW.Z\u0002\u0001!\ty\u0001D\u0004\u0002\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\u00111#D\u0001\u0007yI|w\u000e\u001e \u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0002\rA\u0013X\rZ3g\u0013\tI\"D\u0001\u0004TiJLgn\u001a\u0006\u0003/QA\u0011\u0002\b\u0001\u0003\u0002\u0003\u0006IAD\u000f\u0002\u000bQ|7.\u001a8\n\u0005qI\u0001\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u0013Q\u0014\u0018mY3UC\u001e\u001c\b\u0003B\b\"\u001d9I!A\t\u000e\u0003\u00075\u000b\u0007\u000f\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u00035\u0019WO\u001d:f]R\u001cF/\u0019;vgB\u0011\u0001BJ\u0005\u0003O\t\u0011aa\u0015;biV\u001c\b\"C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016.\u00035aWM^3m\u001f\u001a$U\r^1jYB\u0011\u0001bK\u0005\u0003Y\t\u0011Q\u0002T3wK2|e\rR3uC&d\u0017BA\u0015\n\u0011!y\u0003A!A!\u0002\u0013\u0001\u0014aB5t\u0019>\u001c\u0017\r\u001c\t\u0003cIj\u0011\u0001F\u0005\u0003gQ\u0011qAQ8pY\u0016\fg\u000eC\u00056\u0001\t\u0005\t\u0015!\u00037y\u0005q1\u000f^1siRKW.\u001a>uC6\u0004\bCA\u001c;\u001b\u0005A$BA\u001d\u0005\u0003\u0011)H/\u001b7\n\u0005mB$!\u0006*fY\u0006$\u0018N^3OC:|G+[7fgR\fW\u000e]\u0005\u0003{%\tab\u001d;beR$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0003\rawn\u001a\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bQ!\u001a<f]RT\u0011!R\u0001\u0005C.\\\u0017-\u0003\u0002H\u0005\nqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\b\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\u0002\u001bQ\u0014\u0018mY3J]\u001a|7+\u001b8l!\u0011\t4*\u0014(\n\u00051#\"!\u0003$v]\u000e$\u0018n\u001c82!\tA\u0001\u0001\u0005\u00022\u001f&\u0011\u0001\u000b\u0006\u0002\u0005+:LG\u000fC\u0003S\u0001\u0011\u00051+\u0001\u0004=S:LGO\u0010\u000b\u000b\u001bR+fk\u0016-Z5nc\u0006\"\u0002\u0007R\u0001\u0004q\u0001\"\u0002\u000fR\u0001\u0004q\u0001\"B\u0010R\u0001\u0004\u0001\u0003\"\u0002\u0013R\u0001\u0004)\u0003\"B\u0015R\u0001\u0004Q\u0003\"B\u0018R\u0001\u0004\u0001\u0004\"B\u001bR\u0001\u00041\u0004\"B R\u0001\u0004\u0001\u0005\"B%R\u0001\u0004Q\u0005b\u00020\u0001\u0005\u0004%IaX\u0001\u000e?>\u0004XM\\*fO6,g\u000e^:\u0016\u0003\u0001\u0004\"!Y5\u000e\u0003\tT!a\u00193\u0002\r\u0005$x.\\5d\u0015\t)g-\u0001\u0006d_:\u001cWO\u001d:f]RT!!O4\u000b\u0003!\fAA[1wC&\u0011!N\u0019\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\t\r1\u0004\u0001\u0015!\u0003a\u00039yv\u000e]3o'\u0016<W.\u001a8ug\u0002BqA\u001c\u0001C\u0002\u0013%q.A\b`gR\f'\u000f\u001e+j[\u0016\u001cH/Y7q+\u0005\u0001\bCA\u001cr\u0013\t\u0011\bHA\u0007OC:|G+[7fgR\fW\u000e\u001d\u0005\u0007i\u0002\u0001\u000b\u0011\u00029\u0002!}\u001bH/\u0019:u)&lWm\u001d;b[B\u0004\u0003b\u0002<\u0001\u0005\u0004%Ia^\u0001\r?\u0006dGnU3h[\u0016tGo]\u000b\u0002qB\u0019\u0011P\u001f?\u000e\u0003\u0011L!a\u001f3\u0003+\r{gnY;se\u0016tG\u000fT5oW\u0016$\u0017+^3vKB\u0011QP`\u0007\u0002\u0001\u0019)q\u0010\u0001\u0001\u0002\u0002\tqAK]1dS:<7+Z4nK:$8c\u0001@\u0002\u0004A\u0019Q0!\u0002\n\u0007\u0005\u001d\u0011B\u0001\nNKR\u0014\u0018nY:P]2L8+Z4nK:$\b\"CA\u0006}\n\u0005\t\u0015!\u0003\u000f\u0003-\u0019XmZ7f]Rt\u0015-\\3\t\u0017\u0005=aP!A!\u0002\u0013q\u0011\u0011C\u0001\tG\u0006$XmZ8ss&!\u0011qBA\u0003\u0011-\t)B B\u0001B\u0003%a\"a\u0006\u0002\u000f1L'M]1ss&!\u0011QCA\u0003\u0011%\tYB B\u0001B\u0003%\u0001%A\u0006tK\u001elWM\u001c;UC\u001e\u001c\bB\u0002*\u007f\t\u0003\ty\u0002F\u0005}\u0003C\t\u0019#!\n\u0002(!9\u00111BA\u000f\u0001\u0004q\u0001bBA\b\u0003;\u0001\rA\u0004\u0005\b\u0003+\ti\u00021\u0001\u000f\u0011\u001d\tY\"!\bA\u0002\u0001B\u0011\"a\u000b\u007f\u0005\u0004%I!!\f\u0002\u00115,G/\u00193bi\u0006,\"!a\f\u0011\r\u0005E\u0012\u0011\b\b\u000f\u001b\t\t\u0019DC\u0002f\u0003kQ1!a\u000e\u0015\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003w\t\u0019DA\u0004Ue&,W*\u00199\t\u0011\u0005}b\u0010)A\u0005\u0003_\t\u0011\"\\3uC\u0012\fG/\u0019\u0011\t\u000f\u0005\rc\u0010\"\u0011\u0002F\u0005Y\u0011\r\u001a3NKR\fG-\u0019;b)\u0015q\u0015qIA&\u0011\u001d\tI%!\u0011A\u00029\t1a[3z\u0011\u001d\ti%!\u0011A\u00029\tQA^1mk\u0016Dq!!\u0015\u007f\t\u0003\t\u0019&A\tde\u0016\fG/Z*fO6,g\u000e^%oM>$b!!\u0016\u0002\\\u0005}\u0003c\u0001\u0005\u0002X%\u0019\u0011\u0011\f\u0002\u0003\u0017M+w-\\3oi&sgm\u001c\u0005\b\u0003;\ny\u00051\u0001q\u0003M!(/Y2f'R\f'\u000f\u001e+j[\u0016\u001cH/Y7q\u0011\u001d\t\t'a\u0014A\u0002Y\na\u0003\u001e:bG\u0016\u0014V\r\\1uSZ,G+[7fgR\fW\u000e\u001d\u0005\b\u0003K\u0002\u0001\u0015!\u0003y\u00035y\u0016\r\u001c7TK\u001elWM\u001c;tA!I\u0011\u0011\u000e\u0001C\u0002\u0013%\u0011QF\u0001\n?6,G/\u00193bi\u0006D\u0001\"!\u001c\u0001A\u0003%\u0011qF\u0001\u000b?6,G/\u00193bi\u0006\u0004\u0003bBA\"\u0001\u0011\u0005\u0013\u0011\u000f\u000b\u0006\u001d\u0006M\u0014Q\u000f\u0005\b\u0003\u0013\ny\u00071\u0001\u000f\u0011\u001d\ti%a\u001cA\u00029Aq!!\u001f\u0001\t\u0003\nY(\u0001\u0007ti\u0006\u0014HoU3h[\u0016tG\u000f\u0006\u0005\u0002~\u0005\r\u0015QQAD!\rA\u0011qP\u0005\u0004\u0003\u0003\u0013!aB*fO6,g\u000e\u001e\u0005\b\u0003\u0017\t9\b1\u0001\u000f\u0011\u001d\ty!a\u001eA\u00029Aq!!\u0006\u0002x\u0001\u0007a\u0002C\u0004\u0002z\u0001!\t%a#\u0015\u0015\u0005u\u0014QRAH\u0003#\u000b\u0019\nC\u0004\u0002\f\u0005%\u0005\u0019\u0001\b\t\u000f\u0005=\u0011\u0011\u0012a\u0001\u001d!9\u0011QCAE\u0001\u0004q\u0001bBAK\u0003\u0013\u0003\r\u0001I\u0001\u0005i\u0006<7\u000fC\u0004\u0002\u001a\u0002!\t%a'\u0002\r\u0019Lg.[:i)\u0005q\u0005bBAP\u0001\u0011\u0005\u0013\u0011U\u0001\u0010M&t\u0017n\u001d5XSRDWI\u001d:peR\u0019a*a)\t\u0011\u0005\u0015\u0016Q\u0014a\u0001\u0003O\u000bQaY1vg\u0016\u0004B!!+\u00024:!\u00111VAX\u001d\r\t\u0012QV\u0005\u0002+%\u0019\u0011\u0011\u0017\u000b\u0002\u000fA\f7m[1hK&!\u0011QWA\\\u0005%!\u0006N]8xC\ndWMC\u0002\u00022RAq!a/\u0001\t\u0003\ni,A\u0007gS:L7\u000f[*fO6,g\u000e\u001e\u000b\u000e\u001d\u0006}\u0016\u0011YAb\u0003\u000b\fy-!5\t\u000f\u0005-\u0011\u0011\u0018a\u0001\u001d!9\u0011qBA]\u0001\u0004q\u0001bBA\u000b\u0003s\u0003\rA\u0004\u0005\t\u0003\u000f\fI\f1\u0001\u0002J\u0006AA-\u001e:bi&|g\u000eE\u00028\u0003\u0017L1!!49\u00051q\u0015M\\8J]R,'O^1m\u0011\u001d\t)*!/A\u0002\u0001B\u0011\"a5\u0002:B\u0005\t\u0019\u0001\u0019\u0002'%\u001ch)\u001b8jg\",GmV5uQ\u0016\u0013(o\u001c:\t\u000f\u0005]\u0007\u0001\"\u0001\u0002Z\u0006q1\u000f[8vY\u0012LenY;cCR,W#\u0001\u0019\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\u0006\tr-\u001a8fe\u0006$X\r\u0016:bG\u0016LeNZ8\u0016\u0005\u0005\u0005\bc\u0001\u0005\u0002d&\u0019\u0011Q\u001d\u0002\u0003\u0013Q\u0013\u0018mY3J]\u001a|\u0007\"CAu\u0001E\u0005I\u0011AAv\u0003]1\u0017N\\5tQN+w-\\3oi\u0012\"WMZ1vYR$c'\u0006\u0002\u0002n*\u001a\u0001'a<,\u0005\u0005E\b\u0003BAz\u0003{l!!!>\u000b\t\u0005]\u0018\u0011`\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a?\u0015\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u007f\f)PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class TracingContext
extends MetricsOnlyContext {
    private final LoggingAdapter log;
    private final Function1<TracingContext, BoxedUnit> traceInfoSink;
    private final AtomicInteger _openSegments;
    private final long _startTimestamp;
    private final ConcurrentLinkedQueue<TracingSegment> _allSegments;
    private final TrieMap<String, String> _metadata;

    private AtomicInteger _openSegments() {
        return this._openSegments;
    }

    private long _startTimestamp() {
        return this._startTimestamp;
    }

    private ConcurrentLinkedQueue<TracingSegment> _allSegments() {
        return this._allSegments;
    }

    private TrieMap<String, String> _metadata() {
        return this._metadata;
    }

    @Override
    public void addMetadata(String key, String value) {
        this._metadata().put((Object)key, (Object)value);
    }

    @Override
    public Segment startSegment(String segmentName, String category, String library) {
        return this.startSegment(segmentName, category, library, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    @Override
    public Segment startSegment(String segmentName, String category, String library, Map<String, String> tags) {
        this._openSegments().incrementAndGet();
        TracingSegment newSegment = new TracingSegment(this, segmentName, category, library, tags);
        this._allSegments().add(newSegment);
        return newSegment;
    }

    @Override
    public void finish() {
        super.finish();
        this.traceInfoSink.apply((Object)this);
    }

    @Override
    public void finishWithError(Throwable cause) {
        super.finishWithError(cause);
        this.traceInfoSink.apply((Object)this);
    }

    @Override
    public void finishSegment(String segmentName, String category, String library, long duration, Map<String, String> tags, boolean isFinishedWithError) {
        this._openSegments().decrementAndGet();
        super.finishSegment(segmentName, category, library, duration, tags, isFinishedWithError);
    }

    public boolean finishSegment$default$6() {
        return false;
    }

    public boolean shouldIncubate() {
        return Status$Open$.MODULE$.equals(this.status()) || this._openSegments().get() > 0;
    }

    public TraceInfo generateTraceInfo() {
        Predef$.MODULE$.require(this.isClosed(), (Function0 & Serializable & scala.Serializable)() -> "Can't generated a TraceInfo if the Trace has not closed yet.");
        Iterator<TracingSegment> currentSegments = this._allSegments().iterator();
        Builder segmentsInfo = List$.MODULE$.newBuilder();
        while (currentSegments.hasNext()) {
            BoxedUnit boxedUnit;
            TracingSegment segment = currentSegments.next();
            if (segment.isClosed()) {
                boxedUnit = segmentsInfo.$plus$eq((Object)segment.createSegmentInfo(this._startTimestamp(), this.startTimestamp()));
                continue;
            }
            this.log.warning("Segment [{}] will be left out of TraceInfo because it was still open.", (Object)segment.name());
            boxedUnit = BoxedUnit.UNIT;
        }
        return new TraceInfo(this.name(), super.token(), this._startTimestamp(), this.elapsedTime(), (Map<String, String>)this._metadata().toMap(Predef$.MODULE$.$conforms()), this.tags(), (List<SegmentInfo>)((List)segmentsInfo.result()), this.status());
    }

    public TracingContext(String traceName, String token, Map<String, String> traceTags, Status currentStatus, LevelOfDetail levelOfDetail, boolean isLocal, long startTimeztamp, LoggingAdapter log, Function1<TracingContext, BoxedUnit> traceInfoSink) {
        this.log = log;
        this.traceInfoSink = traceInfoSink;
        super(traceName, token, traceTags, currentStatus, levelOfDetail, startTimeztamp, log);
        this._openSegments = new AtomicInteger(0);
        this._startTimestamp = NanoTimestamp$.MODULE$.now();
        this._allSegments = new ConcurrentLinkedQueue();
        this._metadata = TrieMap$.MODULE$.empty();
    }

    public class TracingSegment
    extends MetricsOnlyContext.MetricsOnlySegment {
        private final TrieMap<String, String> metadata = TrieMap$.MODULE$.empty();

        private TrieMap<String, String> metadata() {
            return this.metadata;
        }

        @Override
        public void addMetadata(String key, String value) {
            this.metadata().put((Object)key, (Object)value);
        }

        public SegmentInfo createSegmentInfo(long traceStartTimestamp, long traceRelativeTimestamp) {
            Predef$.MODULE$.require(this.isClosed(), (Function0 & Serializable & scala.Serializable)() -> "Can't generated a SegmentInfo if the Segment has not closed yet.");
            long segmentStartTimestamp = this.startTimestamp() - traceRelativeTimestamp + traceStartTimestamp;
            return new SegmentInfo(this.name(), super.category(), super.library(), segmentStartTimestamp, this.elapsedTime(), (Map<String, String>)this.metadata().toMap(Predef$.MODULE$.$conforms()), this.tags(), this.status());
        }

        public /* synthetic */ TracingContext kamon$trace$TracingContext$TracingSegment$$$outer() {
            return (TracingContext)this.$outer;
        }

        public TracingSegment(TracingContext $outer, String segmentName, String category, String library, Map<String, String> segmentTags) {
            super($outer, segmentName, category, library, segmentTags);
        }
    }
}

