/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.jetty.FlexRestCompatibilityServletRequest;
import com.xebialabs.deployit.jetty.FlexRestCompatibilityServletResponse;
import com.xebialabs.deployit.rest.mappers.DeployitExceptionMapper;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseValidationFilter;
import com.xebialabs.license.service.LicenseService;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FlexLicenseValidationFilter
extends LicenseValidationFilter {
    protected static final String X_FLEX_REST = "X-Flex-Rest";
    public static final String X_ORIGINAL_STATUS_HEADER = "X-Original-Status";
    public static final String X_METHOD_OVERRIDE_HEADER = "X-HTTP-Method-Override";
    @Autowired
    private LicenseService licenseService;
    private static final Logger logger = LoggerFactory.getLogger(FlexLicenseValidationFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean installResponseCompatibilityLayer = false;
        HttpServletRequest hsr = (HttpServletRequest)request;
        if (request instanceof HttpServletRequest) {
            String brokenRest = hsr.getHeader(X_FLEX_REST);
            boolean bl = installResponseCompatibilityLayer = brokenRest != null && !"".equals(brokenRest);
        }
        if (!installResponseCompatibilityLayer) {
            super.doFilter(request, response, chain);
        } else {
            License license = this.licenseService.getLicense();
            request = new FlexRestCompatibilityServletRequest((HttpServletRequest)request, X_METHOD_OVERRIDE_HEADER);
            if (installResponseCompatibilityLayer) {
                logger.debug("Setting Flex Compatibility mode.");
                response = new FlexRestCompatibilityServletResponse((HttpServletResponse)response);
                response.setContentType("application/xml; charset=UTF-8");
                ((FlexRestCompatibilityServletResponse)response).writePreamble();
            }
            try {
                DeployitExceptionMapper.doCDataWrapping((boolean)installResponseCompatibilityLayer);
                if (license.isDummyLicense() || !this.licenseIsValid()) {
                    ((HttpServletResponse)response).setStatus(402);
                } else {
                    chain.doFilter(request, response);
                }
            }
            finally {
                DeployitExceptionMapper.doCDataWrapping((boolean)false);
            }
            if (installResponseCompatibilityLayer) {
                ((FlexRestCompatibilityServletResponse)response).writePostamble();
            }
        }
    }

    private boolean licenseIsValid() {
        try {
            this.licenseService.validate();
        }
        catch (Exception e) {
            logger.debug("Invalid license:", (Throwable)e);
            return false;
        }
        return true;
    }
}

