/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.store.access.StoreCostResult;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.conglomerate.GenericCostController;
import org.apache.derby.impl.store.access.conglomerate.OpenConglomerate;

public class HeapCostController
extends GenericCostController
implements StoreCostController {
    long num_pages;
    long num_rows;
    long page_size;
    long row_size;

    @Override
    public void init(OpenConglomerate openConglomerate) throws StandardException {
        super.init(openConglomerate);
        ContainerHandle containerHandle = openConglomerate.getContainer();
        this.num_rows = containerHandle.getEstimatedRowCount(0);
        if (this.num_rows == 0L) {
            this.num_rows = 1L;
        }
        this.num_pages = containerHandle.getEstimatedPageCount(0);
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "");
        containerHandle.getContainerProperties(properties);
        this.page_size = Integer.parseInt(properties.getProperty("derby.storage.pageSize"));
        this.row_size = this.num_pages * this.page_size / this.num_rows;
    }

    @Override
    public double getFetchFromRowLocationCost(FormatableBitSet formatableBitSet, int n) throws StandardException {
        double d = (double)this.row_size * 0.004;
        long l = this.row_size / this.page_size + 1L;
        d = (n & 1) == 0 ? (d += 1.5 * (double)l) : (d += 0.17 * (double)l);
        return d;
    }

    @Override
    public void getScanCost(int n, long l, int n2, boolean bl, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, int n3, DataValueDescriptor[] dataValueDescriptorArray3, int n4, boolean bl2, int n5, StoreCostResult storeCostResult) throws StandardException {
        long l2 = l < 0L ? this.num_rows : l;
        double d = (double)this.num_pages * 1.5;
        d += (double)(l2 * this.row_size) * 0.004;
        long l3 = l2 - this.num_pages;
        if (l3 < 0L) {
            l3 = 0L;
        }
        d = n == 2 ? (d += (double)l3 * 0.12) : (d += (double)l3 * 0.14);
        storeCostResult.setEstimatedCost(d);
        storeCostResult.setEstimatedRowCount(l2);
    }
}

