/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import liquibase.command.LiquibaseCommand;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.servicelocator.ServiceLocator;

public class CommandFactory {
    private static CommandFactory instance;
    private List<LiquibaseCommand> commands = new ArrayList<LiquibaseCommand>();

    private CommandFactory() {
        try {
            Class<LiquibaseCommand>[] classes;
            for (Class<LiquibaseCommand> clazz : classes = ServiceLocator.getInstance().findClasses(LiquibaseCommand.class)) {
                this.register(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public static synchronized CommandFactory getInstance() {
        if (instance == null) {
            instance = new CommandFactory();
        }
        return instance;
    }

    public static synchronized void reset() {
        instance = new CommandFactory();
    }

    public LiquibaseCommand getCommand(final String commandName) {
        Comparator<LiquibaseCommand> commandComparator = new Comparator<LiquibaseCommand>(){

            @Override
            public int compare(LiquibaseCommand o1, LiquibaseCommand o2) {
                return Integer.valueOf(o2.getPriority(commandName)).compareTo(o1.getPriority(commandName));
            }
        };
        ArrayList<LiquibaseCommand> sortedCommands = new ArrayList<LiquibaseCommand>(this.commands);
        Collections.sort(sortedCommands, commandComparator);
        if (sortedCommands.isEmpty()) {
            throw new UnexpectedLiquibaseException("Could not find command class for " + commandName);
        }
        try {
            LiquibaseCommand command = (LiquibaseCommand)((LiquibaseCommand)sortedCommands.iterator().next()).getClass().newInstance();
            if (command.getPriority(commandName) <= 0) {
                throw new UnexpectedLiquibaseException("Could not find command class for " + commandName);
            }
            return command;
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public void register(LiquibaseCommand command) {
        this.commands.add(command);
    }

    public void unregister(LiquibaseCommand command) {
        this.commands.remove(command);
    }
}

