/*
 * Decompiled with CFR 0.152.
 */
package liquibase.logging.core;

import liquibase.configuration.AbstractConfigurationContainer;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogLevel;

public class DefaultLoggerConfiguration
extends AbstractConfigurationContainer {
    public static final String LOG_LEVEL = "level";

    public DefaultLoggerConfiguration() {
        super("liquibase.defaultlogger");
        this.getContainer().addProperty(LOG_LEVEL, String.class).setDescription("Logging level").setDefaultValue("INFO");
    }

    public String getLogLevelName() {
        return this.getContainer().getValue(LOG_LEVEL, String.class);
    }

    public LogLevel getLogLevel() {
        String logLevel = this.getLogLevelName();
        if ("debug".equalsIgnoreCase(logLevel)) {
            return LogLevel.DEBUG;
        }
        if ("info".equalsIgnoreCase(logLevel)) {
            return LogLevel.INFO;
        }
        if ("warning".equalsIgnoreCase(logLevel)) {
            return LogLevel.WARNING;
        }
        if ("error".equalsIgnoreCase(logLevel) || "severe".equalsIgnoreCase(logLevel)) {
            return LogLevel.SEVERE;
        }
        if ("off".equalsIgnoreCase(logLevel)) {
            return LogLevel.OFF;
        }
        throw new UnexpectedLiquibaseException("Unknown log level: " + logLevel + ".  Valid levels are: debug, info, warning, error, off");
    }

    public DefaultLoggerConfiguration setLogLevel(String name) {
        this.getContainer().setValue(LOG_LEVEL, name);
        return this;
    }
}

