/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.asn1;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BERSerializable;

public class BER {
    public static final byte ASN_BOOLEAN = 1;
    public static final byte ASN_INTEGER = 2;
    public static final byte ASN_BIT_STR = 3;
    public static final byte ASN_OCTET_STR = 4;
    public static final byte ASN_NULL = 5;
    public static final byte ASN_OBJECT_ID = 6;
    public static final byte ASN_SEQUENCE = 16;
    public static final byte ASN_SET = 17;
    public static final byte ASN_UNIVERSAL = 0;
    public static final byte ASN_APPLICATION = 64;
    public static final byte ASN_CONTEXT = -128;
    public static final byte ASN_PRIVATE = -64;
    public static final byte ASN_PRIMITIVE = 0;
    public static final byte ASN_CONSTRUCTOR = 32;
    public static final byte ASN_LONG_LEN = -128;
    public static final byte ASN_EXTENSION_ID = 31;
    public static final byte ASN_BIT8 = -128;
    public static final byte INTEGER = 2;
    public static final byte INTEGER32 = 2;
    public static final byte BITSTRING = 3;
    public static final byte OCTETSTRING = 4;
    public static final byte NULL = 5;
    public static final byte OID = 6;
    public static final byte SEQUENCE = 48;
    public static final byte IPADDRESS = 64;
    public static final byte COUNTER = 65;
    public static final byte COUNTER32 = 65;
    public static final byte GAUGE = 66;
    public static final byte GAUGE32 = 66;
    public static final byte TIMETICKS = 67;
    public static final byte OPAQUE = 68;
    public static final byte COUNTER64 = 70;
    public static final int NOSUCHOBJECT = 128;
    public static final int NOSUCHINSTANCE = 129;
    public static final int ENDOFMIBVIEW = 130;
    private static final int LENMASK = 255;
    public static final int MAX_OID_LENGTH = 127;
    private static boolean checkSequenceLength = true;
    private static boolean checkValueLength = true;

    public static final void encodeHeader(OutputStream outputStream, int n, int n2) throws IOException {
        outputStream.write(n);
        BER.encodeLength(outputStream, n2);
    }

    public static final void encodeHeader(OutputStream outputStream, int n, int n2, int n3) throws IOException {
        outputStream.write(n);
        BER.encodeLength(outputStream, n2, n3);
    }

    public static final int getBERLengthOfLength(int n) {
        if (n < 0) {
            return 5;
        }
        if (n < 128) {
            return 1;
        }
        if (n <= 255) {
            return 2;
        }
        if (n <= 65535) {
            return 3;
        }
        if (n <= 0xFFFFFF) {
            return 4;
        }
        return 5;
    }

    public static final void encodeLength(OutputStream outputStream, int n) throws IOException {
        if (n < 0) {
            outputStream.write(-124);
            outputStream.write(n >> 24 & 0xFF);
            outputStream.write(n >> 16 & 0xFF);
            outputStream.write(n >> 8 & 0xFF);
            outputStream.write(n & 0xFF);
        } else if (n < 128) {
            outputStream.write(n);
        } else if (n <= 255) {
            outputStream.write(-127);
            outputStream.write(n);
        } else if (n <= 65535) {
            outputStream.write(-126);
            outputStream.write(n >> 8 & 0xFF);
            outputStream.write(n & 0xFF);
        } else if (n <= 0xFFFFFF) {
            outputStream.write(-125);
            outputStream.write(n >> 16 & 0xFF);
            outputStream.write(n >> 8 & 0xFF);
            outputStream.write(n & 0xFF);
        } else {
            outputStream.write(-124);
            outputStream.write(n >> 24 & 0xFF);
            outputStream.write(n >> 16 & 0xFF);
            outputStream.write(n >> 8 & 0xFF);
            outputStream.write(n & 0xFF);
        }
    }

    public static final void encodeLength(OutputStream outputStream, int n, int n2) throws IOException {
        outputStream.write(n2 | 0xFFFFFF80);
        for (int i = (n2 - 1) * 8; i >= 0; i -= 8) {
            outputStream.write(n >> i & 0xFF);
        }
    }

    public static final void encodeInteger(OutputStream outputStream, byte by, int n) throws IOException {
        int n2 = n;
        int n3 = 4;
        int n4 = -8388608;
        while (((n2 & n4) == 0 || (n2 & n4) == n4) && n3 > 1) {
            --n3;
            n2 <<= 8;
        }
        BER.encodeHeader(outputStream, by, n3);
        n4 = -16777216;
        while (n3-- > 0) {
            outputStream.write((n2 & n4) >> 24);
            n2 <<= 8;
        }
    }

    public static final void encodeUnsignedInteger(OutputStream outputStream, byte by, long l) throws IOException {
        int n = 1;
        if ((l >> 24 & 0xFFL) != 0L) {
            n = 4;
        } else if ((l >> 16 & 0xFFL) != 0L) {
            n = 3;
        } else if ((l >> 8 & 0xFFL) != 0L) {
            n = 2;
        }
        if ((l >> 8 * (n - 1) & 0x80L) != 0L) {
            ++n;
        }
        BER.encodeHeader(outputStream, by, n);
        if (n == 5) {
            outputStream.write(0);
            for (int i = 1; i < n; ++i) {
                outputStream.write((int)(l >> (8 * (4 - i) & 0xFF)));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                outputStream.write((int)(l >> (8 * (n - 1 - i) & 0xFF)));
            }
        }
    }

    public static final void encodeString(OutputStream outputStream, byte by, byte[] byArray) throws IOException {
        BER.encodeHeader(outputStream, by, byArray.length);
        outputStream.write(byArray);
    }

    public static final void encodeSequence(OutputStream outputStream, byte by, int n) throws IOException {
        outputStream.write(by);
        BER.encodeLength(outputStream, n);
    }

    public static final int getOIDLength(int[] nArray) {
        int n = 1;
        for (int i = 2; i < nArray.length; ++i) {
            long l = (long)nArray[i] & 0xFFFFFFFFL;
            if (l < 128L) {
                ++n;
                continue;
            }
            if (l < 16384L) {
                n += 2;
                continue;
            }
            if (l < 0x200000L) {
                n += 3;
                continue;
            }
            if (l < 0x10000000L) {
                n += 4;
                continue;
            }
            n += 5;
        }
        return n;
    }

    public static final void encodeOID(OutputStream outputStream, byte by, int[] nArray) throws IOException {
        BER.encodeHeader(outputStream, by, BER.getOIDLength(nArray));
        int n = nArray.length;
        int n2 = 0;
        if (nArray.length < 2) {
            outputStream.write(0);
            n = 0;
        } else {
            outputStream.write(nArray[1] + nArray[0] * 40 & 0xFF);
            n -= 2;
            n2 = 2;
        }
        while (n-- > 0) {
            long l;
            if ((l = (long)nArray[n2++] & 0xFFFFFFFFL) < 127L) {
                outputStream.write((int)l & 0xFF);
                continue;
            }
            long l2 = 127L;
            long l3 = 0L;
            long l4 = 127L;
            long l5 = 0L;
            while (l4 != 0L) {
                if ((l & l4) > 0L) {
                    l2 = l4;
                    l3 = l5;
                }
                l4 <<= 7;
                l5 += 7L;
            }
            while (l2 != 127L) {
                if (l2 == 0x1E00000L) {
                    l2 = 0xFE00000L;
                }
                outputStream.write((int)((l & l2) >> (int)l3 | 0xFFFFFFFFFFFFFF80L));
                l2 >>= 7;
                l3 -= 7L;
            }
            outputStream.write((int)(l & l2));
        }
    }

    public static final void encodeUnsignedInt64(OutputStream outputStream, byte by, long l) throws IOException {
        int n;
        for (n = 8; n > 1 && (l >> 8 * (n - 1) & 0xFFL) == 0L; --n) {
        }
        if ((l >> 8 * (n - 1) & 0x80L) != 0L) {
            ++n;
        }
        BER.encodeHeader(outputStream, by, n);
        if (n == 9) {
            outputStream.write(0);
            --n;
        }
        for (int i = 0; i < n; ++i) {
            outputStream.write((int)(l >> (8 * (n - 1 - i) & 0xFF)));
        }
    }

    public static final int decodeLength(BERInputStream bERInputStream) throws IOException {
        return BER.decodeLength(bERInputStream, true);
    }

    public static final int decodeLength(BERInputStream bERInputStream, boolean bl) throws IOException {
        int n = 0;
        int n2 = bERInputStream.read();
        if ((n2 & 0xFFFFFF80) > 0) {
            if ((n2 &= 0x7F) == 0) {
                throw new IOException("Indefinite lengths are not supported");
            }
            if (n2 > 4) {
                throw new IOException("Data length > 4 bytes are not supported!");
            }
            for (int i = 0; i < n2; ++i) {
                int n3 = bERInputStream.read() & 0xFF;
                n |= n3 << 8 * (n2 - 1 - i);
            }
            if (n < 0) {
                throw new IOException("SNMP does not support data lengths > 2^31");
            }
        } else {
            n = n2 & 0xFF;
        }
        if (bl) {
            BER.checkLength(bERInputStream, n);
        }
        return n;
    }

    public static final int decodeHeader(BERInputStream bERInputStream, MutableByte mutableByte, boolean bl) throws IOException {
        byte by = (byte)bERInputStream.read();
        if ((by & 0x1F) == 31) {
            throw new IOException("Cannot process extension IDs" + BER.getPositionMessage(bERInputStream));
        }
        mutableByte.setValue(by);
        return BER.decodeLength(bERInputStream, bl);
    }

    public static final int decodeHeader(BERInputStream bERInputStream, MutableByte mutableByte) throws IOException {
        return BER.decodeHeader(bERInputStream, mutableByte, true);
    }

    public static final int decodeInteger(BERInputStream bERInputStream, MutableByte mutableByte) throws IOException {
        int n = 0;
        mutableByte.setValue((byte)bERInputStream.read());
        if (mutableByte.value != 2 && mutableByte.value != 67 && mutableByte.value != 65) {
            throw new IOException("Wrong ASN.1 type. Not an integer: " + mutableByte.value + BER.getPositionMessage(bERInputStream));
        }
        int n2 = BER.decodeLength(bERInputStream);
        if (n2 > 4) {
            throw new IOException("Length greater than 32bit are not supported  for integers: " + BER.getPositionMessage(bERInputStream));
        }
        int n3 = bERInputStream.read() & 0xFF;
        if ((n3 & 0x80) > 0) {
            n = -1;
        }
        while (n2-- > 0) {
            n = n << 8 | n3;
            if (n2 <= 0) continue;
            n3 = bERInputStream.read();
        }
        return n;
    }

    private static String getPositionMessage(BERInputStream bERInputStream) {
        return " at position " + bERInputStream.getPosition();
    }

    public static final long decodeUnsignedInteger(BERInputStream bERInputStream, MutableByte mutableByte) throws IOException {
        long l = 0L;
        mutableByte.setValue((byte)bERInputStream.read());
        if (mutableByte.value != 2 && mutableByte.value != 67 && mutableByte.value != 65 && mutableByte.value != 66 && mutableByte.value != 71) {
            throw new IOException("Wrong ASN.1 type. Not an unsigned integer: " + mutableByte.value + BER.getPositionMessage(bERInputStream));
        }
        int n = BER.decodeLength(bERInputStream);
        int n2 = bERInputStream.read();
        if (n > 5 || n > 4 && n2 != 0) {
            throw new IOException("Only 32bit unsigned integers are supported" + BER.getPositionMessage(bERInputStream));
        }
        if (n2 == 0) {
            if (n > 1) {
                n2 = bERInputStream.read();
            }
            --n;
        }
        for (int i = 0; i < n; ++i) {
            l = l << 8 | (long)(n2 & 0xFF);
            if (i + 1 >= n) continue;
            n2 = bERInputStream.read();
        }
        return l;
    }

    public static final byte[] decodeString(BERInputStream bERInputStream, MutableByte mutableByte) throws IOException {
        mutableByte.setValue((byte)bERInputStream.read());
        if (mutableByte.value != 4 && mutableByte.value != 36 && mutableByte.value != 64 && mutableByte.value != 68 && mutableByte.value != 3 && mutableByte.value != 69) {
            throw new IOException("Wrong ASN.1 type. Not a string: " + mutableByte.value + BER.getPositionMessage(bERInputStream));
        }
        int n = BER.decodeLength(bERInputStream);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n && bERInputStream.available() > 0) {
            int n3 = bERInputStream.read(byArray);
            if (n3 > 0) {
                n2 += n3;
                continue;
            }
            if (n3 >= 0) continue;
            throw new IOException("Wrong string length " + n3 + " < " + n);
        }
        return byArray;
    }

    public static final int[] decodeOID(BERInputStream bERInputStream, MutableByte mutableByte) throws IOException {
        int n;
        mutableByte.setValue((byte)bERInputStream.read());
        if (mutableByte.value != 6) {
            throw new IOException("Wrong type. Not an OID: " + mutableByte.value + BER.getPositionMessage(bERInputStream));
        }
        int n2 = BER.decodeLength(bERInputStream);
        int[] nArray = new int[n2 + 2];
        if (n2 == 0) {
            nArray[1] = 0;
            nArray[0] = 0;
        }
        int n3 = 1;
        while (n2 > 0) {
            int n4;
            n = 0;
            do {
                int n5;
                if ((n5 = bERInputStream.read()) < 0) {
                    throw new IOException("Unexpected end of input stream" + BER.getPositionMessage(bERInputStream));
                }
                n4 = n5 & 0xFF;
                n = (n << 7) + (n4 & 0x7F);
            } while (--n2 > 0 && (n4 & 0xFFFFFF80) != 0);
            nArray[n3++] = n;
        }
        n = nArray[1];
        if (n == 43) {
            nArray[0] = 1;
            nArray[1] = 3;
        } else {
            nArray[1] = n % 40;
            nArray[0] = (n - nArray[1]) / 40;
        }
        if (n3 < 2) {
            n3 = 2;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public static final void decodeNull(BERInputStream bERInputStream, MutableByte mutableByte) throws IOException {
        mutableByte.setValue((byte)(bERInputStream.read() & 0xFF));
        if (mutableByte.value != 5 && mutableByte.value != -128 && mutableByte.value != -127 && mutableByte.value != -126) {
            throw new IOException("Wrong ASN.1 type. Is not null: " + mutableByte.value + BER.getPositionMessage(bERInputStream));
        }
        int n = BER.decodeLength(bERInputStream);
        if (n != 0) {
            throw new IOException("Invalid Null encoding, length is not zero: " + n + BER.getPositionMessage(bERInputStream));
        }
    }

    public static final long decodeUnsignedInt64(BERInputStream bERInputStream, MutableByte mutableByte) throws IOException {
        mutableByte.setValue((byte)bERInputStream.read());
        if (mutableByte.value != 2 && mutableByte.value != 70) {
            throw new IOException("Wrong type. Not an integer 64: " + mutableByte.value + BER.getPositionMessage(bERInputStream));
        }
        int n = BER.decodeLength(bERInputStream);
        int n2 = bERInputStream.read() & 0xFF;
        if (n > 9) {
            throw new IOException("Invalid 64bit unsigned integer length: " + n + BER.getPositionMessage(bERInputStream));
        }
        if (n2 == 0) {
            if (n > 1) {
                n2 = bERInputStream.read();
            }
            --n;
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l = l << 8 | (long)(n2 & 0xFF);
            if (i + 1 >= n) continue;
            n2 = bERInputStream.read();
        }
        return l;
    }

    public static boolean isCheckSequenceLength() {
        return checkSequenceLength;
    }

    public static void setCheckSequenceLength(boolean bl) {
        checkSequenceLength = bl;
    }

    public static void checkSequenceLength(int n, BERSerializable bERSerializable) throws IOException {
        if (BER.isCheckSequenceLength() && n != bERSerializable.getBERPayloadLength()) {
            throw new IOException("The actual length of the SEQUENCE object " + bERSerializable.getClass().getName() + " is " + bERSerializable.getBERPayloadLength() + ", but " + n + " was expected");
        }
    }

    public static void checkSequenceLength(int n, int n2, BERSerializable bERSerializable) throws IOException {
        if (BER.isCheckSequenceLength() && n != n2) {
            throw new IOException("The actual length of the SEQUENCE object " + bERSerializable.getClass().getName() + " is " + n2 + ", but " + n + " was expected");
        }
    }

    private static void checkLength(BERInputStream bERInputStream, int n) throws IOException {
        if (!checkValueLength) {
            return;
        }
        if (n < 0 || n > bERInputStream.getAvailableBytes()) {
            throw new IOException("The encoded length " + n + " exceeds the number of bytes left in input" + BER.getPositionMessage(bERInputStream) + " which actually is " + bERInputStream.getAvailableBytes());
        }
    }

    public boolean isCheckValueLength() {
        return checkValueLength;
    }

    public void setCheckValueLength(boolean bl) {
        checkValueLength = bl;
    }

    public static class MutableByte {
        byte value = 0;

        public MutableByte() {
        }

        public MutableByte(byte by) {
            this.setValue(by);
        }

        public void setValue(byte by) {
            this.value = by;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

