/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.StatusIndicator;

public class UnsafeBufferStatusIndicator
extends StatusIndicator {
    private final int counterId;
    private final long addressOffset;
    private final byte[] buffer;

    public UnsafeBufferStatusIndicator(AtomicBuffer buffer, int counterId) {
        this.counterId = counterId;
        this.buffer = buffer.byteArray();
        int counterOffset = CountersManager.counterOffset(counterId);
        buffer.boundsCheck(counterOffset, 8);
        this.addressOffset = buffer.addressOffset() + (long)counterOffset;
    }

    @Override
    public int id() {
        return this.counterId;
    }

    @Override
    public void setOrdered(long value) {
        UnsafeAccess.UNSAFE.putOrderedLong(this.buffer, this.addressOffset, value);
    }

    @Override
    public long getVolatile() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this.buffer, this.addressOffset);
    }
}

