/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.auth;

import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.rzo.netty.ahessian.auth.AuthToken;
import org.rzo.netty.ahessian.auth.AuthTokenList;
import org.rzo.netty.ahessian.auth.ByteArrayWrapper;
import org.rzo.netty.ahessian.auth.EncryptedAuthToken;
import org.rzo.netty.ahessian.auth.SimpleAuthToken;

public class AuthTokenListFactory {
    private Map<ByteArrayWrapper, AuthToken> _tokens = new HashMap<ByteArrayWrapper, AuthToken>();
    private int _length;
    private boolean _unique = true;

    public void addList(Collection<String> list, int length) {
        this._length = length;
        for (String pwd : list) {
            SimpleAuthToken token = new SimpleAuthToken();
            token.setLength(length);
            token.setPassword(pwd);
            this._tokens.put(new ByteArrayWrapper(token._password), token);
        }
    }

    public void addList(Collection<String> list, int length, String encryptionAlgorithm) {
        this._length = length;
        for (String pwd : list) {
            EncryptedAuthToken token = new EncryptedAuthToken();
            token.setLength(length);
            try {
                token.setAlgorithm(encryptionAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            token.setPassword(pwd);
            this._tokens.put(new ByteArrayWrapper(token._password), token);
        }
    }

    public void setUnique(boolean value) {
        this._unique = value;
    }

    public AuthTokenList getAuthTokenList() {
        return new AuthTokenList(this._tokens, this._length, this._unique);
    }
}

