/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.nio.ByteBuffer;
import org.python.core.io.BufferedIOBase;
import org.python.core.io.BufferedIOMixin;
import org.python.core.io.BufferedReader;
import org.python.core.io.BufferedWriter;
import org.python.core.io.RawIOBase;

public class BufferedRandom
extends BufferedIOMixin {
    protected BufferedIOBase reader;
    protected BufferedIOBase writer;

    public BufferedRandom(RawIOBase rawIO, int bufferSize) {
        super(rawIO, bufferSize);
        this.initChildBuffers();
    }

    protected void initChildBuffers() {
        this.reader = new BufferedReader(this.rawIO, this.bufferSize);
        this.writer = new BufferedWriter(this.rawIO, this.bufferSize);
    }

    @Override
    public long seek(long pos, int whence) {
        this.flush();
        pos = this.writer.seek(pos, whence);
        this.reader.clear();
        return pos;
    }

    @Override
    public long tell() {
        if (this.writer.buffered()) {
            return this.writer.tell();
        }
        return this.reader.tell();
    }

    @Override
    public ByteBuffer read(int size) {
        this.flush();
        return this.reader.read(size);
    }

    @Override
    public ByteBuffer readall() {
        this.flush();
        return this.reader.readall();
    }

    @Override
    public int readinto(ByteBuffer bytes) {
        this.flush();
        return this.reader.readinto(bytes);
    }

    @Override
    public int write(ByteBuffer bytes) {
        if (this.reader.buffered()) {
            this.reader.clear();
        }
        return this.writer.write(bytes);
    }

    @Override
    public ByteBuffer peek(int size) {
        this.flush();
        return this.reader.peek(size);
    }

    @Override
    public int read1(ByteBuffer bytes) {
        this.flush();
        return this.reader.read1(bytes);
    }

    @Override
    public void flush() {
        this.writer.flush();
    }
}

