/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.bz2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.python.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyByteArray;
import org.python.core.PyDataDescr;
import org.python.core.PyObject;
import org.python.core.PyOverridableNew;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.bz2.PyBZ2DecompressorDerived;

@ExposedType(name="bz2.BZ2Decompressor")
public class PyBZ2Decompressor
extends PyObject
implements Traverseproc {
    public PyString unused_data = Py.EmptyString;
    private boolean eofReached = false;
    private BZip2CompressorInputStream decompressStream = null;
    private byte[] accumulator = new byte[0];
    public static final PyType TYPE;

    public PyBZ2Decompressor() {
        super(TYPE);
    }

    public PyBZ2Decompressor(PyType objtype) {
        super(objtype);
    }

    @ExposedNew
    final void BZ2Decompressor___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("bz2decompressor", args, kwds, new String[0], 0);
    }

    final PyString BZ2Decompressor_decompress(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("compress", args, kwds, new String[]{"data"}, 1);
        PyString data = (PyString)ap.getPyObject(0);
        PyString returnData = Py.EmptyString;
        if (this.eofReached) {
            throw Py.EOFError("Data stream EOF reached");
        }
        byte[] indata = data.toBytes();
        if (indata.length > 0) {
            ByteBuffer bytebuf = ByteBuffer.allocate(this.accumulator.length + indata.length);
            bytebuf.put(this.accumulator);
            bytebuf.put(indata);
            this.accumulator = bytebuf.array();
        }
        ByteArrayOutputStream decodedStream = new ByteArrayOutputStream();
        byte[] buf = this.accumulator;
        for (int i = 0; i < buf.length; ++i) {
            if (i + 3 < buf.length && (char)buf[i] == '\\' && (char)buf[i + 1] == 'x') {
                int decodedByte = (Character.digit((char)buf[i + 2], 16) << 4) + Character.digit((char)buf[i + 3], 16);
                decodedStream.write(decodedByte);
                i += 3;
                continue;
            }
            decodedStream.write(buf[i]);
        }
        ByteArrayInputStream compressedData = new ByteArrayInputStream(decodedStream.toByteArray());
        try {
            this.decompressStream = new BZip2CompressorInputStream(compressedData);
        }
        catch (IOException e) {
            return Py.EmptyString;
        }
        PyByteArray databuf = new PyByteArray();
        int currentByte = -1;
        try {
            while ((currentByte = this.decompressStream.read()) != -1) {
                databuf.append((byte)currentByte);
            }
            returnData = databuf.__str__();
            if (compressedData.available() > 0) {
                byte[] unusedbuf = new byte[compressedData.available()];
                compressedData.read(unusedbuf);
                this.unused_data = (PyString)this.unused_data.__add__(new PyByteArray(unusedbuf).__str__());
            }
            this.eofReached = true;
        }
        catch (IOException e) {
            return Py.EmptyString;
        }
        return returnData;
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        return this.unused_data != null ? visit.visit(this.unused_data, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && this.unused_data == ob;
    }

    static {
        PyType.addBuilder(PyBZ2Decompressor.class, new PyBZ2Decompressor$PyExposer());
        TYPE = PyType.fromClass(PyBZ2Decompressor.class);
    }

    public class PyBZ2Decompressor$BZ2Decompressor___init___exposer
    extends PyBuiltinMethod {
        public PyBZ2Decompressor$BZ2Decompressor___init___exposer(String string2) {
            super(string2);
            this.doc = "";
        }

        public PyBZ2Decompressor$BZ2Decompressor___init___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBZ2Decompressor$BZ2Decompressor___init___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((PyBZ2Decompressor)this.self).BZ2Decompressor___init__(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class PyBZ2Decompressor$BZ2Decompressor_decompress_exposer
    extends PyBuiltinMethod {
        public PyBZ2Decompressor$BZ2Decompressor_decompress_exposer(String string2) {
            super(string2);
            this.doc = "";
        }

        public PyBZ2Decompressor$BZ2Decompressor_decompress_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyBZ2Decompressor$BZ2Decompressor_decompress_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PyBZ2Decompressor)this.self).BZ2Decompressor_decompress(pyObjectArray, stringArray);
        }
    }

    public class PyBZ2Decompressor$unused_data_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyBZ2Decompressor$unused_data_descriptor() {
            super("unused_data", PyString.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyBZ2Decompressor)pyObject).unused_data;
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyBZ2Decompressor$exposed___new__
    extends PyOverridableNew {
        public PyObject createOfType(boolean bl, PyObject[] pyObjectArray, String[] stringArray) {
            PyBZ2Decompressor pyBZ2Decompressor = new PyBZ2Decompressor(this.for_type);
            if (bl) {
                pyBZ2Decompressor.BZ2Decompressor___init__(pyObjectArray, stringArray);
            }
            return pyBZ2Decompressor;
        }

        public PyObject createOfSubtype(PyType pyType) {
            return new PyBZ2DecompressorDerived(pyType);
        }
    }

    public class PyBZ2Decompressor$PyExposer
    extends BaseTypeBuilder {
        public PyBZ2Decompressor$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyBZ2Decompressor$BZ2Decompressor___init___exposer("__init__"), new PyBZ2Decompressor$BZ2Decompressor_decompress_exposer("decompress")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyBZ2Decompressor$unused_data_descriptor()};
            super("bz2.BZ2Decompressor", PyBZ2Decompressor.class, Object.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, new PyBZ2Decompressor$exposed___new__());
        }
    }
}

