/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.python.core.PyException;
import org.python.util.PyServlet;
import org.python.util.PythonInterpreter;

public class PyFilter
implements Filter {
    public static final String FILTER_PATH_PARAM = "__filter__";
    private PythonInterpreter interp;
    private FilterConfig config;
    private File source;
    private Filter cached;
    private long loadedMtime;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain2) throws IOException, ServletException {
        request.setAttribute("pyfilter", (Object)this);
        this.getFilter().doFilter(request, response, chain2);
    }

    public void init(FilterConfig config2) throws ServletException {
        if (config2.getServletContext().getAttribute("__jython_initialized__") == null) {
            throw new ServletException("Jython has not been initialized.  Add org.python.util.PyServletInitializer as a listener to your web.xml.");
        }
        this.config = config2;
        String filterPath = config2.getInitParameter(FILTER_PATH_PARAM);
        if (filterPath == null) {
            throw new ServletException("Missing required param '__filter__'");
        }
        this.source = new File(this.getRealPath(config2.getServletContext(), filterPath));
        if (!this.source.exists()) {
            throw new ServletException(this.source.getAbsolutePath() + " does not exist.");
        }
        this.interp = PyServlet.createInterpreter(config2.getServletContext());
    }

    private String getRealPath(ServletContext context, String appPath) {
        String realPath = context.getRealPath(appPath);
        return realPath.replaceAll("\\\\", "/");
    }

    private Filter getFilter() throws ServletException, IOException {
        if (this.cached == null || this.source.lastModified() > this.loadedMtime) {
            return this.loadFilter();
        }
        return this.cached;
    }

    private Filter loadFilter() throws ServletException, IOException {
        this.loadedMtime = this.source.lastModified();
        this.cached = PyServlet.createInstance(this.interp, this.source, Filter.class);
        try {
            this.cached.init(this.config);
        }
        catch (PyException e) {
            throw new ServletException((Throwable)e);
        }
        return this.cached;
    }

    public void destroy() {
        if (this.cached != null) {
            this.cached.destroy();
        }
        if (this.interp != null) {
            this.interp.cleanup();
        }
    }
}

