/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.memento;

import com.jeta.forms.store.AbstractJETAPersistable;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;

public class IconMemento
extends AbstractJETAPersistable
implements Cloneable {
    static final long serialVersionUID = 7200914507339096976L;
    public static final int VERSION = 1;
    private byte[] m_image_bytes;
    private transient ImageIcon m_icon;

    public IconMemento() {
    }

    public IconMemento(File file) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            byte[] byArray = new byte[1024];
            int n = bufferedInputStream.read(byArray);
            while (n > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = bufferedInputStream.read(byArray);
            }
            if (byteArrayOutputStream.size() > 0) {
                this.m_image_bytes = byteArrayOutputStream.toByteArray();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ImageIcon getImageIcon() {
        if (this.m_icon == null && this.m_image_bytes != null) {
            this.m_icon = new ImageIcon(this.m_image_bytes);
        }
        return this.m_icon;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (!(object instanceof IconMemento)) {
            return false;
        }
        IconMemento iconMemento = (IconMemento)object;
        if (null == this.m_image_bytes && null != iconMemento.m_image_bytes || null != this.m_image_bytes && null == iconMemento.m_image_bytes || null != this.m_image_bytes && null != iconMemento.m_image_bytes && iconMemento.m_image_bytes.length != this.m_image_bytes.length) {
            return false;
        }
        for (int i = 0; i < this.m_image_bytes.length; ++i) {
            if (this.m_image_bytes[i] == iconMemento.m_image_bytes[i]) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        IconMemento iconMemento = null;
        try {
            iconMemento = (IconMemento)super.clone();
            iconMemento.m_image_bytes = this.m_image_bytes;
            this.m_icon = null;
            iconMemento.m_icon = this.getImageIcon();
            this.m_icon = null;
            this.getImageIcon();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return iconMemento;
    }

    public void read(JETAObjectInput jETAObjectInput) throws ClassNotFoundException, IOException {
        int n = jETAObjectInput.readVersion();
        this.m_image_bytes = (byte[])jETAObjectInput.readObject("imagebytes");
    }

    public void write(JETAObjectOutput jETAObjectOutput) throws IOException {
        jETAObjectOutput.writeVersion(1);
        jETAObjectOutput.writeObject("imagebytes", this.m_image_bytes);
    }
}

