/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FlowControl;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.agrona.BitUtil;
import org.agrona.SystemUtil;
import org.agrona.collections.ArrayListUtil;

public class PreferredMulticastFlowControl
implements FlowControl {
    private static final String RECEIVER_TIMEOUT_PROP_NAME = "aeron.PreferredMulticastFlowControl.receiverTimeout";
    private static final long RECEIVER_TIMEOUT_DEFAULT = TimeUnit.SECONDS.toNanos(2L);
    private static final long RECEIVER_TIMEOUT = SystemUtil.getDurationInNanos((String)"aeron.PreferredMulticastFlowControl.receiverTimeout", (long)RECEIVER_TIMEOUT_DEFAULT);
    private static final String PREFERRED_ASF_PROP_NAME = "aeron.PreferredMulticastFlowControl.asf";
    private static final String PREFERRED_ASF_DEFAULT = "FFFFFFFF";
    public static final String PREFERRED_ASF = System.getProperty("aeron.PreferredMulticastFlowControl.asf", "FFFFFFFF");
    public static final byte[] PREFERRED_ASF_BYTES = BitUtil.fromHex((String)PREFERRED_ASF);
    private final ArrayList<Receiver> receiverList = new ArrayList();
    private final byte[] smAsf = new byte[64];
    private volatile boolean shouldLinger = true;

    @Override
    public long onStatusMessage(StatusMessageFlyweight flyweight, InetSocketAddress receiverAddress, long senderLimit, int initialTermId, int positionBitsToShift, long timeNs) {
        long position = LogBufferDescriptor.computePosition((int)flyweight.consumptionTermId(), (int)flyweight.consumptionTermOffset(), (int)positionBitsToShift, (int)initialTermId);
        long windowLength = flyweight.receiverWindowLength();
        long receiverId = flyweight.receiverId();
        boolean isFromPreferred = this.isFromPreferred(flyweight);
        long lastPositionPlusWindow = position + windowLength;
        boolean isExisting = false;
        long minPosition = Long.MAX_VALUE;
        ArrayList<Receiver> receiverList = this.receiverList;
        int size = receiverList.size();
        for (int i = 0; i < size; ++i) {
            Receiver receiver = receiverList.get(i);
            if (isFromPreferred && receiverId == receiver.receiverId) {
                receiver.lastPosition = Math.max(position, receiver.lastPosition);
                receiver.lastPositionPlusWindow = lastPositionPlusWindow;
                receiver.timeOfLastStatusMessageNs = timeNs;
                isExisting = true;
            }
            minPosition = Math.min(minPosition, receiver.lastPositionPlusWindow);
        }
        if (isFromPreferred && !isExisting) {
            receiverList.add(new Receiver(position, lastPositionPlusWindow, timeNs, receiverId, receiverAddress));
            minPosition = Math.min(minPosition, lastPositionPlusWindow);
        }
        return receiverList.size() > 0 ? Math.max(senderLimit, minPosition) : Math.max(senderLimit, lastPositionPlusWindow);
    }

    @Override
    public void initialize(int initialTermId, int termBufferLength) {
    }

    @Override
    public long onIdle(long timeNs, long senderLimit, long senderPosition, boolean isEndOfStream) {
        int lastIndex;
        long minPosition = Long.MAX_VALUE;
        long minLimitPosition = Long.MAX_VALUE;
        ArrayList<Receiver> receiverList = this.receiverList;
        for (int i = lastIndex = receiverList.size() - 1; i >= 0; --i) {
            Receiver receiver = receiverList.get(i);
            if (timeNs > receiver.timeOfLastStatusMessageNs + RECEIVER_TIMEOUT) {
                ArrayListUtil.fastUnorderedRemove(receiverList, (int)i, (int)lastIndex--);
                continue;
            }
            minPosition = Math.min(minPosition, receiver.lastPosition);
            minLimitPosition = Math.min(minLimitPosition, receiver.lastPositionPlusWindow);
        }
        if (isEndOfStream && this.shouldLinger && (0 == receiverList.size() || minPosition >= senderPosition)) {
            this.shouldLinger = false;
        }
        return receiverList.size() > 0 ? minLimitPosition : senderLimit;
    }

    @Override
    public boolean shouldLinger(long timeNs) {
        return this.shouldLinger;
    }

    public boolean isFromPreferred(StatusMessageFlyweight sm) {
        int asfLength = sm.applicationSpecificFeedback(this.smAsf);
        boolean result = false;
        if (asfLength > 0 && asfLength >= 4 && this.smAsf[0] == PREFERRED_ASF_BYTES[0] && this.smAsf[1] == PREFERRED_ASF_BYTES[1] && this.smAsf[2] == PREFERRED_ASF_BYTES[2] && this.smAsf[3] == PREFERRED_ASF_BYTES[3]) {
            result = true;
        }
        return result;
    }

    static class Receiver {
        long lastPosition;
        long lastPositionPlusWindow;
        long timeOfLastStatusMessageNs;
        long receiverId;
        InetSocketAddress address;

        Receiver(long lastPosition, long lastPositionPlusWindow, long timeNs, long receiverId, InetSocketAddress receiverAddress) {
            this.lastPosition = lastPosition;
            this.lastPositionPlusWindow = lastPositionPlusWindow;
            this.timeOfLastStatusMessageNs = timeNs;
            this.receiverId = receiverId;
            this.address = receiverAddress;
        }
    }
}

