/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.util.regex.Pattern;
import org.jboss.resteasy.util.ArrayCharSequence;

public class PathHelper {
    public static final String URI_PARAM_NAME_REGEX = "\\w[\\w\\.-]*";
    public static final String URI_PARAM_REGEX_REGEX = "[^{}][^{}]*";
    public static final String URI_PARAM_REGEX = "\\{\\s*(\\w[\\w\\.-]*)\\s*(:\\s*([^{}][^{}]*))?\\}";
    public static final String URI_PARAM_WITH_REGEX = "\\{\\s*(\\w[\\w\\.-]*)\\s*(:\\s*([^{}][^{}]*))\\}";
    public static final String URI_PARAM_WITHOUT_REGEX = "\\{(\\w[\\w\\.-]*)\\}";
    public static final Pattern URI_PARAM_PATTERN = Pattern.compile("\\{\\s*(\\w[\\w\\.-]*)\\s*(:\\s*([^{}][^{}]*))?\\}");
    public static final Pattern URI_PARAM_WITH_REGEX_PATTERN = Pattern.compile("\\{\\s*(\\w[\\w\\.-]*)\\s*(:\\s*([^{}][^{}]*))\\}");
    public static final Pattern URI_PARAM_WITHOUT_REGEX_PATTERN = Pattern.compile("\\{(\\w[\\w\\.-]*)\\}");
    public static final Pattern URI_TEMPLATE_PATTERN = Pattern.compile("(\\{([^}]+)\\})");
    public static final String URI_TEMPLATE_REPLACE_PATTERN = "(.*?)";
    public static final char openCurlyReplacement = '\u0006';
    public static final char closeCurlyReplacement = '\u0007';

    public static String getEncodedPathInfo(String path, String contextPath) {
        if (contextPath != null && !"".equals(contextPath) && path.startsWith(contextPath)) {
            path = path.substring(contextPath.length());
        }
        return path;
    }

    public static String replaceEnclosedCurlyBraces(String str) {
        char[] chars = str.toCharArray();
        int open = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '{') {
                if (open != 0) {
                    chars[i] = 6;
                }
                ++open;
                continue;
            }
            if (chars[i] != '}' || --open == 0) continue;
            chars[i] = 7;
        }
        return new String(chars);
    }

    public static CharSequence replaceEnclosedCurlyBracesCS(String str) {
        int open = 0;
        CharSequence cs = str;
        char[] chars = null;
        for (int i = 0; i < str.length(); ++i) {
            if (cs.charAt(i) == '{') {
                if (open != 0) {
                    if (cs == str) {
                        chars = str.toCharArray();
                        cs = new ArrayCharSequence(chars);
                    }
                    chars[i] = 6;
                }
                ++open;
                continue;
            }
            if (cs.charAt(i) != '}' || --open == 0) continue;
            if (cs == str) {
                chars = str.toCharArray();
                cs = new ArrayCharSequence(chars);
            }
            chars[i] = 7;
        }
        return cs;
    }

    public static String recoverEnclosedCurlyBraces(String str) {
        return str.replace('\u0006', '{').replace('\u0007', '}');
    }
}

