/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.resteasy;

import com.xebialabs.deployit.ClosingExceptionMapper;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.repository.NodeReaderContext;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class OpenJcrSessionDuringRequestInterceptor
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger logger;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        logger.trace("Logging out...");
        OpenJcrSessionDuringRequestInterceptor.cleanup();
    }

    public static void cleanup() {
        try {
            NodeReaderContext.get().release();
            if (JcrTemplateHolder.get().isLoggedIn()) {
                JcrTemplateHolder.get().logout();
            }
        }
        catch (Exception e) {
            logger.error("Error cleaning up after OpenJcrSessionDuringRequestInterceptor", (Throwable)e);
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        NodeReaderContext.clear();
        JcrTemplateHolder.get().login();
        NodeReaderContext.get().hold();
    }

    static {
        ClosingExceptionMapper.registerCleanup(OpenJcrSessionDuringRequestInterceptor::cleanup);
        logger = LoggerFactory.getLogger(OpenJcrSessionDuringRequestInterceptor.class);
    }
}

