/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.setup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class SetupHelperMethods {
    public static final String EXITSETUP_KEYWORD = "exitsetup";

    private SetupHelperMethods() {
    }

    public static void printEmptyLine() {
        System.out.println("");
    }

    public static String read() {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = stdin.readLine();
            if (line != null) {
                String value = line.trim();
                if (EXITSETUP_KEYWORD.equals(value)) {
                    System.out.println("Exiting setup.");
                    System.exit(1);
                }
                return value;
            }
            return line;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean getBooleanResponse(boolean defaultValue) {
        String prompt = SetupHelperMethods.determinePrompt(defaultValue ? "yes" : "no");
        while (true) {
            System.out.print(prompt);
            String value = SetupHelperMethods.read();
            if ("".equals(value)) {
                return defaultValue;
            }
            if ("yes".equalsIgnoreCase(value)) {
                return true;
            }
            if ("no".equalsIgnoreCase(value)) {
                return false;
            }
            System.out.println("Illegal value specified, type yes or no.");
        }
    }

    public static String getValidNotEmptyStringResponse(String defaultValue) {
        String prompt = SetupHelperMethods.determinePrompt(defaultValue);
        while (true) {
            System.out.print(prompt);
            String value = SetupHelperMethods.read();
            if ("".equals(value) && defaultValue != null) {
                value = defaultValue;
            }
            if (!"".equals(value) && value != null) {
                return value;
            }
            System.out.println("Value cannot be empty.");
        }
    }

    public static String getStringResponse(String defaultValue) {
        String value;
        String prompt = SetupHelperMethods.determinePrompt(defaultValue);
        do {
            System.out.print(prompt);
            value = SetupHelperMethods.read();
            if (!"".equals(value)) continue;
            value = defaultValue;
        } while (value == null);
        return value;
    }

    public static String getConfirmedPassword() {
        String password = null;
        while (true) {
            if (!(password = SetupHelperMethods.getPasswordResponse("New password: ")).isEmpty() && password.length() < 6) {
                System.err.println("Password is shorter than 6 characters, please try again.\n");
                continue;
            }
            String retypedPassword = SetupHelperMethods.getPasswordResponse("Re-type password: ");
            if (password.equals(retypedPassword)) {
                return password;
            }
            SetupHelperMethods.printEmptyLine();
            System.err.println("The passwords do not match. Please try again.");
        }
    }

    public static String getPasswordResponse(String prompt) {
        char[] password = System.console().readPassword(prompt, new Object[0]);
        return new String(password);
    }

    public static int getValidIntegerResponse(int defaultValueAsAnInt) {
        String defaultValue = Integer.toString(defaultValueAsAnInt);
        String prompt = SetupHelperMethods.determinePrompt(defaultValue);
        while (true) {
            System.out.print(prompt);
            String value = SetupHelperMethods.read();
            if ("".equals(value)) {
                value = defaultValue;
            }
            try {
                int returnedValue = Integer.parseInt(value);
                if (returnedValue > 0) {
                    return returnedValue;
                }
                System.out.println("Illegal value specified. Number must be larger then 0.");
                continue;
            }
            catch (NumberFormatException nfe) {
                System.out.println("Illegal value specified. Must be a number.");
                continue;
            }
            break;
        }
    }

    public static String determinePrompt(String defaultValue) {
        String prompt = defaultValue != null ? "[" + defaultValue + "]: " : ": ";
        return prompt;
    }
}

